/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.constants;

import java.io.ObjectStreamException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnexpectedException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import net.jini.io.UnsupportedConstraintException;

public class ThrowableConstants {
    public static final int INDEFINITE = 0;
    public static final int BAD_INVOCATION = 1;
    public static final int BAD_OBJECT = 2;
    public static final int UNCATEGORIZED = 3;

    public static int retryable(Throwable t) {
        if (t == null) {
            throw new NullPointerException("Must pass a non-null Throwable");
        }
        if (t instanceof RuntimeException) {
            return 1;
        }
        if (t instanceof Error) {
            if (t instanceof OutOfMemoryError || t instanceof LinkageError) {
                return 0;
            }
            if (t instanceof StackOverflowError) {
                return 1;
            }
            return 2;
        }
        if (t instanceof RemoteException) {
            RemoteException re = (RemoteException)t;
            if (re instanceof NoSuchObjectException || re instanceof UnexpectedException || re instanceof UnknownHostException) {
                return 2;
            }
            Throwable detail = re.detail;
            if (detail == null) {
                return 0;
            }
            if (re instanceof MarshalException || re instanceof UnmarshalException) {
                if (detail instanceof ObjectStreamException) {
                    return 1;
                }
                int drs = ThrowableConstants.retryable(detail);
                if (drs == 2 || drs == 1) {
                    return 1;
                }
                return 0;
            }
            if (re instanceof ConnectIOException) {
                if (detail instanceof NoRouteToHostException || detail instanceof PortUnreachableException || detail instanceof ProtocolException) {
                    return 2;
                }
                if (detail instanceof UnsupportedConstraintException || detail instanceof ObjectStreamException) {
                    return 1;
                }
                return 0;
            }
            if (re instanceof ServerException) {
                int drs = ThrowableConstants.retryable(detail);
                if (drs == 2) {
                    return 1;
                }
                return drs;
            }
            if (re instanceof ServerError) {
                return ThrowableConstants.retryable(detail);
            }
            return 0;
        }
        return 3;
    }
}

