# Generated by Django 4.1.2 on 2022-10-10 21:24

import datetime

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Trigger',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, unique=True, verbose_name='name')),
                ('is_enabled', models.BooleanField(default=False, verbose_name='enabled')),
                ('action_count_limit', models.PositiveIntegerField(blank=True, default=1, help_text='Maximal number of actions that can be triggered for the user.', null=True, validators=[django.core.validators.MinValueValidator(1)], verbose_name='action count limit')),
                ('action_frequency_limit', models.DurationField(blank=True, default=datetime.timedelta(days=30), help_text='Minimal period of time that should run out before the next action can be triggered.', null=True, verbose_name='action frequency limit')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_%(app_label)s.%(class)s_set+', to='contenttypes.contenttype')),
            ],
            options={
                'verbose_name': 'trigger',
                'verbose_name_plural': 'triggers',
            },
        ),
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_%(app_label)s.%(class)s_set+', to='contenttypes.contenttype')),
                ('trigger', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='events', related_query_name='event', to='triggers.trigger', verbose_name='trigger')),
            ],
            options={
                'verbose_name': 'event',
                'verbose_name_plural': 'events',
            },
        ),
        migrations.CreateModel(
            name='Condition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_%(app_label)s.%(class)s_set+', to='contenttypes.contenttype')),
                ('trigger', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='conditions', related_query_name='condition', to='triggers.trigger', verbose_name='trigger')),
            ],
            options={
                'verbose_name': 'condition',
                'verbose_name_plural': 'conditions',
            },
        ),
        migrations.CreateModel(
            name='Action',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_%(app_label)s.%(class)s_set+', to='contenttypes.contenttype')),
                ('trigger', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='action', to='triggers.trigger', verbose_name='trigger')),
            ],
            options={
                'verbose_name': 'action',
                'verbose_name_plural': 'actions',
            },
        ),
        migrations.CreateModel(
            name='Activity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_action_datetime', models.DateTimeField(blank=True, null=True, verbose_name='last action')),
                ('action_count', models.PositiveIntegerField(default=0, verbose_name='actions')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_%(app_label)s.%(class)s_set+', to='contenttypes.contenttype')),
                ('trigger', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='activities', related_query_name='activity', to='triggers.trigger', verbose_name='trigger')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='trigger_activities', related_query_name='trigger_activity', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'activity',
                'verbose_name_plural': 'activities',
                'unique_together': {('trigger', 'user')},
            },
        ),
    ]
