"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const yargs = require("yargs");
const common_1 = require("../common");
const tasks_1 = require("../tasks");
const synth_1 = require("./synth");
const tasks_2 = require("./tasks");
const DEFAULT_RC = path_1.resolve(common_1.PROJEN_RC);
async function main() {
    const ya = yargs;
    ya.commandDir('cmds');
    const runtime = new tasks_1.TaskRuntime('.');
    tasks_2.discoverTaskCommands(runtime, ya);
    ya.recommendCommands();
    ya.strictCommands();
    ya.wrap(yargs.terminalWidth());
    ya.option('post', { type: 'boolean', default: true, desc: 'Run post-synthesis steps such as installing dependencies. Use --no-post to skip' });
    ya.option('watch', { type: 'boolean', default: false, desc: 'Keep running and resynthesize when projenrc changes', alias: 'w' });
    ya.options('debug', { type: 'boolean', default: false, desc: 'Debug logs' });
    ya.options('rc', { desc: 'path to .projenrc.js file', default: DEFAULT_RC, type: 'string' });
    ya.version(false);
    ya.help();
    const args = ya.argv;
    if (args.debug) {
        process.env.DEBUG = 'true';
    }
    // no command means synthesize
    if (args._.length === 0) {
        await synth_1.synth(runtime, {
            post: args.post,
            watch: args.watch,
            rcfile: args.rc,
        });
    }
}
main().catch(e => {
    console.error(e.stack);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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