"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cdk8sTypeScriptApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const component_1 = require("./component");
const tasks_1 = require("./tasks");
const typescript_1 = require("./typescript");
/**
 * (experimental) CDK8s app in TypeScript.
 *
 * @experimental
 * @pjid cdk8s-app-ts
 */
class Cdk8sTypeScriptApp extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c;
        super({
            ...options,
            sampleCode: false,
        });
        // encode a hidden assumption further down the chain
        if (this.srcdir !== 'src') {
            throw new Error('sources are expected under the "src" directory');
        }
        // encode a hidden assumption further down the chain
        if (this.testdir !== 'test') {
            throw new Error('test sources are expected under the "test" directory');
        }
        this.appEntrypoint = (_b = options.appEntrypoint) !== null && _b !== void 0 ? _b : 'main.ts';
        this.cdk8sVersion = options.cdk8sVersionPinning ? options.cdk8sVersion : `^${options.cdk8sVersion}`;
        // CLI
        this.addDeps(`cdk8s@${this.cdk8sVersion}`, 'constructs@^3.2.34', `cdk8s-plus-17@${this.cdk8sVersion}`);
        this.addDevDeps('ts-node', `cdk8s-cli@${this.cdk8sVersion}`);
        const synth = this.addTask('synth', {
            description: 'Synthesizes your cdk8s app into dist (part of "yarn build")',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'cdk8s synth',
        });
        this.addTask('import', {
            description: 'Imports API objects to your app by generating constructs.',
            category: tasks_1.TaskCategory.MISC,
            exec: 'cdk8s import',
        });
        this.gitignore.include('imports/');
        this.gitignore.include('cdk8s.yaml');
        // add synth to the build
        this.buildTask.spawn(synth);
        if ((_c = options.sampleCode) !== null && _c !== void 0 ? _c : true) {
            new SampleCode(this);
        }
    }
}
exports.Cdk8sTypeScriptApp = Cdk8sTypeScriptApp;
_a = JSII_RTTI_SYMBOL_1;
Cdk8sTypeScriptApp[_a] = { fqn: "projen.Cdk8sTypeScriptApp", version: "0.17.92" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        this.appProject = project;
    }
    synthesize() {
        const outdir = this.project.outdir;
        const srcdir = path.join(outdir, this.appProject.srcdir);
        if (fs.pathExistsSync(srcdir) && fs.readdirSync(srcdir).filter(x => x.endsWith('.ts'))) {
            return;
        }
        const srcCode = `import { Construct } from 'constructs';
import { App, Chart, ChartProps, ApiObject } from 'cdk8s';

export class MyChart extends Chart {
  constructor(scope: Construct, id: string, props: ChartProps = { }) {
    super(scope, id, props);

    const label = { app: 'hello-k8s' };



    new ApiObject(this, 'deployment', {
      apiVersion: "v1",
      kind: "Pod",
      metadata: {
          namespace: "frontend",
          name: "nginx",
          labels: label,
      },
      spec: {
          containers: [{
              name: "nginx",
              image: "nginx:1.14-alpine",
              resources: {
                  limits: {
                      memory: "20Mi",
                      cpu: 0.2,
                  },
              },
          }],
      },
    });
  }
}

const app = new App();
new MyChart(app, 'hello');
app.synth();`;
        fs.mkdirpSync(srcdir);
        fs.writeFileSync(path.join(srcdir, this.appProject.appEntrypoint), srcCode);
        const appEntrypointName = path.basename(this.appProject.appEntrypoint, '.ts');
        const cdk8sYaml = `language: typescript
app: node lib/${appEntrypointName}.js
imports:
  - k8s
    `;
        fs.writeFileSync(path.join(outdir, 'cdk8s.yaml'), cdk8sYaml);
    }
}
//# sourceMappingURL=data:application/json;base64,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