"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../../logger");
const web_1 = require("../../web");
const util_1 = require("../util");
test('defaults', () => {
    const p = new TestReactProject();
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
class TestReactProject extends web_1.ReactProject {
    constructor(options = {}) {
        super({
            ...options,
            clobber: false,
            name: 'test-nextjs-project',
            outdir: util_1.mkdtemp(),
            logging: { level: logger_1.LogLevel.OFF },
            defaultReleaseBranch: 'main',
            projenVersion: '^1.2.3',
        });
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVhY3QtcHJvamVjdC50ZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL19fdGVzdHNfXy93ZWIvcmVhY3QtcHJvamVjdC50ZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEseUNBQXdDO0FBQ3hDLG1DQUE4RDtBQUM5RCxrQ0FBaUQ7QUFFakQsSUFBSSxDQUFDLFVBQVUsRUFBRSxHQUFHLEVBQUU7SUFDcEIsTUFBTSxDQUFDLEdBQUcsSUFBSSxnQkFBZ0IsRUFBRSxDQUFDO0lBQ2pDLE1BQU0sQ0FBQyxvQkFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsZUFBZSxFQUFFLENBQUM7QUFDN0MsQ0FBQyxDQUFDLENBQUM7QUFFSCxNQUFNLGdCQUFpQixTQUFRLGtCQUFZO0lBQ3pDLFlBQVksVUFBd0MsRUFBRztRQUNyRCxLQUFLLENBQUM7WUFDSixHQUFHLE9BQU87WUFDVixPQUFPLEVBQUUsS0FBSztZQUNkLElBQUksRUFBRSxxQkFBcUI7WUFDM0IsTUFBTSxFQUFFLGNBQU8sRUFBRTtZQUNqQixPQUFPLEVBQUUsRUFBRSxLQUFLLEVBQUUsaUJBQVEsQ0FBQyxHQUFHLEVBQUU7WUFDaEMsb0JBQW9CLEVBQUUsTUFBTTtZQUM1QixhQUFhLEVBQUUsUUFBUTtTQUN4QixDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBMb2dMZXZlbCB9IGZyb20gJy4uLy4uL2xvZ2dlcic7XG5pbXBvcnQgeyBSZWFjdFByb2plY3QsIFJlYWN0UHJvamVjdE9wdGlvbnMgfSBmcm9tICcuLi8uLi93ZWInO1xuaW1wb3J0IHsgbWtkdGVtcCwgc3ludGhTbmFwc2hvdCB9IGZyb20gJy4uL3V0aWwnO1xuXG50ZXN0KCdkZWZhdWx0cycsICgpID0+IHtcbiAgY29uc3QgcCA9IG5ldyBUZXN0UmVhY3RQcm9qZWN0KCk7XG4gIGV4cGVjdChzeW50aFNuYXBzaG90KHApKS50b01hdGNoU25hcHNob3QoKTtcbn0pO1xuXG5jbGFzcyBUZXN0UmVhY3RQcm9qZWN0IGV4dGVuZHMgUmVhY3RQcm9qZWN0IHtcbiAgY29uc3RydWN0b3Iob3B0aW9uczogUGFydGlhbDxSZWFjdFByb2plY3RPcHRpb25zPiA9IHsgfSkge1xuICAgIHN1cGVyKHtcbiAgICAgIC4uLm9wdGlvbnMsXG4gICAgICBjbG9iYmVyOiBmYWxzZSxcbiAgICAgIG5hbWU6ICd0ZXN0LW5leHRqcy1wcm9qZWN0JyxcbiAgICAgIG91dGRpcjogbWtkdGVtcCgpLFxuICAgICAgbG9nZ2luZzogeyBsZXZlbDogTG9nTGV2ZWwuT0ZGIH0sXG4gICAgICBkZWZhdWx0UmVsZWFzZUJyYW5jaDogJ21haW4nLFxuICAgICAgcHJvamVuVmVyc2lvbjogJ14xLjIuMycsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==