"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../../logger");
const web_1 = require("../../web");
const util_1 = require("../util");
test('defaults', () => {
    const p = new TestNextJsTypeScriptProject();
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
test('tailwind enabled', () => {
    const p = new TestNextJsTypeScriptProject();
    expect(util_1.synthSnapshot(p)['tailwind.config.json']).toBeDefined();
    expect(util_1.synthSnapshot(p)['postcss.config.json']).toBeDefined();
});
class TestNextJsTypeScriptProject extends web_1.NextJsTypeScriptProject {
    constructor(options = {}) {
        super({
            ...options,
            clobber: false,
            name: 'test-nextjs-project',
            outdir: util_1.mkdtemp(),
            logging: { level: logger_1.LogLevel.OFF },
            defaultReleaseBranch: 'main',
            projenVersion: '^1.2.3',
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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