"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("..");
const util_1 = require("./util");
test('lines', () => {
    const project = new util_1.TestProject();
    const hello = new __1.SourceCode(project, 'test.txt');
    hello.line('this is my first source file');
    hello.line(); // empty line
    hello.line('last line');
    expect(util_1.synthSnapshot(project)['test.txt']).toStrictEqual([
        'this is my first source file',
        '',
        'last line',
    ].join('\n'));
});
test('open/close', () => {
    const project = new util_1.TestProject();
    const hello = new __1.SourceCode(project, 'test.txt');
    hello.line('level0');
    hello.open();
    hello.line('level1');
    hello.open();
    hello.line('level2');
    hello.close();
    hello.line('level1');
    hello.close();
    hello.line('level0');
    expect(util_1.synthSnapshot(project)['test.txt']).toStrictEqual([
        'level0',
        '  level1',
        '    level2',
        '  level1',
        'level0',
    ].join('\n'));
});
test('indent', () => {
    const project = new util_1.TestProject();
    const hello = new __1.SourceCode(project, 'test.txt', { indent: 4 });
    hello.line('level0');
    hello.open();
    hello.line('level1');
    hello.close();
    hello.line('level0');
    expect(util_1.synthSnapshot(project)['test.txt']).toStrictEqual([
        'level0',
        '    level1',
        'level0',
    ].join('\n'));
});
//# sourceMappingURL=data:application/json;base64,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