"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("..");
const logger_1 = require("../logger");
const util_1 = require("./util");
test('devdirs', () => {
    // GIVEN
    const project = new __1.NodeProject({
        outdir: util_1.mkdtemp(),
        name: 'test',
        logging: { level: logger_1.LogLevel.OFF },
        defaultReleaseBranch: 'master',
    });
    // WHEN
    new __1.Eslint(project, {
        devdirs: ['foo', 'bar'],
        dirs: ['mysrc'],
    });
    // THEN
    expect(util_1.synthSnapshot(project)['.eslintrc.json']).toMatchSnapshot();
});
describe('prettier', () => {
    test('snapshot', () => {
        // GIVEN
        const project = new __1.NodeProject({
            outdir: util_1.mkdtemp(),
            name: 'test',
            logging: { level: logger_1.LogLevel.OFF },
            defaultReleaseBranch: 'master',
        });
        // WHEN
        new __1.Eslint(project, {
            dirs: ['mysrc'],
            prettier: true,
        });
        // THEN
        expect(util_1.synthSnapshot(project)['.eslintrc.json']).toMatchSnapshot();
    });
    test('error on formatting when enabled', () => {
        // GIVEN
        const project = new __1.NodeProject({
            outdir: util_1.mkdtemp(),
            name: 'test',
            logging: { level: logger_1.LogLevel.OFF },
            defaultReleaseBranch: 'master',
        });
        // WHEN
        const eslint = new __1.Eslint(project, {
            dirs: ['mysrc'],
            prettier: true,
        });
        // THEN
        expect(eslint.rules).toHaveProperty('prettier/prettier', ['error']);
    });
});
//# sourceMappingURL=data:application/json;base64,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