# Copyright 2022 Cochise Ruhulessin
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
from typing import Any

import pydantic

from ckms import types
from .localkeyspecification import LocalKeySpecification


class ParameterLessKey(pydantic.BaseModel):

    async def setup(self, spec: LocalKeySpecification) -> Any:
        assert isinstance(spec.provider, types.IProvider) # nosec
        return await spec.provider.generate(
            types.GenerateKeyOperation(
                kty=spec.kty,
                curve=spec.curve,
                use=spec.use
            )
        )