"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeScalarFilterInputs = exports.makeModelConnectionField = exports.makeSubscriptionField = exports.makeModelConnectionType = exports.makeAttributeTypeEnum = exports.makeModelScalarFilterInputObject = exports.makeModelSortDirectionEnumObject = exports.makeEnumFilterInputObjects = exports.makeModelXConditionInputObject = exports.makeModelXFilterInputObject = exports.makeDeleteInputObject = exports.makeUpdateInputObject = exports.makeCreateInputObject = exports.makeNonModelInputObject = exports.getNonModelObjectArray = void 0;
const graphql_1 = require("graphql");
const graphql_transformer_common_1 = require("graphql-transformer-common");
const ModelDirectiveArgs_1 = require("./ModelDirectiveArgs");
const STRING_CONDITIONS = ['ne', 'eq', 'le', 'lt', 'ge', 'gt', 'contains', 'notContains', 'between', 'beginsWith'];
const ID_CONDITIONS = ['ne', 'eq', 'le', 'lt', 'ge', 'gt', 'contains', 'notContains', 'between', 'beginsWith'];
const INT_CONDITIONS = ['ne', 'eq', 'le', 'lt', 'ge', 'gt', 'between'];
const FLOAT_CONDITIONS = ['ne', 'eq', 'le', 'lt', 'ge', 'gt', 'between'];
const BOOLEAN_CONDITIONS = ['ne', 'eq'];
const SIZE_CONDITIONS = ['ne', 'eq', 'le', 'lt', 'ge', 'gt', 'between'];
const STRING_FUNCTIONS = new Set(['attributeExists', 'attributeType', 'size']);
const ID_FUNCTIONS = new Set(['attributeExists', 'attributeType', 'size']);
const INT_FUNCTIONS = new Set(['attributeExists', 'attributeType']);
const FLOAT_FUNCTIONS = new Set(['attributeExists', 'attributeType']);
const BOOLEAN_FUNCTIONS = new Set(['attributeExists', 'attributeType']);
const ATTRIBUTE_TYPES = ['binary', 'binarySet', 'bool', 'list', 'map', 'number', 'numberSet', 'string', 'stringSet', '_null'];
function getNonModelObjectArray(obj, ctx, pMap) {
    for (const field of obj.fields) {
        if (!graphql_transformer_common_1.isScalar(field.type)) {
            const def = ctx.getType(graphql_transformer_common_1.getBaseType(field.type));
            if (def &&
                def.kind === graphql_1.Kind.OBJECT_TYPE_DEFINITION &&
                !def.directives.find(e => e.name.value === 'model') &&
                pMap.get(def.name.value) === undefined) {
                pMap.set(def.name.value, def);
                getNonModelObjectArray(def, ctx, pMap);
            }
        }
    }
    return Array.from(pMap.values());
}
exports.getNonModelObjectArray = getNonModelObjectArray;
function makeNonModelInputObject(obj, nonModelTypes, ctx) {
    const name = graphql_transformer_common_1.ModelResourceIDs.NonModelInputObjectName(obj.name.value);
    const fields = obj.fields
        .filter((field) => {
        const fieldType = ctx.getType(graphql_transformer_common_1.getBaseType(field.type));
        if (graphql_transformer_common_1.isScalar(field.type) ||
            nonModelTypes.find(e => e.name.value === graphql_transformer_common_1.getBaseType(field.type)) ||
            (fieldType && fieldType.kind === graphql_1.Kind.ENUM_TYPE_DEFINITION)) {
            return true;
        }
        return false;
    })
        .map((field) => {
        const type = nonModelTypes.find(e => e.name.value === graphql_transformer_common_1.getBaseType(field.type))
            ? graphql_transformer_common_1.withNamedNodeNamed(field.type, graphql_transformer_common_1.ModelResourceIDs.NonModelInputObjectName(graphql_transformer_common_1.getBaseType(field.type)))
            : field.type;
        return {
            kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
            name: field.name,
            type,
            directives: [],
        };
    });
    return {
        kind: 'InputObjectTypeDefinition',
        name: {
            kind: 'Name',
            value: name,
        },
        fields,
        directives: [],
    };
}
exports.makeNonModelInputObject = makeNonModelInputObject;
function makeCreateInputObject(obj, directive, nonModelTypes, ctx, isSync = false) {
    const name = graphql_transformer_common_1.ModelResourceIDs.ModelCreateInputObjectName(obj.name.value);
    const createdAtField = ModelDirectiveArgs_1.getCreatedAtFieldName(directive);
    const updatedAtField = ModelDirectiveArgs_1.getUpdatedAtFieldName(directive);
    const autoGeneratableFieldsWithType = {
        id: ['ID'],
        [createdAtField]: ['AWSDateTime', 'String'],
        [updatedAtField]: ['AWSDateTime', 'String'],
    };
    const hasIdField = obj.fields.find(f => f.name.value === 'id');
    const fields = obj.fields
        .filter((field) => {
        const fieldType = ctx.getType(graphql_transformer_common_1.getBaseType(field.type));
        if (graphql_transformer_common_1.isScalar(field.type) ||
            nonModelTypes.find(e => e.name.value === graphql_transformer_common_1.getBaseType(field.type)) ||
            (fieldType && fieldType.kind === graphql_1.Kind.ENUM_TYPE_DEFINITION)) {
            return true;
        }
        return false;
    })
        .map((field) => {
        let type;
        const fieldName = field.name.value;
        if (Object.keys(autoGeneratableFieldsWithType).indexOf(fieldName) !== -1 &&
            autoGeneratableFieldsWithType[fieldName].indexOf(graphql_transformer_common_1.unwrapNonNull(field.type).name.value) !== -1) {
            type = graphql_transformer_common_1.unwrapNonNull(field.type);
        }
        else {
            type = nonModelTypes.find(e => e.name.value === graphql_transformer_common_1.getBaseType(field.type))
                ? graphql_transformer_common_1.withNamedNodeNamed(field.type, graphql_transformer_common_1.ModelResourceIDs.NonModelInputObjectName(graphql_transformer_common_1.getBaseType(field.type)))
                : field.type;
        }
        return {
            kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
            name: field.name,
            type,
            directives: [],
        };
    });
    if (isSync) {
        fields.push(graphql_transformer_common_1.makeInputValueDefinition('_version', graphql_transformer_common_1.makeNamedType('Int')));
    }
    return {
        kind: 'InputObjectTypeDefinition',
        name: {
            kind: 'Name',
            value: name,
        },
        fields: [
            ...(hasIdField ? [] : [graphql_transformer_common_1.makeInputValueDefinition('id', graphql_transformer_common_1.makeNamedType('ID'))]),
            ...fields,
        ],
        directives: [],
    };
}
exports.makeCreateInputObject = makeCreateInputObject;
function makeUpdateInputObject(obj, nonModelTypes, ctx, isSync = false) {
    const name = graphql_transformer_common_1.ModelResourceIDs.ModelUpdateInputObjectName(obj.name.value);
    const fields = obj.fields
        .filter(f => {
        const fieldType = ctx.getType(graphql_transformer_common_1.getBaseType(f.type));
        if (graphql_transformer_common_1.isScalar(f.type) ||
            nonModelTypes.find(e => e.name.value === graphql_transformer_common_1.getBaseType(f.type)) ||
            (fieldType && fieldType.kind === graphql_1.Kind.ENUM_TYPE_DEFINITION)) {
            return true;
        }
        return false;
    })
        .map((field) => {
        let type;
        if (field.name.value === 'id') {
            type = graphql_transformer_common_1.wrapNonNull(field.type);
        }
        else {
            type = graphql_transformer_common_1.unwrapNonNull(field.type);
        }
        type = nonModelTypes.find(e => e.name.value === graphql_transformer_common_1.getBaseType(field.type))
            ? graphql_transformer_common_1.withNamedNodeNamed(type, graphql_transformer_common_1.ModelResourceIDs.NonModelInputObjectName(graphql_transformer_common_1.getBaseType(field.type)))
            : type;
        return {
            kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
            name: field.name,
            type,
            directives: [],
        };
    });
    if (isSync) {
        fields.push(graphql_transformer_common_1.makeInputValueDefinition('_version', graphql_transformer_common_1.makeNamedType('Int')));
    }
    return {
        kind: graphql_1.Kind.INPUT_OBJECT_TYPE_DEFINITION,
        name: {
            kind: 'Name',
            value: name,
        },
        fields,
        directives: [],
    };
}
exports.makeUpdateInputObject = makeUpdateInputObject;
function makeDeleteInputObject(obj, isSync = false) {
    const name = graphql_transformer_common_1.ModelResourceIDs.ModelDeleteInputObjectName(obj.name.value);
    const fields = [
        {
            kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
            name: { kind: 'Name', value: 'id' },
            type: graphql_transformer_common_1.makeNamedType('ID'),
            directives: [],
        },
    ];
    if (isSync) {
        fields.push(graphql_transformer_common_1.makeInputValueDefinition('_version', graphql_transformer_common_1.makeNamedType('Int')));
    }
    return {
        kind: graphql_1.Kind.INPUT_OBJECT_TYPE_DEFINITION,
        name: {
            kind: 'Name',
            value: name,
        },
        fields,
        directives: [],
    };
}
exports.makeDeleteInputObject = makeDeleteInputObject;
function makeModelXFilterInputObject(obj, ctx, supportsConditions) {
    const name = graphql_transformer_common_1.ModelResourceIDs.ModelFilterInputTypeName(obj.name.value);
    const fields = obj.fields
        .filter((field) => {
        const fieldType = ctx.getType(graphql_transformer_common_1.getBaseType(field.type));
        if (graphql_transformer_common_1.isScalar(field.type) || (fieldType && fieldType.kind === graphql_1.Kind.ENUM_TYPE_DEFINITION)) {
            return true;
        }
    })
        .map((field) => {
        const baseType = graphql_transformer_common_1.getBaseType(field.type);
        const fieldType = ctx.getType(baseType);
        const isList = graphql_transformer_common_1.isListType(field.type);
        const isEnumType = fieldType && fieldType.kind === graphql_1.Kind.ENUM_TYPE_DEFINITION;
        const filterTypeName = isEnumType && isList
            ? graphql_transformer_common_1.ModelResourceIDs.ModelFilterListInputTypeName(baseType, !supportsConditions)
            : graphql_transformer_common_1.ModelResourceIDs.ModelScalarFilterInputTypeName(baseType, !supportsConditions);
        return {
            kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
            name: field.name,
            type: graphql_transformer_common_1.makeNamedType(filterTypeName),
            directives: [],
        };
    });
    fields.push({
        kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
        name: {
            kind: 'Name',
            value: 'and',
        },
        type: graphql_transformer_common_1.makeListType(graphql_transformer_common_1.makeNamedType(name)),
        directives: [],
    }, {
        kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
        name: {
            kind: 'Name',
            value: 'or',
        },
        type: graphql_transformer_common_1.makeListType(graphql_transformer_common_1.makeNamedType(name)),
        directives: [],
    }, {
        kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
        name: {
            kind: 'Name',
            value: 'not',
        },
        type: graphql_transformer_common_1.makeNamedType(name),
        directives: [],
    });
    return {
        kind: 'InputObjectTypeDefinition',
        name: {
            kind: 'Name',
            value: name,
        },
        fields,
        directives: [],
    };
}
exports.makeModelXFilterInputObject = makeModelXFilterInputObject;
function makeModelXConditionInputObject(obj, ctx, supportsConditions) {
    const name = graphql_transformer_common_1.ModelResourceIDs.ModelConditionInputTypeName(obj.name.value);
    const fields = obj.fields
        .filter((field) => {
        const fieldType = ctx.getType(graphql_transformer_common_1.getBaseType(field.type));
        if (graphql_transformer_common_1.isScalar(field.type) || (fieldType && fieldType.kind === graphql_1.Kind.ENUM_TYPE_DEFINITION)) {
            return true;
        }
    })
        .map((field) => {
        const baseType = graphql_transformer_common_1.getBaseType(field.type);
        const fieldType = ctx.getType(baseType);
        const isList = graphql_transformer_common_1.isListType(field.type);
        const isEnumType = fieldType && fieldType.kind === graphql_1.Kind.ENUM_TYPE_DEFINITION;
        const conditionTypeName = isEnumType && isList
            ? graphql_transformer_common_1.ModelResourceIDs.ModelFilterListInputTypeName(baseType, !supportsConditions)
            : graphql_transformer_common_1.ModelResourceIDs.ModelScalarFilterInputTypeName(baseType, !supportsConditions);
        return {
            kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
            name: field.name,
            type: graphql_transformer_common_1.makeNamedType(conditionTypeName),
            directives: [],
        };
    });
    fields.push({
        kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
        name: {
            kind: 'Name',
            value: 'and',
        },
        type: graphql_transformer_common_1.makeListType(graphql_transformer_common_1.makeNamedType(name)),
        directives: [],
    }, {
        kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
        name: {
            kind: 'Name',
            value: 'or',
        },
        type: graphql_transformer_common_1.makeListType(graphql_transformer_common_1.makeNamedType(name)),
        directives: [],
    }, {
        kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
        name: {
            kind: 'Name',
            value: 'not',
        },
        type: graphql_transformer_common_1.makeNamedType(name),
        directives: [],
    });
    return {
        kind: 'InputObjectTypeDefinition',
        name: {
            kind: 'Name',
            value: name,
        },
        fields,
        directives: [],
    };
}
exports.makeModelXConditionInputObject = makeModelXConditionInputObject;
function makeEnumFilterInputObjects(obj, ctx, supportsConditions) {
    return obj.fields
        .filter((field) => {
        const fieldType = ctx.getType(graphql_transformer_common_1.getBaseType(field.type));
        return fieldType && fieldType.kind === graphql_1.Kind.ENUM_TYPE_DEFINITION;
    })
        .map((enumField) => {
        const typeName = graphql_transformer_common_1.getBaseType(enumField.type);
        const isList = graphql_transformer_common_1.isListType(enumField.type);
        const name = isList
            ? graphql_transformer_common_1.ModelResourceIDs.ModelFilterListInputTypeName(typeName, !supportsConditions)
            : graphql_transformer_common_1.ModelResourceIDs.ModelScalarFilterInputTypeName(typeName, !supportsConditions);
        const fields = [];
        fields.push({
            kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
            name: {
                kind: 'Name',
                value: 'eq',
            },
            type: isList ? graphql_transformer_common_1.makeListType(graphql_transformer_common_1.makeNamedType(typeName)) : graphql_transformer_common_1.makeNamedType(typeName),
            directives: [],
        });
        fields.push({
            kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
            name: {
                kind: 'Name',
                value: 'ne',
            },
            type: isList ? graphql_transformer_common_1.makeListType(graphql_transformer_common_1.makeNamedType(typeName)) : graphql_transformer_common_1.makeNamedType(typeName),
            directives: [],
        });
        if (isList) {
            fields.push({
                kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
                name: {
                    kind: 'Name',
                    value: 'contains',
                },
                type: graphql_transformer_common_1.makeNamedType(typeName),
                directives: [],
            });
            fields.push({
                kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
                name: {
                    kind: 'Name',
                    value: 'notContains',
                },
                type: graphql_transformer_common_1.makeNamedType(typeName),
                directives: [],
            });
        }
        return {
            kind: graphql_1.Kind.INPUT_OBJECT_TYPE_DEFINITION,
            name: {
                kind: 'Name',
                value: name,
            },
            fields,
            directives: [],
        };
    });
}
exports.makeEnumFilterInputObjects = makeEnumFilterInputObjects;
function makeModelSortDirectionEnumObject() {
    const name = graphql_transformer_common_1.graphqlName('ModelSortDirection');
    return {
        kind: graphql_1.Kind.ENUM_TYPE_DEFINITION,
        name: {
            kind: 'Name',
            value: name,
        },
        values: [
            {
                kind: graphql_1.Kind.ENUM_VALUE_DEFINITION,
                name: { kind: 'Name', value: 'ASC' },
                directives: [],
            },
            {
                kind: graphql_1.Kind.ENUM_VALUE_DEFINITION,
                name: { kind: 'Name', value: 'DESC' },
                directives: [],
            },
        ],
        directives: [],
    };
}
exports.makeModelSortDirectionEnumObject = makeModelSortDirectionEnumObject;
function makeModelScalarFilterInputObject(type, supportsConditions) {
    const name = graphql_transformer_common_1.ModelResourceIDs.ModelFilterScalarInputTypeName(type, !supportsConditions);
    const conditions = getScalarConditions(type);
    const fields = conditions.map((condition) => ({
        kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
        name: { kind: 'Name', value: condition },
        type: getScalarFilterInputType(condition, type, name),
        directives: [],
    }));
    let functionInputFields = [];
    if (supportsConditions) {
        functionInputFields = makeFunctionInputFields(type);
    }
    return {
        kind: graphql_1.Kind.INPUT_OBJECT_TYPE_DEFINITION,
        name: {
            kind: 'Name',
            value: name,
        },
        fields: [...fields, ...functionInputFields],
        directives: [],
    };
}
exports.makeModelScalarFilterInputObject = makeModelScalarFilterInputObject;
function getScalarFilterInputType(condition, type, filterInputName) {
    switch (condition) {
        case 'between':
            return graphql_transformer_common_1.makeListType(graphql_transformer_common_1.makeNamedType(type));
        case 'and':
        case 'or':
            return graphql_transformer_common_1.makeNamedType(filterInputName);
        default:
            return graphql_transformer_common_1.makeNamedType(type);
    }
}
function getScalarConditions(type) {
    switch (type) {
        case 'String':
            return STRING_CONDITIONS;
        case 'ID':
            return ID_CONDITIONS;
        case 'Int':
            return INT_CONDITIONS;
        case 'Float':
            return FLOAT_CONDITIONS;
        case 'Boolean':
            return BOOLEAN_CONDITIONS;
        default:
            throw new Error('Valid types are String, ID, Int, Float, Boolean');
    }
}
function makeSizeInputType() {
    const name = graphql_transformer_common_1.ModelResourceIDs.ModelSizeInputTypeName();
    const fields = SIZE_CONDITIONS.map((condition) => ({
        kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
        name: { kind: 'Name', value: condition },
        type: getScalarFilterInputType(condition, 'Int', ''),
        directives: [],
    }));
    return {
        kind: graphql_1.Kind.INPUT_OBJECT_TYPE_DEFINITION,
        name: {
            kind: 'Name',
            value: name,
        },
        fields,
        directives: [],
    };
}
function getFunctionListForType(typeName) {
    switch (typeName) {
        case 'String':
            return STRING_FUNCTIONS;
        case 'ID':
            return ID_FUNCTIONS;
        case 'Int':
            return INT_FUNCTIONS;
        case 'Float':
            return FLOAT_FUNCTIONS;
        case 'Boolean':
            return BOOLEAN_FUNCTIONS;
        default:
            throw new Error('Valid types are String, ID, Int, Float, Boolean');
    }
}
function makeFunctionInputFields(typeName) {
    const functions = getFunctionListForType(typeName);
    const fields = new Array();
    if (functions.has('attributeExists')) {
        fields.push({
            kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
            name: { kind: 'Name', value: 'attributeExists' },
            type: graphql_transformer_common_1.makeNamedType('Boolean'),
            directives: [],
        });
    }
    if (functions.has('attributeType')) {
        fields.push({
            kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
            name: { kind: 'Name', value: 'attributeType' },
            type: graphql_transformer_common_1.makeNamedType(graphql_transformer_common_1.ModelResourceIDs.ModelAttributeTypesName()),
            directives: [],
        });
    }
    if (functions.has('size')) {
        fields.push({
            kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
            name: { kind: 'Name', value: 'size' },
            type: graphql_transformer_common_1.makeNamedType(graphql_transformer_common_1.ModelResourceIDs.ModelSizeInputTypeName()),
            directives: [],
        });
    }
    return fields;
}
function makeAttributeTypeEnum() {
    const makeEnumValue = (enumValue) => ({
        kind: graphql_1.Kind.ENUM_VALUE_DEFINITION,
        name: { kind: 'Name', value: enumValue },
        directives: [],
    });
    return {
        kind: graphql_1.Kind.ENUM_TYPE_DEFINITION,
        name: { kind: 'Name', value: graphql_transformer_common_1.ModelResourceIDs.ModelAttributeTypesName() },
        values: ATTRIBUTE_TYPES.map(t => makeEnumValue(t)),
        directives: [],
    };
}
exports.makeAttributeTypeEnum = makeAttributeTypeEnum;
function makeModelConnectionType(typeName, isSync = false) {
    const connectionName = graphql_transformer_common_1.ModelResourceIDs.ModelConnectionTypeName(typeName);
    let connectionTypeExtension = graphql_transformer_common_1.blankObjectExtension(connectionName);
    connectionTypeExtension = graphql_transformer_common_1.extensionWithFields(connectionTypeExtension, [graphql_transformer_common_1.makeField('items', [], graphql_transformer_common_1.makeListType(graphql_transformer_common_1.makeNamedType(typeName)))]);
    connectionTypeExtension = graphql_transformer_common_1.extensionWithFields(connectionTypeExtension, [graphql_transformer_common_1.makeField('nextToken', [], graphql_transformer_common_1.makeNamedType('String'))]);
    if (isSync) {
        connectionTypeExtension = graphql_transformer_common_1.extensionWithFields(connectionTypeExtension, [graphql_transformer_common_1.makeField('startedAt', [], graphql_transformer_common_1.makeNamedType('AWSTimestamp'))]);
    }
    return connectionTypeExtension;
}
exports.makeModelConnectionType = makeModelConnectionType;
function makeSubscriptionField(fieldName, returnTypeName, mutations) {
    return graphql_transformer_common_1.makeField(fieldName, [], graphql_transformer_common_1.makeNamedType(returnTypeName), [
        graphql_transformer_common_1.makeDirective('aws_subscribe', [graphql_transformer_common_1.makeArgument('mutations', graphql_transformer_common_1.makeValueNode(mutations))]),
    ]);
}
exports.makeSubscriptionField = makeSubscriptionField;
function makeModelConnectionField(fieldName, returnTypeName, sortKeyInfo, directives) {
    const args = [
        graphql_transformer_common_1.makeInputValueDefinition('filter', graphql_transformer_common_1.makeNamedType(graphql_transformer_common_1.ModelResourceIDs.ModelFilterInputTypeName(returnTypeName))),
        graphql_transformer_common_1.makeInputValueDefinition('sortDirection', graphql_transformer_common_1.makeNamedType('ModelSortDirection')),
        graphql_transformer_common_1.makeInputValueDefinition('limit', graphql_transformer_common_1.makeNamedType('Int')),
        graphql_transformer_common_1.makeInputValueDefinition('nextToken', graphql_transformer_common_1.makeNamedType('String')),
    ];
    if (sortKeyInfo) {
        let namedType;
        if (sortKeyInfo.typeName === 'Composite') {
            namedType = graphql_transformer_common_1.makeNamedType(graphql_transformer_common_1.ModelResourceIDs.ModelCompositeKeyConditionInputTypeName(sortKeyInfo.model, graphql_transformer_common_1.toUpper(sortKeyInfo.keyName)));
        }
        else {
            namedType = graphql_transformer_common_1.makeNamedType(graphql_transformer_common_1.ModelResourceIDs.ModelKeyConditionInputTypeName(sortKeyInfo.typeName));
        }
        args.unshift(graphql_transformer_common_1.makeInputValueDefinition(sortKeyInfo.fieldName, namedType));
    }
    return graphql_transformer_common_1.makeField(fieldName, args, graphql_transformer_common_1.makeNamedType(graphql_transformer_common_1.ModelResourceIDs.ModelConnectionTypeName(returnTypeName)), directives);
}
exports.makeModelConnectionField = makeModelConnectionField;
function makeScalarFilterInputs(supportsConditions) {
    const inputs = [
        makeModelScalarFilterInputObject('String', supportsConditions),
        makeModelScalarFilterInputObject('ID', supportsConditions),
        makeModelScalarFilterInputObject('Int', supportsConditions),
        makeModelScalarFilterInputObject('Float', supportsConditions),
        makeModelScalarFilterInputObject('Boolean', supportsConditions),
    ];
    if (supportsConditions) {
        inputs.push(makeSizeInputType());
    }
    return inputs;
}
exports.makeScalarFilterInputs = makeScalarFilterInputs;
//# sourceMappingURL=definitions.js.map