"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeFromDeploymentSecrets = exports.mergeDeploymentSecrets = void 0;
const lodash_1 = __importDefault(require("lodash"));
exports.mergeDeploymentSecrets = (deploymentSecretsModifier) => {
    const { currentDeploymentSecrets, category, rootStackId, envName, resource, keyName, value } = deploymentSecretsModifier;
    const newDeploymentAppSecret = lodash_1.default.find(currentDeploymentSecrets.appSecrets, appSecret => appSecret.rootStackId === rootStackId) || {
        rootStackId,
        environments: {},
    };
    lodash_1.default.set(newDeploymentAppSecret, ['environments', envName, category, resource, keyName], value);
    return {
        appSecrets: [...currentDeploymentSecrets.appSecrets.filter(appSecret => appSecret.rootStackId !== rootStackId), newDeploymentAppSecret],
    };
};
exports.removeFromDeploymentSecrets = (deploymentSecretsModifier) => {
    const { currentDeploymentSecrets, category, rootStackId, envName, resource, keyName } = deploymentSecretsModifier;
    const secretsByAppId = lodash_1.default.find(currentDeploymentSecrets.appSecrets, secrets => secrets.rootStackId === rootStackId);
    if (secretsByAppId) {
        recursiveOmit(secretsByAppId.environments, [envName, category, resource, keyName]);
        if (Object.keys(secretsByAppId.environments).length === 0) {
            currentDeploymentSecrets.appSecrets = currentDeploymentSecrets.appSecrets.filter(r => r.rootStackId !== rootStackId);
        }
    }
    return currentDeploymentSecrets;
};
const recursiveOmit = (obj, path) => {
    if (path.length === 0)
        return;
    const currentKey = path[0];
    if (path.length === 1 && !!obj[currentKey]) {
        delete obj[currentKey];
        return;
    }
    if (!obj[currentKey]) {
        return;
    }
    recursiveOmit(obj[currentKey], path.slice(1));
    if (obj[currentKey] && lodash_1.default.isEmpty(obj[currentKey])) {
        delete obj[currentKey];
    }
};
//# sourceMappingURL=deploymentSecretsHelper.js.map