# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
try:
    from pydantic.v1 import BaseModel, Field, StrictInt, conlist
except ImportError:
    from pydantic import BaseModel, Field, StrictInt, conlist
from lakefs_sdk.models.garbage_collection_rule import GarbageCollectionRule

class GarbageCollectionRules(BaseModel):
    """
    GarbageCollectionRules
    """
    default_retention_days: StrictInt = Field(...)
    branches: conlist(GarbageCollectionRule) = Field(...)
    __properties = ["default_retention_days", "branches"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GarbageCollectionRules:
        """Create an instance of GarbageCollectionRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in branches (list)
        _items = []
        if self.branches:
            for _item in self.branches:
                if _item:
                    _items.append(_item.to_dict())
            _dict['branches'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GarbageCollectionRules:
        """Create an instance of GarbageCollectionRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GarbageCollectionRules.parse_obj(obj)

        _obj = GarbageCollectionRules.parse_obj({
            "default_retention_days": obj.get("default_retention_days"),
            "branches": [GarbageCollectionRule.from_dict(_item) for _item in obj.get("branches")] if obj.get("branches") is not None else None
        })
        return _obj


