"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Key = exports.KeyProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kms_generated_1 = require("./kms.generated");
Object.defineProperty(exports, "KeyProperty", { enumerable: true, get: function () { return kms_generated_1.RosKey; } });
/**
 * A ROS resource type:  `ALIYUN::KMS::Key`
 */
class Key extends ros.Resource {
    /**
     * Create a new `ALIYUN::KMS::Key`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosKey = new kms_generated_1.RosKey(this, id, {
            protectionLevel: props.protectionLevel,
            description: props.description,
            rotationInterval: props.rotationInterval,
            enableAutomaticRotation: props.enableAutomaticRotation,
            pendingWindowInDays: props.pendingWindowInDays === undefined || props.pendingWindowInDays === null ? 30 : props.pendingWindowInDays,
            keySpec: props.keySpec,
            enable: props.enable === undefined || props.enable === null ? true : props.enable,
            keyUsage: props.keyUsage === undefined || props.keyUsage === null ? 'ENCRYPT/DECRYPT' : props.keyUsage,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosKey;
        this.attrKeyId = rosKey.attrKeyId;
    }
}
exports.Key = Key;
//# sourceMappingURL=data:application/json;base64,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