import os

from pyexcel_pdfr import get_data

import pyexcel as p
from nose.tools import eq_


def test_simple_pdf():
    book = p.get_book(file_name=get_fixtures("simple.pdf"))
    eq_(book.number_of_sheets(), 1)
    eq_(book[0].name, "pyexcel_sheet_0")
    expected = """pyexcel_sheet_0:
+--------------------+--------------------+
| 540.7203515625     | 508.32             |
+--------------------+--------------------+
| 508.32             | 495.84             |
+--------------------+--------------------+
| 495.84             | 483.59999999999997 |
+--------------------+--------------------+
| 483.59999999999997 | 471.12             |
+--------------------+--------------------+
| 471.12             | 458.88             |
+--------------------+--------------------+
| 458.88             | 446.4              |
+--------------------+--------------------+
| 446.4              | 434.15999999999997 |
+--------------------+--------------------+
| 434.15999999999997 | 421.68             |
+--------------------+--------------------+
| 421.68             | 409.44             |
+--------------------+--------------------+
| 409.44             | 396.96             |
+--------------------+--------------------+
| 396.96             | 376.8              |
+--------------------+--------------------+
| 376.8              | 364.32             |
+--------------------+--------------------+
| 364.32             | 344.15999999999997 |
+--------------------+--------------------+
| 344.15999999999997 | 331.68             |
+--------------------+--------------------+
| 331.68             | 319.44             |
+--------------------+--------------------+
| 319.44             | 306.96             |
+--------------------+--------------------+
| 306.96             | 294.71999999999997 |
+--------------------+--------------------+
| 294.71999999999997 | 282.24             |
+--------------------+--------------------+
| 282.24             | 270.0              |
+--------------------+--------------------+
| 270.0              | 257.52             |
+--------------------+--------------------+
| 257.52             | 245.28             |
+--------------------+--------------------+
| 245.28             | 232.79999999999998 |
+--------------------+--------------------+
| 232.79999999999998 | 220.56             |
+--------------------+--------------------+
| 220.56             | 208.07999999999998 |
+--------------------+--------------------+
| 208.07999999999998 | 195.84             |
+--------------------+--------------------+
| 195.84             | 183.35999999999999 |
+--------------------+--------------------+
| 183.35999999999999 | 171.12             |
+--------------------+--------------------+
| 171.12             | 158.64             |
+--------------------+--------------------+
| 158.64             | 146.4              |
+--------------------+--------------------+
| 146.4              | 126.0              |
+--------------------+--------------------+
| 126.0              | 113.75999999999999 |
+--------------------+--------------------+
| 113.75999999999999 | 101.52             |
+--------------------+--------------------+
| 101.52             | 89.03999999999999  |
+--------------------+--------------------+
| 89.03999999999999  | 76.32              |
+--------------------+--------------------+"""
    eq_(str(book[0]), expected)


def test_complex_pdf():
    data = get_data(get_fixtures("foo.pdf"))
    expected = [
        [233.77499999999998, 218.43],
        [218.43, 195.12],
        [195.12, 179.51999999999998],
        [179.51999999999998, 163.92],
        [163.92, 148.56],
        [148.56, 132.96],
        [132.96, 117.24],
    ]
    eq_(data["pyexcel_sheet_0"], expected)


def get_fixtures(file_name):
    return os.path.join("tests", "fixtures", file_name)
