"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaAuthorizer = exports.HttpLambdaResponseType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("@aws-cdk/aws-apigatewayv2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
/**
 * (experimental) Specifies the type responses the lambda returns.
 *
 * @experimental
 */
var HttpLambdaResponseType;
(function (HttpLambdaResponseType) {
    HttpLambdaResponseType[HttpLambdaResponseType["SIMPLE"] = 0] = "SIMPLE";
    HttpLambdaResponseType[HttpLambdaResponseType["IAM"] = 1] = "IAM";
})(HttpLambdaResponseType = exports.HttpLambdaResponseType || (exports.HttpLambdaResponseType = {}));
/**
 * (experimental) Authorize Http Api routes via a lambda function.
 *
 * @experimental
 */
class HttpLambdaAuthorizer {
    /**
     * (experimental) Initialize a lambda authorizer to be bound with HTTP route.
     *
     * @param id The id of the underlying construct.
     * @param props Properties to configure the authorizer.
     * @experimental
     */
    constructor(id, handler, props = {}) {
        this.id = id;
        this.handler = handler;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_HttpLambdaAuthorizerProps(props);
    }
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c, _d, _e;
        if (this.httpApi && (this.httpApi.apiId !== options.route.httpApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            const responseTypes = (_b = this.props.responseTypes) !== null && _b !== void 0 ? _b : [HttpLambdaResponseType.IAM];
            const enableSimpleResponses = responseTypes.includes(HttpLambdaResponseType.SIMPLE) || undefined;
            this.httpApi = options.route.httpApi;
            this.authorizer = new aws_apigatewayv2_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_c = this.props.identitySource) !== null && _c !== void 0 ? _c : [
                    '$request.header.Authorization',
                ],
                type: aws_apigatewayv2_1.HttpAuthorizerType.LAMBDA,
                authorizerName: (_d = this.props.authorizerName) !== null && _d !== void 0 ? _d : this.id,
                enableSimpleResponses,
                payloadFormatVersion: enableSimpleResponses ? aws_apigatewayv2_1.AuthorizerPayloadVersion.VERSION_2_0 : aws_apigatewayv2_1.AuthorizerPayloadVersion.VERSION_1_0,
                authorizerUri: lambdaAuthorizerArn(this.handler),
                resultsCacheTtl: (_e = this.props.resultsCacheTtl) !== null && _e !== void 0 ? _e : core_1.Duration.minutes(5),
            });
            this.handler.addPermission(`${core_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: core_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.httpApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.HttpLambdaAuthorizer = HttpLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers.HttpLambdaAuthorizer", version: "1.143.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${core_1.Stack.of(handler).partition}:apigateway:${core_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,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