#! /usr/bin/env python3
# -*- coding: utf-8 -*-
# @Time    : 2021-10-18 17:25
# @Site    :
# @File    : DBHelper.py
# @Software: PyCharm


def create_in_sql(table_name: str, data: dict, conversion=False, update=False):
    """
    传入字典和表名，返回组装好的sql
    sql中的插入字段为传入字典的key
    conversion:是否全部转换成字符串类型
    update:是否启动更新语句
    data = {'w':'d1','ew':'d2','wr':'d3','wa':'d4'}
    """
    sql = 'insert into ' + table_name + ' ('
    data_keys = [key for key in data.keys()]
    for key in data_keys:
        sql += key
        if data_keys.index(key) != len(data_keys) - 1:
            sql += ','
        else:
            sql += ')  values ('
            for key in data_keys:
                value = data.get(key)
                if isinstance(value, str) or conversion:
                    sql += f'"{value}",'
                elif value == None:
                    sql += f'null,'
                else:
                    sql += f'{value},'
            sql = sql.rstrip(',')
    if update:
        sql += ")  ON DUPLICATE KEY UPDATE "
        for key in data_keys:
            sql += key + '=' + f'values({key}),'
        sql = sql.rstrip(',')
        sql += ";"
    else:
        sql += ");"
    return sql

def create_many_sql(table_name: str, data_list: list, conversion=False, update=False):
    """
    传入字典和表名，返回组装好的sql
    sql中的插入字段为传入字典的key
    conversion:是否全部转换成字符串类型
    update:是否启动更新语句
    data = [{'w':'d1','ew':'d2','wr':'d3','wa':'d4'},{'w':'d1','ew':'d2','wr':'d3','wa':'d4'},{'w':'d1','ew':'d2','wr':'d3','wa':'d4'}]
    """

    rel_data = []
    data = data_list[0]
    sql = 'insert into ' + table_name + ' ('
    data_keys = [key for key in data.keys()]
    for key in data_keys:
        item_list = []
        sql += key
        if data_keys.index(key) != len(data_keys) - 1:
            sql += ','
        else:
            sql += ')  values ('
            for key in data_keys:
                value = data.get(key)
                # if isinstance(value, str) or conversion:
                #     sql += f'"%s",'
                if value == None:
                    sql += f'null,'
                else:
                    sql += f'%s,'
            sql = sql.rstrip(',')
    if update:
        sql += ")  ON DUPLICATE KEY UPDATE "
        for key in data_keys:
            sql += key + '=' + f'values({key}),'
        sql = sql.rstrip(',')
        sql += ";"
    else:
        sql += ");"
    for item in data_list:
        rel_data.append(tuple(item.values()))
    return sql, rel_data


if __name__ == '__main__':
    data = [{'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220530', 'ctr': 4.27, 'depth_passenger_cnt': 0, 'cpm': 355.29, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 5, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 11, 'visitor_cnt': 0, 'cost': 307.68, 'coupon_cnt': 0, 'total_order_sum': 523.0, 'total_cart_cnt': 14, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.7, 'new_customers_cnt': 0, 'impressions': 866, 'indirect_order_sum': 228.0, 'direct_order_sum': 295.0, 'goods_attention_cnt': 0, 'total_order_cvs': 18.92, 'cpa': 43.95, 'cpc': 8.32, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 37, 'total_order_cnt': 7, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220530', 'ctr': 11.9, 'depth_passenger_cnt': 0, 'cpm': 2524.52, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 318.09, 'coupon_cnt': 0, 'total_order_sum': 220.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.69, 'new_customers_cnt': 0, 'impressions': 126, 'indirect_order_sum': 220.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 6.67, 'cpa': 318.09, 'cpc': 21.21, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 15, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220530', 'ctr': 3.66, 'depth_passenger_cnt': 0, 'cpm': 572.56, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 46.95, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 82, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 15.65, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220530', 'ctr': 4.05, 'depth_passenger_cnt': 0, 'cpm': 178.65, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 105.76, 'coupon_cnt': 0, 'total_order_sum': 204.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.93, 'new_customers_cnt': 0, 'impressions': 592, 'indirect_order_sum': 136.0, 'direct_order_sum': 68.0, 'goods_attention_cnt': 0, 'total_order_cvs': 8.33, 'cpa': 52.88, 'cpc': 4.41, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 24, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220530', 'ctr': 2.85, 'depth_passenger_cnt': 0, 'cpm': 50.43, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 0, 'cost': 31.87, 'coupon_cnt': 0, 'total_order_sum': 102.9, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.23, 'new_customers_cnt': 0, 'impressions': 632, 'indirect_order_sum': 75.0, 'direct_order_sum': 27.9, 'goods_attention_cnt': 0, 'total_order_cvs': 11.11, 'cpa': 15.94, 'cpc': 1.77, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 18, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220530', 'ctr': 6.46, 'depth_passenger_cnt': 0, 'cpm': 1572.86, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 5, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 17, 'visitor_cnt': 0, 'cost': 1217.39, 'coupon_cnt': 0, 'total_order_sum': 1322.0, 'total_cart_cnt': 24, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.09, 'new_customers_cnt': 0, 'impressions': 774, 'indirect_order_sum': 477.0, 'direct_order_sum': 845.0, 'goods_attention_cnt': 0, 'total_order_cvs': 14.0, 'cpa': 173.91, 'cpc': 24.35, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 50, 'total_order_cnt': 7, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220530', 'ctr': 10.89, 'depth_passenger_cnt': 0, 'cpm': 605.53, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 0, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 0, 'cost': 155.62, 'coupon_cnt': 0, 'total_order_sum': 109.7, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.7, 'new_customers_cnt': 0, 'impressions': 257, 'indirect_order_sum': 109.7, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 10.71, 'cpa': 51.87, 'cpc': 5.56, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 28, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220530', 'ctr': 0.82, 'depth_passenger_cnt': 0, 'cpm': 35.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 4.27, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 122, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.27, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 1, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220530', 'ctr': 2.27, 'depth_passenger_cnt': 0, 'cpm': 91.13, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 0, 'cost': 40.19, 'coupon_cnt': 0, 'total_order_sum': 308.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 7.66, 'new_customers_cnt': 0, 'impressions': 441, 'indirect_order_sum': 159.0, 'direct_order_sum': 149.0, 'goods_attention_cnt': 0, 'total_order_cvs': 20.0, 'cpa': 20.1, 'cpc': 4.02, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 10, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220530', 'ctr': 1.23, 'depth_passenger_cnt': 0, 'cpm': 1.73, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.14, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 81, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.14, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 1, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220530', 'ctr': 11.05, 'depth_passenger_cnt': 0, 'cpm': 2289.89, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 4, 'direct_order_cnt': 2, 'indirect_cart_cnt': 10, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 0, 'cost': 414.47, 'coupon_cnt': 0, 'total_order_sum': 478.9, 'total_cart_cnt': 17, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.16, 'new_customers_cnt': 0, 'impressions': 181, 'indirect_order_sum': 320.9, 'direct_order_sum': 158.0, 'goods_attention_cnt': 0, 'total_order_cvs': 30.0, 'cpa': 69.08, 'cpc': 20.72, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 20, 'total_order_cnt': 6, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220530', 'ctr': 2.5, 'depth_passenger_cnt': 0, 'cpm': 265.05, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 137.56, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 519, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 10.58, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 13, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220530', 'ctr': 5.67, 'depth_passenger_cnt': 0, 'cpm': 208.72, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 29.43, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 141, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 3.68, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-30', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220530', 'ctr': 5.71, 'depth_passenger_cnt': 0, 'cpm': 828.76, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 87.02, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 105, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 14.5, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220529', 'ctr': 3.9, 'depth_passenger_cnt': 0, 'cpm': 41.43, 'visit_page_cnt': 21, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 39.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 2, 'cost': 3.19, 'coupon_cnt': 0, 'total_order_sum': 49.9, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 15.64, 'new_customers_cnt': 1, 'impressions': 77, 'indirect_order_sum': 0.0, 'direct_order_sum': 49.9, 'goods_attention_cnt': 0, 'total_order_cvs': 33.33, 'cpa': 3.19, 'cpc': 1.06, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220529', 'ctr': 2.8, 'depth_passenger_cnt': 7, 'cpm': 50.85, 'visit_page_cnt': 33, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 25.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 17, 'cost': 38.19, 'coupon_cnt': 1, 'total_order_sum': 0.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 751, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.82, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 21, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220529', 'ctr': 2.08, 'depth_passenger_cnt': 0, 'cpm': 107.5, 'visit_page_cnt': 1, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 2.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 5.16, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 48, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 5.16, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 1, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220529', 'ctr': 6.11, 'depth_passenger_cnt': 0, 'cpm': 273.08, 'visit_page_cnt': 81, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 30.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 39, 'cost': 254.78, 'coupon_cnt': 0, 'total_order_sum': 272.0, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.07, 'new_customers_cnt': 3, 'impressions': 933, 'indirect_order_sum': 136.0, 'direct_order_sum': 136.0, 'goods_attention_cnt': 1, 'total_order_cvs': 5.26, 'cpa': 84.93, 'cpc': 4.47, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 57, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220529', 'ctr': 7.09, 'depth_passenger_cnt': 0, 'cpm': 1897.23, 'visit_page_cnt': 186, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 5, 'direct_order_cnt': 6, 'indirect_cart_cnt': 13, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 24.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 19, 'visitor_cnt': 50, 'cost': 1901.02, 'coupon_cnt': 10, 'total_order_sum': 2942.0, 'total_cart_cnt': 32, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.55, 'new_customers_cnt': 10, 'impressions': 1002, 'indirect_order_sum': 1501.0, 'direct_order_sum': 1441.0, 'goods_attention_cnt': 0, 'total_order_cvs': 15.49, 'cpa': 172.82, 'cpc': 26.77, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 71, 'total_order_cnt': 11, 'shop_attention_cnt': 2}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220529', 'ctr': 6.03, 'depth_passenger_cnt': 4, 'cpm': 256.03, 'visit_page_cnt': 137, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 22.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 8, 'visitor_cnt': 40, 'cost': 237.6, 'coupon_cnt': 2, 'total_order_sum': 118.0, 'total_cart_cnt': 12, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.5, 'new_customers_cnt': 2, 'impressions': 928, 'indirect_order_sum': 0.0, 'direct_order_sum': 118.0, 'goods_attention_cnt': 0, 'total_order_cvs': 3.57, 'cpa': 118.8, 'cpc': 4.24, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 56, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220529', 'ctr': 3.4, 'depth_passenger_cnt': 0, 'cpm': 185.97, 'visit_page_cnt': 78, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 3, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 18.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 9, 'cost': 76.62, 'coupon_cnt': 2, 'total_order_sum': 447.0, 'total_cart_cnt': 12, 'presale_indirect_order_cnt': 0, 'total_order_roi': 5.83, 'new_customers_cnt': 3, 'impressions': 412, 'indirect_order_sum': 0.0, 'direct_order_sum': 447.0, 'goods_attention_cnt': 0, 'total_order_cvs': 21.43, 'cpa': 25.54, 'cpc': 5.47, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 14, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220529', 'ctr': 8.33, 'depth_passenger_cnt': 0, 'cpm': 1256.67, 'visit_page_cnt': 10, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 48.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 4, 'cost': 105.56, 'coupon_cnt': 1, 'total_order_sum': 220.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.08, 'new_customers_cnt': 0, 'impressions': 84, 'indirect_order_sum': 220.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 1, 'total_order_cvs': 14.29, 'cpa': 105.56, 'cpc': 15.08, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220529', 'ctr': 8.7, 'depth_passenger_cnt': 0, 'cpm': 1441.45, 'visit_page_cnt': 21, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 20.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 7, 'cost': 99.46, 'coupon_cnt': 1, 'total_order_sum': 79.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.79, 'new_customers_cnt': 0, 'impressions': 69, 'indirect_order_sum': 0.0, 'direct_order_sum': 79.0, 'goods_attention_cnt': 0, 'total_order_cvs': 16.67, 'cpa': 99.46, 'cpc': 16.58, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220529', 'ctr': 1.17, 'depth_passenger_cnt': 0, 'cpm': 129.88, 'visit_page_cnt': 44, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 25.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 6, 'cost': 66.63, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 513, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 11.11, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220529', 'ctr': 6.67, 'depth_passenger_cnt': 0, 'cpm': 505.67, 'visit_page_cnt': 9, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 23.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 3, 'cost': 60.68, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 120, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 7.59, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220529', 'ctr': 8.7, 'depth_passenger_cnt': 0, 'cpm': 1363.91, 'visit_page_cnt': 14, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 45.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 62.74, 'coupon_cnt': 0, 'total_order_sum': 99.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.58, 'new_customers_cnt': 1, 'impressions': 46, 'indirect_order_sum': 99.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 62.74, 'cpc': 15.69, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220529', 'ctr': 10.95, 'depth_passenger_cnt': 0, 'cpm': 554.1, 'visit_page_cnt': 36, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 2, 'indirect_cart_cnt': 9, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 18.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 12, 'visitor_cnt': 18, 'cost': 156.81, 'coupon_cnt': 6, 'total_order_sum': 71.5, 'total_cart_cnt': 21, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.46, 'new_customers_cnt': 3, 'impressions': 283, 'indirect_order_sum': 41.8, 'direct_order_sum': 29.7, 'goods_attention_cnt': 0, 'total_order_cvs': 12.9, 'cpa': 39.2, 'cpc': 5.06, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 31, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-29', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220529', 'ctr': 3.6, 'depth_passenger_cnt': 0, 'cpm': 86.58, 'visit_page_cnt': 2, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 49.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 9.61, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 111, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 2.4, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220528', 'ctr': 5.08, 'depth_passenger_cnt': 0, 'cpm': 549.32, 'visit_page_cnt': 27, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 36.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 10, 'cost': 129.64, 'coupon_cnt': 0, 'total_order_sum': 149.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.15, 'new_customers_cnt': 1, 'impressions': 236, 'indirect_order_sum': 0.0, 'direct_order_sum': 149.0, 'goods_attention_cnt': 0, 'total_order_cvs': 8.33, 'cpa': 129.64, 'cpc': 10.8, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 12, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220528', 'ctr': 13.01, 'depth_passenger_cnt': 0, 'cpm': 1829.02, 'visit_page_cnt': 56, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 3, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 16.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 6, 'cost': 224.97, 'coupon_cnt': 2, 'total_order_sum': 503.0, 'total_cart_cnt': 9, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.24, 'new_customers_cnt': 2, 'impressions': 123, 'indirect_order_sum': 286.0, 'direct_order_sum': 217.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 56.24, 'cpc': 14.06, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 16, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220528', 'ctr': 3.85, 'depth_passenger_cnt': 0, 'cpm': 385.84, 'visit_page_cnt': 64, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 4, 'direct_order_cnt': 1, 'indirect_cart_cnt': 9, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 17.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 14, 'cost': 190.22, 'coupon_cnt': 0, 'total_order_sum': 804.8, 'total_cart_cnt': 14, 'presale_indirect_order_cnt': 0, 'total_order_roi': 4.23, 'new_customers_cnt': 1, 'impressions': 493, 'indirect_order_sum': 516.8, 'direct_order_sum': 288.0, 'goods_attention_cnt': 1, 'total_order_cvs': 26.32, 'cpa': 38.04, 'cpc': 10.01, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 19, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220528', 'ctr': 6.56, 'depth_passenger_cnt': 0, 'cpm': 935.08, 'visit_page_cnt': 41, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 31.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 7, 'cost': 114.08, 'coupon_cnt': 3, 'total_order_sum': 355.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.11, 'new_customers_cnt': 1, 'impressions': 122, 'indirect_order_sum': 276.0, 'direct_order_sum': 79.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 57.04, 'cpc': 14.26, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220528', 'ctr': 1.77, 'depth_passenger_cnt': 0, 'cpm': 107.61, 'visit_page_cnt': 1, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 4.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 12.16, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 113, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 6.08, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220528', 'ctr': 17.5, 'depth_passenger_cnt': 0, 'cpm': 2069.25, 'visit_page_cnt': 18, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 51.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 6, 'cost': 82.77, 'coupon_cnt': 2, 'total_order_sum': 0.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 40, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 11.82, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220528', 'ctr': 13.37, 'depth_passenger_cnt': 1, 'cpm': 405.03, 'visit_page_cnt': 133, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 8, 'indirect_cart_cnt': 8, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 17.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 18, 'visitor_cnt': 34, 'cost': 151.48, 'coupon_cnt': 2, 'total_order_sum': 100.1, 'total_cart_cnt': 26, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.66, 'new_customers_cnt': 7, 'impressions': 374, 'indirect_order_sum': 28.9, 'direct_order_sum': 71.2, 'goods_attention_cnt': 0, 'total_order_cvs': 18.0, 'cpa': 16.83, 'cpc': 3.03, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 50, 'total_order_cnt': 9, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220528', 'ctr': 0.7, 'depth_passenger_cnt': 0, 'cpm': 28.94, 'visit_page_cnt': 1, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 24.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 4.11, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 142, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.11, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 1, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220528', 'ctr': 3.57, 'depth_passenger_cnt': 0, 'cpm': 478.93, 'visit_page_cnt': 11, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 14.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 2, 'cost': 26.82, 'coupon_cnt': 0, 'total_order_sum': 138.9, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 5.18, 'new_customers_cnt': 1, 'impressions': 56, 'indirect_order_sum': 69.0, 'direct_order_sum': 69.9, 'goods_attention_cnt': 0, 'total_order_cvs': 100.0, 'cpa': 13.41, 'cpc': 13.41, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220528', 'ctr': 2.29, 'depth_passenger_cnt': 7, 'cpm': 40.93, 'visit_page_cnt': 30, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 26.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 10, 'cost': 30.33, 'coupon_cnt': 1, 'total_order_sum': 193.8, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 6.39, 'new_customers_cnt': 2, 'impressions': 741, 'indirect_order_sum': 193.8, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 17.65, 'cpa': 10.11, 'cpc': 1.78, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 17, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220528', 'ctr': 5.04, 'depth_passenger_cnt': 0, 'cpm': 665.13, 'visit_page_cnt': 12, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 26.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 79.15, 'coupon_cnt': 0, 'total_order_sum': 243.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.07, 'new_customers_cnt': 0, 'impressions': 119, 'indirect_order_sum': 0.0, 'direct_order_sum': 243.0, 'goods_attention_cnt': 0, 'total_order_cvs': 16.67, 'cpa': 79.15, 'cpc': 13.19, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220528', 'ctr': 3.38, 'depth_passenger_cnt': 0, 'cpm': 117.1, 'visit_page_cnt': 24, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 44.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 11, 'cost': 65.81, 'coupon_cnt': 0, 'total_order_sum': 136.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.07, 'new_customers_cnt': 2, 'impressions': 562, 'indirect_order_sum': 0.0, 'direct_order_sum': 136.0, 'goods_attention_cnt': 0, 'total_order_cvs': 10.53, 'cpa': 32.91, 'cpc': 3.46, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 19, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220528', 'ctr': 7.46, 'depth_passenger_cnt': 3, 'cpm': 1612.03, 'visit_page_cnt': 202, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 6, 'direct_order_cnt': 6, 'indirect_cart_cnt': 11, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 32.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 25, 'visitor_cnt': 51, 'cost': 1902.19, 'coupon_cnt': 6, 'total_order_sum': 3902.0, 'total_cart_cnt': 36, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.05, 'new_customers_cnt': 11, 'impressions': 1180, 'indirect_order_sum': 1578.0, 'direct_order_sum': 2324.0, 'goods_attention_cnt': 0, 'total_order_cvs': 13.64, 'cpa': 158.52, 'cpc': 21.62, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 88, 'total_order_cnt': 12, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-28', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220528', 'ctr': 6.41, 'depth_passenger_cnt': 3, 'cpm': 325.46, 'visit_page_cnt': 97, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 4, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 19.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 8, 'visitor_cnt': 39, 'cost': 274.04, 'coupon_cnt': 0, 'total_order_sum': 418.0, 'total_cart_cnt': 11, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.53, 'new_customers_cnt': 5, 'impressions': 842, 'indirect_order_sum': 184.0, 'direct_order_sum': 234.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.26, 'cpa': 54.81, 'cpc': 5.07, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 54, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220527', 'ctr': 8.16, 'depth_passenger_cnt': 0, 'cpm': 1332.04, 'visit_page_cnt': 20, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 51.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 2, 'cost': 65.27, 'coupon_cnt': 1, 'total_order_sum': 151.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.31, 'new_customers_cnt': 1, 'impressions': 49, 'indirect_order_sum': 0.0, 'direct_order_sum': 151.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 65.27, 'cpc': 16.32, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220527', 'ctr': 3.19, 'depth_passenger_cnt': 0, 'cpm': 463.4, 'visit_page_cnt': 6, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 12.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 2, 'cost': 43.56, 'coupon_cnt': 0, 'total_order_sum': 79.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.81, 'new_customers_cnt': 1, 'impressions': 94, 'indirect_order_sum': 0.0, 'direct_order_sum': 79.0, 'goods_attention_cnt': 0, 'total_order_cvs': 33.33, 'cpa': 43.56, 'cpc': 14.52, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220527', 'ctr': 1.75, 'depth_passenger_cnt': 0, 'cpm': 145.46, 'visit_page_cnt': 40, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 28.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 9, 'cost': 99.93, 'coupon_cnt': 0, 'total_order_sum': 78.9, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.79, 'new_customers_cnt': 0, 'impressions': 687, 'indirect_order_sum': 19.9, 'direct_order_sum': 59.0, 'goods_attention_cnt': 0, 'total_order_cvs': 16.67, 'cpa': 49.97, 'cpc': 8.33, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 12, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220527', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 125, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220527', 'ctr': 2.26, 'depth_passenger_cnt': 0, 'cpm': 212.77, 'visit_page_cnt': 28, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 8.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 6, 'cost': 75.32, 'coupon_cnt': 0, 'total_order_sum': 149.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.98, 'new_customers_cnt': 1, 'impressions': 354, 'indirect_order_sum': 0.0, 'direct_order_sum': 149.0, 'goods_attention_cnt': 0, 'total_order_cvs': 12.5, 'cpa': 75.32, 'cpc': 9.42, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220527', 'ctr': 8.65, 'depth_passenger_cnt': 0, 'cpm': 1456.59, 'visit_page_cnt': 69, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 0, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 17.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 12, 'cost': 269.47, 'coupon_cnt': 0, 'total_order_sum': 264.8, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.98, 'new_customers_cnt': 1, 'impressions': 185, 'indirect_order_sum': 264.8, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 12.5, 'cpa': 134.74, 'cpc': 16.84, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 16, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220527', 'ctr': 2.22, 'depth_passenger_cnt': 0, 'cpm': 50.59, 'visit_page_cnt': 16, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 27.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 3, 'cost': 6.83, 'coupon_cnt': 0, 'total_order_sum': 199.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 29.14, 'new_customers_cnt': 1, 'impressions': 135, 'indirect_order_sum': 199.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 33.33, 'cpa': 6.83, 'cpc': 2.28, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220527', 'ctr': 11.49, 'depth_passenger_cnt': 0, 'cpm': 375.09, 'visit_page_cnt': 115, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 2, 'indirect_cart_cnt': 9, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 35.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 11, 'visitor_cnt': 33, 'cost': 153.41, 'coupon_cnt': 2, 'total_order_sum': 165.6, 'total_cart_cnt': 20, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.08, 'new_customers_cnt': 5, 'impressions': 409, 'indirect_order_sum': 67.7, 'direct_order_sum': 97.9, 'goods_attention_cnt': 0, 'total_order_cvs': 10.64, 'cpa': 30.68, 'cpc': 3.26, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 47, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220527', 'ctr': 6.94, 'depth_passenger_cnt': 3, 'cpm': 1594.98, 'visit_page_cnt': 86, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 1, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 27.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 12, 'visitor_cnt': 20, 'cost': 781.54, 'coupon_cnt': 4, 'total_order_sum': 804.0, 'total_cart_cnt': 19, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.03, 'new_customers_cnt': 4, 'impressions': 490, 'indirect_order_sum': 516.0, 'direct_order_sum': 288.0, 'goods_attention_cnt': 0, 'total_order_cvs': 11.76, 'cpa': 195.39, 'cpc': 22.99, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 34, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220527', 'ctr': 2.26, 'depth_passenger_cnt': 6, 'cpm': 29.89, 'visit_page_cnt': 45, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 16.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 13, 'cost': 22.51, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 753, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.32, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 17, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220527', 'ctr': 4.49, 'depth_passenger_cnt': 0, 'cpm': 336.97, 'visit_page_cnt': 7, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 56.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 3, 'cost': 29.99, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 89, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 7.5, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220527', 'ctr': 5.73, 'depth_passenger_cnt': 0, 'cpm': 222.37, 'visit_page_cnt': 54, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 15.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 19, 'cost': 116.52, 'coupon_cnt': 0, 'total_order_sum': 136.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.17, 'new_customers_cnt': 2, 'impressions': 524, 'indirect_order_sum': 0.0, 'direct_order_sum': 136.0, 'goods_attention_cnt': 0, 'total_order_cvs': 6.67, 'cpa': 58.26, 'cpc': 3.88, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 30, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220527', 'ctr': 1.41, 'depth_passenger_cnt': 0, 'cpm': 1.55, 'visit_page_cnt': 2, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 12.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 0.11, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 71, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.11, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 1, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-27', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220527', 'ctr': 5.92, 'depth_passenger_cnt': 4, 'cpm': 318.83, 'visit_page_cnt': 138, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 2, 'indirect_cart_cnt': 8, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 21.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 33, 'cost': 280.25, 'coupon_cnt': 0, 'total_order_sum': 381.0, 'total_cart_cnt': 18, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.36, 'new_customers_cnt': 4, 'impressions': 879, 'indirect_order_sum': 269.0, 'direct_order_sum': 112.0, 'goods_attention_cnt': 1, 'total_order_cvs': 7.69, 'cpa': 70.06, 'cpc': 5.39, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 52, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220526', 'ctr': 8.06, 'depth_passenger_cnt': 0, 'cpm': 1613.51, 'visit_page_cnt': 105, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 2, 'indirect_cart_cnt': 13, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 12.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 9, 'visitor_cnt': 12, 'cost': 400.15, 'coupon_cnt': 3, 'total_order_sum': 1827.4, 'total_cart_cnt': 22, 'presale_indirect_order_cnt': 0, 'total_order_roi': 4.57, 'new_customers_cnt': 4, 'impressions': 248, 'indirect_order_sum': 983.4, 'direct_order_sum': 844.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 80.03, 'cpc': 20.01, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 20, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220526', 'ctr': 4.01, 'depth_passenger_cnt': 8, 'cpm': 77.93, 'visit_page_cnt': 61, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 26.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 19, 'cost': 58.37, 'coupon_cnt': 0, 'total_order_sum': 26.6, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.46, 'new_customers_cnt': 1, 'impressions': 749, 'indirect_order_sum': 0.0, 'direct_order_sum': 26.6, 'goods_attention_cnt': 0, 'total_order_cvs': 3.33, 'cpa': 58.37, 'cpc': 1.95, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 30, 'total_order_cnt': 1, 'shop_attention_cnt': 1}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220526', 'ctr': 2.7, 'depth_passenger_cnt': 0, 'cpm': 157.7, 'visit_page_cnt': 1, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 9.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 11.67, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 74, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 5.84, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220526', 'ctr': 4.79, 'depth_passenger_cnt': 0, 'cpm': 219.4, 'visit_page_cnt': 52, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 14.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 21, 'cost': 151.17, 'coupon_cnt': 0, 'total_order_sum': 136.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.9, 'new_customers_cnt': 1, 'impressions': 689, 'indirect_order_sum': 136.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 3.03, 'cpa': 151.17, 'cpc': 4.58, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 33, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220526', 'ctr': 13.14, 'depth_passenger_cnt': 0, 'cpm': 1864.45, 'visit_page_cnt': 101, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 3, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 45.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 19, 'cost': 255.43, 'coupon_cnt': 2, 'total_order_sum': 585.0, 'total_cart_cnt': 11, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.29, 'new_customers_cnt': 1, 'impressions': 137, 'indirect_order_sum': 309.0, 'direct_order_sum': 276.0, 'goods_attention_cnt': 0, 'total_order_cvs': 22.22, 'cpa': 63.86, 'cpc': 14.19, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 18, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220526', 'ctr': 8.03, 'depth_passenger_cnt': 2, 'cpm': 566.93, 'visit_page_cnt': 89, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 4, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 26.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 20, 'cost': 204.66, 'coupon_cnt': 2, 'total_order_sum': 373.0, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.82, 'new_customers_cnt': 5, 'impressions': 361, 'indirect_order_sum': 149.0, 'direct_order_sum': 224.0, 'goods_attention_cnt': 0, 'total_order_cvs': 17.24, 'cpa': 40.93, 'cpc': 7.06, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 29, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220526', 'ctr': 16.0, 'depth_passenger_cnt': 0, 'cpm': 3277.2, 'visit_page_cnt': 33, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 78.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 4, 'cost': 81.93, 'coupon_cnt': 0, 'total_order_sum': 151.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.84, 'new_customers_cnt': 1, 'impressions': 25, 'indirect_order_sum': 0.0, 'direct_order_sum': 151.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 81.93, 'cpc': 20.48, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220526', 'ctr': 0.74, 'depth_passenger_cnt': 0, 'cpm': 39.32, 'visit_page_cnt': 41, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 10.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 7, 'cost': 36.96, 'coupon_cnt': 4, 'total_order_sum': 177.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 4.79, 'new_customers_cnt': 1, 'impressions': 940, 'indirect_order_sum': 118.0, 'direct_order_sum': 59.0, 'goods_attention_cnt': 0, 'total_order_cvs': 28.57, 'cpa': 18.48, 'cpc': 5.28, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220526', 'ctr': 7.38, 'depth_passenger_cnt': 0, 'cpm': 1064.23, 'visit_page_cnt': 106, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 3, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 38.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 10, 'cost': 158.57, 'coupon_cnt': 2, 'total_order_sum': 257.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.62, 'new_customers_cnt': 3, 'impressions': 149, 'indirect_order_sum': 0.0, 'direct_order_sum': 257.0, 'goods_attention_cnt': 1, 'total_order_cvs': 27.27, 'cpa': 52.86, 'cpc': 14.42, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 11, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220526', 'ctr': 2.6, 'depth_passenger_cnt': 0, 'cpm': 35.84, 'visit_page_cnt': 5, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 1.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 5.52, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 154, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.38, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220526', 'ctr': 4.45, 'depth_passenger_cnt': 2, 'cpm': 269.21, 'visit_page_cnt': 65, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 18.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 11, 'cost': 102.84, 'coupon_cnt': 0, 'total_order_sum': 298.0, 'total_cart_cnt': 9, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.9, 'new_customers_cnt': 2, 'impressions': 382, 'indirect_order_sum': 0.0, 'direct_order_sum': 298.0, 'goods_attention_cnt': 0, 'total_order_cvs': 11.76, 'cpa': 51.42, 'cpc': 6.05, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 17, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220526', 'ctr': 9.66, 'depth_passenger_cnt': 0, 'cpm': 1199.24, 'visit_page_cnt': 47, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 0, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 29.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 9, 'cost': 173.89, 'coupon_cnt': 0, 'total_order_sum': 260.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.5, 'new_customers_cnt': 2, 'impressions': 145, 'indirect_order_sum': 260.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 14.29, 'cpa': 86.95, 'cpc': 12.42, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 14, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220526', 'ctr': 0.88, 'depth_passenger_cnt': 0, 'cpm': 15.44, 'visit_page_cnt': 1, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 13.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 1.76, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 114, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.76, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 1, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-26', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220526', 'ctr': 13.03, 'depth_passenger_cnt': 0, 'cpm': 429.41, 'visit_page_cnt': 152, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 5, 'direct_order_cnt': 4, 'indirect_cart_cnt': 18, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 30.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 14, 'visitor_cnt': 39, 'cost': 151.58, 'coupon_cnt': 8, 'total_order_sum': 178.6, 'total_cart_cnt': 32, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.18, 'new_customers_cnt': 8, 'impressions': 353, 'indirect_order_sum': 107.4, 'direct_order_sum': 71.2, 'goods_attention_cnt': 0, 'total_order_cvs': 19.57, 'cpa': 16.84, 'cpc': 3.3, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 46, 'total_order_cnt': 9, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220525', 'ctr': 8.65, 'depth_passenger_cnt': 0, 'cpm': 308.45, 'visit_page_cnt': 224, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 2, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 24.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 13, 'visitor_cnt': 27, 'cost': 153.3, 'coupon_cnt': 3, 'total_order_sum': 18164.5, 'total_cart_cnt': 20, 'presale_indirect_order_cnt': 0, 'total_order_roi': 118.49, 'new_customers_cnt': 2, 'impressions': 497, 'indirect_order_sum': 18128.9, 'direct_order_sum': 35.6, 'goods_attention_cnt': 0, 'total_order_cvs': 11.63, 'cpa': 30.66, 'cpc': 3.57, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 43, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220525', 'ctr': 3.05, 'depth_passenger_cnt': 0, 'cpm': 57.79, 'visit_page_cnt': 8, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 66.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 7.57, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 131, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.89, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220525', 'ctr': 3.61, 'depth_passenger_cnt': 0, 'cpm': 232.63, 'visit_page_cnt': 37, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 13.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 11, 'cost': 96.54, 'coupon_cnt': 0, 'total_order_sum': 149.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.54, 'new_customers_cnt': 1, 'impressions': 415, 'indirect_order_sum': 0.0, 'direct_order_sum': 149.0, 'goods_attention_cnt': 0, 'total_order_cvs': 6.67, 'cpa': 96.54, 'cpc': 6.44, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 15, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220525', 'ctr': 8.97, 'depth_passenger_cnt': 0, 'cpm': 1019.87, 'visit_page_cnt': 36, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 20.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 6, 'cost': 79.55, 'coupon_cnt': 1, 'total_order_sum': 69.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.87, 'new_customers_cnt': 0, 'impressions': 78, 'indirect_order_sum': 0.0, 'direct_order_sum': 69.0, 'goods_attention_cnt': 0, 'total_order_cvs': 14.29, 'cpa': 79.55, 'cpc': 11.36, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220525', 'ctr': 0.55, 'depth_passenger_cnt': 0, 'cpm': 31.01, 'visit_page_cnt': 14, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 44.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 6, 'cost': 33.68, 'coupon_cnt': 0, 'total_order_sum': 118.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.5, 'new_customers_cnt': 1, 'impressions': 1086, 'indirect_order_sum': 118.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 16.67, 'cpa': 33.68, 'cpc': 5.61, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220525', 'ctr': 6.84, 'depth_passenger_cnt': 0, 'cpm': 1263.59, 'visit_page_cnt': 32, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 27.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 7, 'cost': 147.84, 'coupon_cnt': 1, 'total_order_sum': 457.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.09, 'new_customers_cnt': 1, 'impressions': 117, 'indirect_order_sum': 299.0, 'direct_order_sum': 158.0, 'goods_attention_cnt': 0, 'total_order_cvs': 37.5, 'cpa': 49.28, 'cpc': 18.48, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220525', 'ctr': 3.88, 'depth_passenger_cnt': 0, 'cpm': 158.83, 'visit_page_cnt': 9, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 42.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 6, 'cost': 32.72, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 206, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.09, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220525', 'ctr': 6.78, 'depth_passenger_cnt': 0, 'cpm': 1370.68, 'visit_page_cnt': 12, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 26.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 80.87, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 59, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 20.22, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220525', 'ctr': 5.26, 'depth_passenger_cnt': 3, 'cpm': 267.22, 'visit_page_cnt': 150, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 4, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 28.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 14, 'visitor_cnt': 28, 'cost': 203.09, 'coupon_cnt': 0, 'total_order_sum': 376.0, 'total_cart_cnt': 15, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.85, 'new_customers_cnt': 5, 'impressions': 760, 'indirect_order_sum': 149.0, 'direct_order_sum': 227.0, 'goods_attention_cnt': 0, 'total_order_cvs': 12.5, 'cpa': 40.62, 'cpc': 5.08, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 40, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220525', 'ctr': 14.53, 'depth_passenger_cnt': 0, 'cpm': 2128.89, 'visit_page_cnt': 100, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 25.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 6, 'cost': 249.08, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 11, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 117, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 14.65, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 17, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220525', 'ctr': 3.2, 'depth_passenger_cnt': 0, 'cpm': 410.88, 'visit_page_cnt': 23, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 58.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 51.36, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 125, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 12.84, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220525', 'ctr': 4.0, 'depth_passenger_cnt': 0, 'cpm': 204.21, 'visit_page_cnt': 23, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 16.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 12, 'cost': 117.42, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 575, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 5.11, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 23, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220525', 'ctr': 4.65, 'depth_passenger_cnt': 2, 'cpm': 65.4, 'visit_page_cnt': 26, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 15.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 12, 'cost': 25.31, 'coupon_cnt': 0, 'total_order_sum': 27.9, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.1, 'new_customers_cnt': 1, 'impressions': 387, 'indirect_order_sum': 0.0, 'direct_order_sum': 27.9, 'goods_attention_cnt': 0, 'total_order_cvs': 5.56, 'cpa': 25.31, 'cpc': 1.41, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 18, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-25', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220525', 'ctr': 4.37, 'depth_passenger_cnt': 0, 'cpm': 955.56, 'visit_page_cnt': 269, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 24, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 18.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 19, 'visitor_cnt': 15, 'cost': 393.69, 'coupon_cnt': 5, 'total_order_sum': 616.0, 'total_cart_cnt': 43, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.56, 'new_customers_cnt': 3, 'impressions': 412, 'indirect_order_sum': 318.0, 'direct_order_sum': 298.0, 'goods_attention_cnt': 0, 'total_order_cvs': 16.67, 'cpa': 131.23, 'cpc': 21.87, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 18, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220524', 'ctr': 7.27, 'depth_passenger_cnt': 4, 'cpm': 502.21, 'visit_page_cnt': 77, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 4, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 20.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 12, 'visitor_cnt': 26, 'cost': 200.38, 'coupon_cnt': 0, 'total_order_sum': 224.0, 'total_cart_cnt': 12, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.12, 'new_customers_cnt': 4, 'impressions': 399, 'indirect_order_sum': 0.0, 'direct_order_sum': 224.0, 'goods_attention_cnt': 0, 'total_order_cvs': 13.79, 'cpa': 50.1, 'cpc': 6.91, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 29, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220524', 'ctr': 6.48, 'depth_passenger_cnt': 0, 'cpm': 897.13, 'visit_page_cnt': 44, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 84.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 8, 'cost': 96.89, 'coupon_cnt': 0, 'total_order_sum': 62.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.64, 'new_customers_cnt': 0, 'impressions': 108, 'indirect_order_sum': 0.0, 'direct_order_sum': 62.0, 'goods_attention_cnt': 0, 'total_order_cvs': 14.29, 'cpa': 96.89, 'cpc': 13.84, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220524', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 80, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220524', 'ctr': 2.98, 'depth_passenger_cnt': 0, 'cpm': 91.66, 'visit_page_cnt': 32, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 19.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 11, 'cost': 43.08, 'coupon_cnt': 0, 'total_order_sum': 68.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.58, 'new_customers_cnt': 1, 'impressions': 470, 'indirect_order_sum': 0.0, 'direct_order_sum': 68.0, 'goods_attention_cnt': 0, 'total_order_cvs': 7.14, 'cpa': 43.08, 'cpc': 3.08, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 14, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220524', 'ctr': 4.05, 'depth_passenger_cnt': 6, 'cpm': 58.58, 'visit_page_cnt': 36, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 28.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 14, 'cost': 28.94, 'coupon_cnt': 0, 'total_order_sum': 104.9, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.62, 'new_customers_cnt': 2, 'impressions': 494, 'indirect_order_sum': 104.9, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 10.0, 'cpa': 14.47, 'cpc': 1.45, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 20, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220524', 'ctr': 3.21, 'depth_passenger_cnt': 0, 'cpm': 1094.12, 'visit_page_cnt': 22, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 3, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 16.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 9, 'cost': 409.2, 'coupon_cnt': 2, 'total_order_sum': 616.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.51, 'new_customers_cnt': 3, 'impressions': 374, 'indirect_order_sum': 0.0, 'direct_order_sum': 616.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 136.4, 'cpc': 34.1, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 12, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220524', 'ctr': 7.39, 'depth_passenger_cnt': 0, 'cpm': 271.82, 'visit_page_cnt': 93, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 0, 'indirect_cart_cnt': 8, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 25.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 27, 'cost': 150.86, 'coupon_cnt': 1, 'total_order_sum': 89.7, 'total_cart_cnt': 12, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.59, 'new_customers_cnt': 3, 'impressions': 555, 'indirect_order_sum': 89.7, 'direct_order_sum': 0.0, 'goods_attention_cnt': 1, 'total_order_cvs': 7.32, 'cpa': 50.29, 'cpc': 3.68, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 41, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220524', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 144, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220524', 'ctr': 2.72, 'depth_passenger_cnt': 1, 'cpm': 170.84, 'visit_page_cnt': 88, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 35.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 11, 'cost': 69.02, 'coupon_cnt': 2, 'total_order_sum': 205.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.97, 'new_customers_cnt': 2, 'impressions': 404, 'indirect_order_sum': 56.0, 'direct_order_sum': 149.0, 'goods_attention_cnt': 0, 'total_order_cvs': 18.18, 'cpa': 34.51, 'cpc': 6.27, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 11, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220524', 'ctr': 3.75, 'depth_passenger_cnt': 0, 'cpm': 198.0, 'visit_page_cnt': 36, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 87.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 15.84, 'coupon_cnt': 0, 'total_order_sum': 115.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 7.26, 'new_customers_cnt': 1, 'impressions': 80, 'indirect_order_sum': 115.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 33.33, 'cpa': 15.84, 'cpc': 5.28, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220524', 'ctr': 7.69, 'depth_passenger_cnt': 0, 'cpm': 890.26, 'visit_page_cnt': 20, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 9.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 1, 'cost': 34.72, 'coupon_cnt': 1, 'total_order_sum': 69.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.99, 'new_customers_cnt': 1, 'impressions': 39, 'indirect_order_sum': 0.0, 'direct_order_sum': 69.0, 'goods_attention_cnt': 0, 'total_order_cvs': 33.33, 'cpa': 34.72, 'cpc': 11.57, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220524', 'ctr': 0.47, 'depth_passenger_cnt': 0, 'cpm': 12.62, 'visit_page_cnt': 4, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 96.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 10.69, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 847, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 2.67, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220524', 'ctr': 2.74, 'depth_passenger_cnt': 0, 'cpm': 117.21, 'visit_page_cnt': 2, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 4.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 25.67, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 219, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.28, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-24', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220524', 'ctr': 18.18, 'depth_passenger_cnt': 0, 'cpm': 2547.27, 'visit_page_cnt': 10, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 25.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 3, 'cost': 84.06, 'coupon_cnt': 0, 'total_order_sum': 134.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.59, 'new_customers_cnt': 1, 'impressions': 33, 'indirect_order_sum': 0.0, 'direct_order_sum': 134.0, 'goods_attention_cnt': 0, 'total_order_cvs': 16.67, 'cpa': 84.06, 'cpc': 14.01, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220523', 'ctr': 4.75, 'depth_passenger_cnt': 1, 'cpm': 819.01, 'visit_page_cnt': 75, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 31.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 15, 'cost': 413.6, 'coupon_cnt': 3, 'total_order_sum': 159.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.38, 'new_customers_cnt': 1, 'impressions': 505, 'indirect_order_sum': 159.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 4.17, 'cpa': 413.6, 'cpc': 17.23, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 24, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220523', 'ctr': 2.96, 'depth_passenger_cnt': 0, 'cpm': 311.07, 'visit_page_cnt': 17, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 19.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 4, 'cost': 52.57, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 169, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 10.51, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 5, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220523', 'ctr': 7.21, 'depth_passenger_cnt': 0, 'cpm': 234.4, 'visit_page_cnt': 78, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 5, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 17.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 21, 'cost': 123.53, 'coupon_cnt': 0, 'total_order_sum': 612.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 4.95, 'new_customers_cnt': 6, 'impressions': 527, 'indirect_order_sum': 272.0, 'direct_order_sum': 340.0, 'goods_attention_cnt': 0, 'total_order_cvs': 15.79, 'cpa': 20.59, 'cpc': 3.25, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 38, 'total_order_cnt': 6, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220523', 'ctr': 5.8, 'depth_passenger_cnt': 0, 'cpm': 755.94, 'visit_page_cnt': 45, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 10.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 4, 'cost': 52.16, 'coupon_cnt': 0, 'total_order_sum': 564.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 10.81, 'new_customers_cnt': 0, 'impressions': 69, 'indirect_order_sum': 355.0, 'direct_order_sum': 209.0, 'goods_attention_cnt': 0, 'total_order_cvs': 50.0, 'cpa': 26.08, 'cpc': 13.04, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220523', 'ctr': 4.26, 'depth_passenger_cnt': 7, 'cpm': 85.85, 'visit_page_cnt': 47, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 14.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 24, 'cost': 56.49, 'coupon_cnt': 0, 'total_order_sum': 26.9, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.48, 'new_customers_cnt': 1, 'impressions': 658, 'indirect_order_sum': 0.0, 'direct_order_sum': 26.9, 'goods_attention_cnt': 0, 'total_order_cvs': 3.57, 'cpa': 56.49, 'cpc': 2.02, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 28, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220523', 'ctr': 5.55, 'depth_passenger_cnt': 8, 'cpm': 437.21, 'visit_page_cnt': 164, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 2, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 17.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 8, 'visitor_cnt': 32, 'cost': 401.8, 'coupon_cnt': 3, 'total_order_sum': 516.0, 'total_cart_cnt': 15, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.28, 'new_customers_cnt': 5, 'impressions': 919, 'indirect_order_sum': 404.0, 'direct_order_sum': 112.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.8, 'cpa': 80.36, 'cpc': 7.88, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 51, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220523', 'ctr': 2.9, 'depth_passenger_cnt': 0, 'cpm': 147.88, 'visit_page_cnt': 24, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 22.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 3, 'cost': 35.64, 'coupon_cnt': 1, 'total_order_sum': 99.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.78, 'new_customers_cnt': 1, 'impressions': 241, 'indirect_order_sum': 99.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 14.29, 'cpa': 35.64, 'cpc': 5.09, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220523', 'ctr': 3.67, 'depth_passenger_cnt': 0, 'cpm': 257.89, 'visit_page_cnt': 19, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 13.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 6, 'cost': 56.22, 'coupon_cnt': 0, 'total_order_sum': 99.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.76, 'new_customers_cnt': 0, 'impressions': 218, 'indirect_order_sum': 99.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 12.5, 'cpa': 56.22, 'cpc': 7.03, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220523', 'ctr': 1.13, 'depth_passenger_cnt': 0, 'cpm': 82.75, 'visit_page_cnt': 29, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 38.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 7, 'cost': 80.27, 'coupon_cnt': 0, 'total_order_sum': 99.0, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.23, 'new_customers_cnt': 1, 'impressions': 970, 'indirect_order_sum': 99.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.09, 'cpa': 80.27, 'cpc': 7.3, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 11, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220523', 'ctr': 6.45, 'depth_passenger_cnt': 0, 'cpm': 901.94, 'visit_page_cnt': 36, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 40.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 5, 'cost': 83.88, 'coupon_cnt': 1, 'total_order_sum': 0.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 93, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 13.98, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220523', 'ctr': 9.16, 'depth_passenger_cnt': 0, 'cpm': 1965.5, 'visit_page_cnt': 29, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 24.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 8, 'cost': 257.48, 'coupon_cnt': 0, 'total_order_sum': 126.0, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.49, 'new_customers_cnt': 0, 'impressions': 131, 'indirect_order_sum': 0.0, 'direct_order_sum': 126.0, 'goods_attention_cnt': 0, 'total_order_cvs': 16.67, 'cpa': 128.74, 'cpc': 21.46, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 12, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220523', 'ctr': 3.88, 'depth_passenger_cnt': 1, 'cpm': 493.97, 'visit_page_cnt': 69, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 23.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 17, 'cost': 280.08, 'coupon_cnt': 0, 'total_order_sum': 655.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.34, 'new_customers_cnt': 2, 'impressions': 567, 'indirect_order_sum': 355.0, 'direct_order_sum': 300.0, 'goods_attention_cnt': 0, 'total_order_cvs': 13.64, 'cpa': 93.36, 'cpc': 12.73, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 22, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220523', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 161, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-23', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220523', 'ctr': 7.8, 'depth_passenger_cnt': 1, 'cpm': 270.37, 'visit_page_cnt': 157, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 3, 'indirect_cart_cnt': 16, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 25.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 48, 'cost': 152.49, 'coupon_cnt': 6, 'total_order_sum': 88.5, 'total_cart_cnt': 26, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.58, 'new_customers_cnt': 4, 'impressions': 564, 'indirect_order_sum': 59.8, 'direct_order_sum': 28.7, 'goods_attention_cnt': 1, 'total_order_cvs': 11.36, 'cpa': 30.5, 'cpc': 3.47, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 44, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220522', 'ctr': 6.43, 'depth_passenger_cnt': 0, 'cpm': 631.71, 'visit_page_cnt': 14, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 38.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 8, 'cost': 88.44, 'coupon_cnt': 1, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 140, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 9.83, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 9, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220522', 'ctr': 2.09, 'depth_passenger_cnt': 0, 'cpm': 169.09, 'visit_page_cnt': 75, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 23.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 18, 'cost': 185.83, 'coupon_cnt': 0, 'total_order_sum': 289.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.56, 'new_customers_cnt': 1, 'impressions': 1099, 'indirect_order_sum': 0.0, 'direct_order_sum': 289.0, 'goods_attention_cnt': 0, 'total_order_cvs': 8.7, 'cpa': 92.92, 'cpc': 8.08, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 23, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220522', 'ctr': 3.01, 'depth_passenger_cnt': 0, 'cpm': 218.12, 'visit_page_cnt': 52, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 29.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 14, 'cost': 108.84, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 499, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 7.26, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 15, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220522', 'ctr': 15.91, 'depth_passenger_cnt': 0, 'cpm': 1740.23, 'visit_page_cnt': 19, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 19.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 5, 'cost': 76.57, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 44, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 10.94, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220522', 'ctr': 5.88, 'depth_passenger_cnt': 0, 'cpm': 946.47, 'visit_page_cnt': 10, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 6.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 3, 'cost': 64.36, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 68, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 16.09, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220522', 'ctr': 2.83, 'depth_passenger_cnt': 0, 'cpm': 255.42, 'visit_page_cnt': 38, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 27.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 12, 'cost': 162.7, 'coupon_cnt': 0, 'total_order_sum': 298.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.83, 'new_customers_cnt': 2, 'impressions': 637, 'indirect_order_sum': 0.0, 'direct_order_sum': 298.0, 'goods_attention_cnt': 0, 'total_order_cvs': 11.11, 'cpa': 81.35, 'cpc': 9.04, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 18, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220522', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 82, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220522', 'ctr': 9.08, 'depth_passenger_cnt': 0, 'cpm': 274.58, 'visit_page_cnt': 106, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 5, 'direct_order_cnt': 1, 'indirect_cart_cnt': 10, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 22.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 39, 'cost': 202.64, 'coupon_cnt': 4, 'total_order_sum': 158.8, 'total_cart_cnt': 20, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.78, 'new_customers_cnt': 6, 'impressions': 738, 'indirect_order_sum': 133.2, 'direct_order_sum': 25.6, 'goods_attention_cnt': 1, 'total_order_cvs': 8.96, 'cpa': 33.77, 'cpc': 3.02, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 67, 'total_order_cnt': 6, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220522', 'ctr': 4.11, 'depth_passenger_cnt': 0, 'cpm': 711.54, 'visit_page_cnt': 48, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 17.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 15, 'cost': 415.54, 'coupon_cnt': 0, 'total_order_sum': 756.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.82, 'new_customers_cnt': 3, 'impressions': 584, 'indirect_order_sum': 299.0, 'direct_order_sum': 457.0, 'goods_attention_cnt': 0, 'total_order_cvs': 12.5, 'cpa': 138.51, 'cpc': 17.31, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 24, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220522', 'ctr': 13.21, 'depth_passenger_cnt': 0, 'cpm': 2068.58, 'visit_page_cnt': 45, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 39.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 12, 'cost': 219.27, 'coupon_cnt': 0, 'total_order_sum': 938.8, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 4.28, 'new_customers_cnt': 0, 'impressions': 106, 'indirect_order_sum': 789.0, 'direct_order_sum': 149.8, 'goods_attention_cnt': 1, 'total_order_cvs': 21.43, 'cpa': 73.09, 'cpc': 15.66, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 14, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220522', 'ctr': 6.12, 'depth_passenger_cnt': 0, 'cpm': 297.56, 'visit_page_cnt': 167, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 6, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 19.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 11, 'visitor_cnt': 45, 'cost': 291.61, 'coupon_cnt': 0, 'total_order_sum': 544.0, 'total_cart_cnt': 12, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.87, 'new_customers_cnt': 7, 'impressions': 980, 'indirect_order_sum': 136.0, 'direct_order_sum': 408.0, 'goods_attention_cnt': 0, 'total_order_cvs': 11.67, 'cpa': 41.66, 'cpc': 4.86, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 60, 'total_order_cnt': 7, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220522', 'ctr': 2.96, 'depth_passenger_cnt': 0, 'cpm': 416.81, 'visit_page_cnt': 176, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 4, 'direct_order_cnt': 1, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 25.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 4, 'cost': 56.27, 'coupon_cnt': 2, 'total_order_sum': 17567.9, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 312.21, 'new_customers_cnt': 2, 'impressions': 135, 'indirect_order_sum': 17368.9, 'direct_order_sum': 199.0, 'goods_attention_cnt': 0, 'total_order_cvs': 125.0, 'cpa': 11.25, 'cpc': 14.07, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220522', 'ctr': 5.79, 'depth_passenger_cnt': 8, 'cpm': 124.94, 'visit_page_cnt': 81, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 12.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 18, 'cost': 56.1, 'coupon_cnt': 0, 'total_order_sum': 75.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.34, 'new_customers_cnt': 1, 'impressions': 449, 'indirect_order_sum': 75.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 3.85, 'cpa': 56.1, 'cpc': 2.16, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 26, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-22', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220522', 'ctr': 7.82, 'depth_passenger_cnt': 0, 'cpm': 752.07, 'visit_page_cnt': 106, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 3, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 33.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 8, 'visitor_cnt': 26, 'cost': 403.86, 'coupon_cnt': 0, 'total_order_sum': 177.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.44, 'new_customers_cnt': 2, 'impressions': 537, 'indirect_order_sum': 0.0, 'direct_order_sum': 177.0, 'goods_attention_cnt': 0, 'total_order_cvs': 7.14, 'cpa': 134.62, 'cpc': 9.62, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 42, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220521', 'ctr': 4.27, 'depth_passenger_cnt': 4, 'cpm': 333.7, 'visit_page_cnt': 131, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 17.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 42, 'cost': 468.85, 'coupon_cnt': 0, 'total_order_sum': 118.0, 'total_cart_cnt': 11, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.25, 'new_customers_cnt': 2, 'impressions': 1405, 'indirect_order_sum': 0.0, 'direct_order_sum': 118.0, 'goods_attention_cnt': 0, 'total_order_cvs': 3.33, 'cpa': 234.43, 'cpc': 7.81, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 60, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220521', 'ctr': 5.06, 'depth_passenger_cnt': 4, 'cpm': 187.38, 'visit_page_cnt': 62, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 14.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 18, 'cost': 103.62, 'coupon_cnt': 0, 'total_order_sum': 140.8, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.36, 'new_customers_cnt': 3, 'impressions': 553, 'indirect_order_sum': 85.0, 'direct_order_sum': 55.8, 'goods_attention_cnt': 1, 'total_order_cvs': 10.71, 'cpa': 34.54, 'cpc': 3.7, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 28, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220521', 'ctr': 3.13, 'depth_passenger_cnt': 0, 'cpm': 136.84, 'visit_page_cnt': 39, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 48.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 14, 'cost': 118.23, 'coupon_cnt': 0, 'total_order_sum': 68.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.58, 'new_customers_cnt': 0, 'impressions': 864, 'indirect_order_sum': 0.0, 'direct_order_sum': 68.0, 'goods_attention_cnt': 0, 'total_order_cvs': 3.7, 'cpa': 118.23, 'cpc': 4.38, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 27, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220521', 'ctr': 3.57, 'depth_passenger_cnt': 0, 'cpm': 169.76, 'visit_page_cnt': 1, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 57.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 14.26, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 84, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.75, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220521', 'ctr': 4.67, 'depth_passenger_cnt': 0, 'cpm': 660.8, 'visit_page_cnt': 39, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 25.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 5, 'cost': 99.12, 'coupon_cnt': 1, 'total_order_sum': 143.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.44, 'new_customers_cnt': 1, 'impressions': 150, 'indirect_order_sum': 0.0, 'direct_order_sum': 143.0, 'goods_attention_cnt': 0, 'total_order_cvs': 28.57, 'cpa': 49.56, 'cpc': 14.16, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220521', 'ctr': 3.49, 'depth_passenger_cnt': 1, 'cpm': 668.37, 'visit_page_cnt': 63, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 44.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 17, 'cost': 402.36, 'coupon_cnt': 3, 'total_order_sum': 377.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.94, 'new_customers_cnt': 3, 'impressions': 602, 'indirect_order_sum': 69.0, 'direct_order_sum': 308.0, 'goods_attention_cnt': 0, 'total_order_cvs': 14.29, 'cpa': 134.12, 'cpc': 19.16, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 21, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220521', 'ctr': 5.86, 'depth_passenger_cnt': 0, 'cpm': 178.43, 'visit_page_cnt': 95, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 10, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 25.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 30, 'cost': 149.17, 'coupon_cnt': 3, 'total_order_sum': 78.0, 'total_cart_cnt': 14, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.52, 'new_customers_cnt': 3, 'impressions': 836, 'indirect_order_sum': 55.2, 'direct_order_sum': 22.8, 'goods_attention_cnt': 0, 'total_order_cvs': 6.12, 'cpa': 49.72, 'cpc': 3.04, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 49, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220521', 'ctr': 1.92, 'depth_passenger_cnt': 0, 'cpm': 38.17, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 3.97, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 104, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.99, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220521', 'ctr': 3.9, 'depth_passenger_cnt': 0, 'cpm': 602.86, 'visit_page_cnt': 7, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 8.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 3, 'cost': 46.42, 'coupon_cnt': 1, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 77, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 15.47, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220521', 'ctr': 2.56, 'depth_passenger_cnt': 0, 'cpm': 292.04, 'visit_page_cnt': 72, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 43.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 10, 'cost': 216.4, 'coupon_cnt': 0, 'total_order_sum': 467.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.16, 'new_customers_cnt': 3, 'impressions': 741, 'indirect_order_sum': 159.0, 'direct_order_sum': 308.0, 'goods_attention_cnt': 1, 'total_order_cvs': 15.79, 'cpa': 72.13, 'cpc': 11.39, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 19, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220521', 'ctr': 16.67, 'depth_passenger_cnt': 0, 'cpm': 3943.33, 'visit_page_cnt': 4, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 53.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 70.98, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 18, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 23.66, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220521', 'ctr': 3.26, 'depth_passenger_cnt': 0, 'cpm': 179.25, 'visit_page_cnt': 40, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 28.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 10, 'cost': 55.03, 'coupon_cnt': 1, 'total_order_sum': 49.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.89, 'new_customers_cnt': 1, 'impressions': 307, 'indirect_order_sum': 49.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 10.0, 'cpa': 55.03, 'cpc': 5.5, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 10, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220521', 'ctr': 2.92, 'depth_passenger_cnt': 0, 'cpm': 301.14, 'visit_page_cnt': 125, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 1, 'indirect_cart_cnt': 9, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 33.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 14, 'cost': 195.74, 'coupon_cnt': 1, 'total_order_sum': 436.0, 'total_cart_cnt': 14, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.23, 'new_customers_cnt': 2, 'impressions': 650, 'indirect_order_sum': 377.0, 'direct_order_sum': 59.0, 'goods_attention_cnt': 2, 'total_order_cvs': 21.05, 'cpa': 48.94, 'cpc': 10.3, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 19, 'total_order_cnt': 4, 'shop_attention_cnt': 1}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-21', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220521', 'ctr': 3.29, 'depth_passenger_cnt': 0, 'cpm': 330.28, 'visit_page_cnt': 90, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 6, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 22.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 11, 'cost': 140.37, 'coupon_cnt': 0, 'total_order_sum': 99.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.71, 'new_customers_cnt': 1, 'impressions': 425, 'indirect_order_sum': 99.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 7.14, 'cpa': 140.37, 'cpc': 10.03, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 14, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220520', 'ctr': 7.47, 'depth_passenger_cnt': 1, 'cpm': 218.3, 'visit_page_cnt': 272, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 10, 'direct_order_cnt': 3, 'indirect_cart_cnt': 86, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 24.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 11, 'visitor_cnt': 63, 'cost': 268.73, 'coupon_cnt': 1, 'total_order_sum': 17641.4, 'total_cart_cnt': 97, 'presale_indirect_order_cnt': 0, 'total_order_roi': 65.65, 'new_customers_cnt': 10, 'impressions': 1231, 'indirect_order_sum': 17554.3, 'direct_order_sum': 87.1, 'goods_attention_cnt': 0, 'total_order_cvs': 14.13, 'cpa': 20.67, 'cpc': 2.92, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 92, 'total_order_cnt': 13, 'shop_attention_cnt': 1}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220520', 'ctr': 1.79, 'depth_passenger_cnt': 0, 'cpm': 18.84, 'visit_page_cnt': 2, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 26.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 2.11, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 112, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.06, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220520', 'ctr': 7.06, 'depth_passenger_cnt': 0, 'cpm': 442.47, 'visit_page_cnt': 14, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 60.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 5, 'cost': 37.61, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 85, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 6.27, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220520', 'ctr': 1.72, 'depth_passenger_cnt': 0, 'cpm': 183.87, 'visit_page_cnt': 69, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 21.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 6, 'cost': 85.5, 'coupon_cnt': 0, 'total_order_sum': 718.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 8.4, 'new_customers_cnt': 3, 'impressions': 465, 'indirect_order_sum': 289.0, 'direct_order_sum': 429.0, 'goods_attention_cnt': 0, 'total_order_cvs': 37.5, 'cpa': 28.5, 'cpc': 10.69, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220520', 'ctr': 8.0, 'depth_passenger_cnt': 0, 'cpm': 1371.0, 'visit_page_cnt': 4, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 24.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 3, 'cost': 68.55, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 50, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 17.14, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220520', 'ctr': 3.85, 'depth_passenger_cnt': 0, 'cpm': 167.69, 'visit_page_cnt': 21, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 23.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 6, 'cost': 47.96, 'coupon_cnt': 1, 'total_order_sum': 0.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 286, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.36, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 11, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220520', 'ctr': 2.67, 'depth_passenger_cnt': 0, 'cpm': 241.75, 'visit_page_cnt': 36, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 37.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 8, 'cost': 99.6, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 412, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 9.05, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 11, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220520', 'ctr': 2.4, 'depth_passenger_cnt': 0, 'cpm': 212.72, 'visit_page_cnt': 49, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 36.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 12, 'cost': 132.74, 'coupon_cnt': 0, 'total_order_sum': 59.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.44, 'new_customers_cnt': 1, 'impressions': 624, 'indirect_order_sum': 0.0, 'direct_order_sum': 59.0, 'goods_attention_cnt': 0, 'total_order_cvs': 6.67, 'cpa': 132.74, 'cpc': 8.85, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 15, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220520', 'ctr': 4.52, 'depth_passenger_cnt': 5, 'cpm': 320.92, 'visit_page_cnt': 214, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 8, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 24.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 13, 'visitor_cnt': 46, 'cost': 390.88, 'coupon_cnt': 2, 'total_order_sum': 814.0, 'total_cart_cnt': 17, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.08, 'new_customers_cnt': 9, 'impressions': 1218, 'indirect_order_sum': 289.0, 'direct_order_sum': 525.0, 'goods_attention_cnt': 2, 'total_order_cvs': 16.36, 'cpa': 43.43, 'cpc': 7.11, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 55, 'total_order_cnt': 9, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220520', 'ctr': 7.73, 'depth_passenger_cnt': 4, 'cpm': 329.47, 'visit_page_cnt': 112, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 16.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 33, 'cost': 213.17, 'coupon_cnt': 0, 'total_order_sum': 324.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.52, 'new_customers_cnt': 2, 'impressions': 647, 'indirect_order_sum': 324.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 4.0, 'cpa': 106.59, 'cpc': 4.26, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 50, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220520', 'ctr': 3.72, 'depth_passenger_cnt': 0, 'cpm': 208.79, 'visit_page_cnt': 46, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 26.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 13, 'cost': 129.24, 'coupon_cnt': 0, 'total_order_sum': 68.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.53, 'new_customers_cnt': 1, 'impressions': 619, 'indirect_order_sum': 0.0, 'direct_order_sum': 68.0, 'goods_attention_cnt': 0, 'total_order_cvs': 4.35, 'cpa': 129.24, 'cpc': 5.62, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 23, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220520', 'ctr': 2.33, 'depth_passenger_cnt': 0, 'cpm': 321.74, 'visit_page_cnt': 11, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 12.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 27.67, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 86, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 13.84, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220520', 'ctr': 11.21, 'depth_passenger_cnt': 0, 'cpm': 2182.41, 'visit_page_cnt': 78, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 1, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 19.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 8, 'visitor_cnt': 8, 'cost': 253.16, 'coupon_cnt': 4, 'total_order_sum': 739.7, 'total_cart_cnt': 15, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.92, 'new_customers_cnt': 3, 'impressions': 116, 'indirect_order_sum': 589.9, 'direct_order_sum': 149.8, 'goods_attention_cnt': 0, 'total_order_cvs': 30.77, 'cpa': 63.29, 'cpc': 19.47, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 13, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-20', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220520', 'ctr': 5.25, 'depth_passenger_cnt': 2, 'cpm': 916.16, 'visit_page_cnt': 70, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 30.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 30, 'cost': 767.74, 'coupon_cnt': 0, 'total_order_sum': 646.0, 'total_cart_cnt': 9, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.84, 'new_customers_cnt': 3, 'impressions': 838, 'indirect_order_sum': 328.0, 'direct_order_sum': 318.0, 'goods_attention_cnt': 0, 'total_order_cvs': 6.82, 'cpa': 255.91, 'cpc': 17.45, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 44, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220519', 'ctr': 1.33, 'depth_passenger_cnt': 0, 'cpm': 60.83, 'visit_page_cnt': 18, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 33.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 5, 'cost': 18.31, 'coupon_cnt': 0, 'total_order_sum': 79.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 4.31, 'new_customers_cnt': 1, 'impressions': 301, 'indirect_order_sum': 79.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 18.31, 'cpc': 4.58, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220519', 'ctr': 2.16, 'depth_passenger_cnt': 0, 'cpm': 264.1, 'visit_page_cnt': 71, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 26.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 8, 'visitor_cnt': 13, 'cost': 183.02, 'coupon_cnt': 0, 'total_order_sum': 387.0, 'total_cart_cnt': 9, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.11, 'new_customers_cnt': 3, 'impressions': 693, 'indirect_order_sum': 269.0, 'direct_order_sum': 118.0, 'goods_attention_cnt': 0, 'total_order_cvs': 20.0, 'cpa': 61.01, 'cpc': 12.2, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 15, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220519', 'ctr': 3.05, 'depth_passenger_cnt': 0, 'cpm': 247.46, 'visit_page_cnt': 30, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 23.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 11, 'cost': 121.75, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 492, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 8.12, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 15, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220519', 'ctr': 16.07, 'depth_passenger_cnt': 0, 'cpm': 2223.04, 'visit_page_cnt': 49, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 30.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 7, 'cost': 124.49, 'coupon_cnt': 1, 'total_order_sum': 286.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.3, 'new_customers_cnt': 2, 'impressions': 56, 'indirect_order_sum': 0.0, 'direct_order_sum': 286.0, 'goods_attention_cnt': 0, 'total_order_cvs': 22.22, 'cpa': 62.25, 'cpc': 13.83, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 9, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220519', 'ctr': 4.17, 'depth_passenger_cnt': 0, 'cpm': 511.56, 'visit_page_cnt': 15, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 8.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 2, 'cost': 49.11, 'coupon_cnt': 0, 'total_order_sum': 69.9, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.42, 'new_customers_cnt': 0, 'impressions': 96, 'indirect_order_sum': 0.0, 'direct_order_sum': 69.9, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 49.11, 'cpc': 12.28, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220519', 'ctr': 3.05, 'depth_passenger_cnt': 0, 'cpm': 369.33, 'visit_page_cnt': 16, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 3, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 29.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 8, 'cost': 181.34, 'coupon_cnt': 0, 'total_order_sum': 475.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.62, 'new_customers_cnt': 3, 'impressions': 491, 'indirect_order_sum': 0.0, 'direct_order_sum': 475.0, 'goods_attention_cnt': 0, 'total_order_cvs': 20.0, 'cpa': 60.45, 'cpc': 12.09, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 15, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220519', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 165, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220519', 'ctr': 7.56, 'depth_passenger_cnt': 2, 'cpm': 145.92, 'visit_page_cnt': 147, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 6, 'direct_order_cnt': 1, 'indirect_cart_cnt': 8, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 22.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 52, 'cost': 150.59, 'coupon_cnt': 2, 'total_order_sum': 299.4, 'total_cart_cnt': 18, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.99, 'new_customers_cnt': 6, 'impressions': 1032, 'indirect_order_sum': 274.8, 'direct_order_sum': 24.6, 'goods_attention_cnt': 1, 'total_order_cvs': 8.97, 'cpa': 21.51, 'cpc': 1.93, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 78, 'total_order_cnt': 7, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220519', 'ctr': 4.58, 'depth_passenger_cnt': 2, 'cpm': 746.92, 'visit_page_cnt': 69, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 3, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 25.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 30, 'cost': 717.79, 'coupon_cnt': 3, 'total_order_sum': 1381.0, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.92, 'new_customers_cnt': 5, 'impressions': 961, 'indirect_order_sum': 894.0, 'direct_order_sum': 487.0, 'goods_attention_cnt': 0, 'total_order_cvs': 13.64, 'cpa': 119.63, 'cpc': 16.31, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 44, 'total_order_cnt': 6, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220519', 'ctr': 8.22, 'depth_passenger_cnt': 0, 'cpm': 1261.37, 'visit_page_cnt': 36, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 25.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 11, 'cost': 184.16, 'coupon_cnt': 1, 'total_order_sum': 29.8, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.16, 'new_customers_cnt': 0, 'impressions': 146, 'indirect_order_sum': 29.8, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 8.33, 'cpa': 184.16, 'cpc': 15.35, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 12, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220519', 'ctr': 6.09, 'depth_passenger_cnt': 3, 'cpm': 232.47, 'visit_page_cnt': 79, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 23.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 33, 'cost': 206.2, 'coupon_cnt': 2, 'total_order_sum': 136.5, 'total_cart_cnt': 9, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.66, 'new_customers_cnt': 3, 'impressions': 887, 'indirect_order_sum': 83.3, 'direct_order_sum': 53.2, 'goods_attention_cnt': 0, 'total_order_cvs': 5.56, 'cpa': 68.73, 'cpc': 3.82, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 54, 'total_order_cnt': 3, 'shop_attention_cnt': 1}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220519', 'ctr': 5.22, 'depth_passenger_cnt': 0, 'cpm': 239.05, 'visit_page_cnt': 98, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 21.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 45, 'cost': 256.5, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 1073, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.58, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 56, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220519', 'ctr': 8.84, 'depth_passenger_cnt': 0, 'cpm': 543.06, 'visit_page_cnt': 279, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 0, 'indirect_cart_cnt': 21, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 31.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 15, 'cost': 79.83, 'coupon_cnt': 3, 'total_order_sum': 18607.0, 'total_cart_cnt': 21, 'presale_indirect_order_cnt': 0, 'total_order_roi': 233.08, 'new_customers_cnt': 0, 'impressions': 147, 'indirect_order_sum': 18607.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 15.38, 'cpa': 39.92, 'cpc': 6.14, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 13, 'total_order_cnt': 2, 'shop_attention_cnt': 1}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-19', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220519', 'ctr': 5.26, 'depth_passenger_cnt': 3, 'cpm': 327.27, 'visit_page_cnt': 127, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 7, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 16.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 15, 'visitor_cnt': 32, 'cost': 286.36, 'coupon_cnt': 0, 'total_order_sum': 661.0, 'total_cart_cnt': 18, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.31, 'new_customers_cnt': 9, 'impressions': 875, 'indirect_order_sum': 269.0, 'direct_order_sum': 392.0, 'goods_attention_cnt': 0, 'total_order_cvs': 19.57, 'cpa': 31.82, 'cpc': 6.23, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 46, 'total_order_cnt': 9, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220518', 'ctr': 4.3, 'depth_passenger_cnt': 5, 'cpm': 830.61, 'visit_page_cnt': 110, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 6, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 32.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 28, 'cost': 753.36, 'coupon_cnt': 0, 'total_order_sum': 1401.0, 'total_cart_cnt': 12, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.86, 'new_customers_cnt': 6, 'impressions': 907, 'indirect_order_sum': 0.0, 'direct_order_sum': 1401.0, 'goods_attention_cnt': 0, 'total_order_cvs': 15.38, 'cpa': 125.56, 'cpc': 19.32, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 39, 'total_order_cnt': 6, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220518', 'ctr': 12.97, 'depth_passenger_cnt': 0, 'cpm': 2587.84, 'visit_page_cnt': 166, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 4, 'direct_order_cnt': 3, 'indirect_cart_cnt': 19, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 22.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 19, 'cost': 478.75, 'coupon_cnt': 7, 'total_order_sum': 667.72, 'total_cart_cnt': 29, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.39, 'new_customers_cnt': 1, 'impressions': 185, 'indirect_order_sum': 457.72, 'direct_order_sum': 210.0, 'goods_attention_cnt': 0, 'total_order_cvs': 29.17, 'cpa': 68.39, 'cpc': 19.95, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 24, 'total_order_cnt': 7, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220518', 'ctr': 5.21, 'depth_passenger_cnt': 3, 'cpm': 216.67, 'visit_page_cnt': 97, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 1, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 24.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 11, 'visitor_cnt': 30, 'cost': 187.2, 'coupon_cnt': 0, 'total_order_sum': 419.9, 'total_cart_cnt': 14, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.24, 'new_customers_cnt': 4, 'impressions': 864, 'indirect_order_sum': 393.3, 'direct_order_sum': 26.6, 'goods_attention_cnt': 0, 'total_order_cvs': 8.89, 'cpa': 46.8, 'cpc': 4.16, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 45, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220518', 'ctr': 6.69, 'depth_passenger_cnt': 0, 'cpm': 310.3, 'visit_page_cnt': 112, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 6, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 25.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 8, 'visitor_cnt': 38, 'cost': 305.96, 'coupon_cnt': 0, 'total_order_sum': 408.0, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.33, 'new_customers_cnt': 6, 'impressions': 986, 'indirect_order_sum': 0.0, 'direct_order_sum': 408.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.09, 'cpa': 50.99, 'cpc': 4.64, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 66, 'total_order_cnt': 6, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220518', 'ctr': 5.88, 'depth_passenger_cnt': 0, 'cpm': 203.82, 'visit_page_cnt': 39, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 44.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 4, 'cost': 13.86, 'coupon_cnt': 1, 'total_order_sum': 74.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 5.34, 'new_customers_cnt': 1, 'impressions': 68, 'indirect_order_sum': 74.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 13.86, 'cpc': 3.47, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 1, 'shop_attention_cnt': 1}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220518', 'ctr': 3.8, 'depth_passenger_cnt': 3, 'cpm': 171.32, 'visit_page_cnt': 199, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 8, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 15.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 17, 'visitor_cnt': 35, 'cost': 257.15, 'coupon_cnt': 0, 'total_order_sum': 458.0, 'total_cart_cnt': 19, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.78, 'new_customers_cnt': 6, 'impressions': 1501, 'indirect_order_sum': 0.0, 'direct_order_sum': 458.0, 'goods_attention_cnt': 0, 'total_order_cvs': 14.04, 'cpa': 32.14, 'cpc': 4.51, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 57, 'total_order_cnt': 8, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220518', 'ctr': 3.77, 'depth_passenger_cnt': 0, 'cpm': 205.02, 'visit_page_cnt': 34, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 27.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 5, 'cost': 49.0, 'coupon_cnt': 3, 'total_order_sum': 198.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 4.04, 'new_customers_cnt': 1, 'impressions': 239, 'indirect_order_sum': 198.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 22.22, 'cpa': 24.5, 'cpc': 5.44, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 9, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220518', 'ctr': 1.27, 'depth_passenger_cnt': 0, 'cpm': 102.86, 'visit_page_cnt': 34, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 27.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 5, 'cost': 48.55, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 472, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 8.09, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220518', 'ctr': 1.31, 'depth_passenger_cnt': 0, 'cpm': 43.52, 'visit_page_cnt': 98, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 22.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 6, 'cost': 26.59, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 611, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 3.32, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220518', 'ctr': 7.81, 'depth_passenger_cnt': 0, 'cpm': 1199.22, 'visit_page_cnt': 10, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 78.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 3, 'cost': 76.75, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 64, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 15.35, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 5, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220518', 'ctr': 5.76, 'depth_passenger_cnt': 0, 'cpm': 1156.83, 'visit_page_cnt': 8, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 8.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 160.8, 'coupon_cnt': 0, 'total_order_sum': 113.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.7, 'new_customers_cnt': 0, 'impressions': 139, 'indirect_order_sum': 113.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 12.5, 'cpa': 160.8, 'cpc': 20.1, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220518', 'ctr': 4.82, 'depth_passenger_cnt': 0, 'cpm': 440.02, 'visit_page_cnt': 92, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 13.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 14, 'cost': 209.89, 'coupon_cnt': 0, 'total_order_sum': 599.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.85, 'new_customers_cnt': 3, 'impressions': 477, 'indirect_order_sum': 289.0, 'direct_order_sum': 310.0, 'goods_attention_cnt': 0, 'total_order_cvs': 13.04, 'cpa': 69.96, 'cpc': 9.13, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 23, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220518', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 128, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-18', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220518', 'ctr': 6.92, 'depth_passenger_cnt': 0, 'cpm': 114.84, 'visit_page_cnt': 131, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 6, 'direct_order_cnt': 2, 'indirect_cart_cnt': 9, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 22.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 37, 'cost': 99.57, 'coupon_cnt': 5, 'total_order_sum': 250.4, 'total_cart_cnt': 19, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.51, 'new_customers_cnt': 7, 'impressions': 867, 'indirect_order_sum': 225.8, 'direct_order_sum': 24.6, 'goods_attention_cnt': 0, 'total_order_cvs': 13.33, 'cpa': 12.45, 'cpc': 1.66, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 60, 'total_order_cnt': 8, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220517', 'ctr': 6.14, 'depth_passenger_cnt': 3, 'cpm': 231.65, 'visit_page_cnt': 133, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 4, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 25.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 12, 'visitor_cnt': 37, 'cost': 207.56, 'coupon_cnt': 2, 'total_order_sum': 167.1, 'total_cart_cnt': 15, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.81, 'new_customers_cnt': 4, 'impressions': 896, 'indirect_order_sum': 28.9, 'direct_order_sum': 138.2, 'goods_attention_cnt': 0, 'total_order_cvs': 9.09, 'cpa': 41.51, 'cpc': 3.77, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 55, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220517', 'ctr': 4.78, 'depth_passenger_cnt': 0, 'cpm': 249.91, 'visit_page_cnt': 90, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 26.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 35, 'cost': 276.9, 'coupon_cnt': 0, 'total_order_sum': 272.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.98, 'new_customers_cnt': 3, 'impressions': 1108, 'indirect_order_sum': 136.0, 'direct_order_sum': 136.0, 'goods_attention_cnt': 1, 'total_order_cvs': 5.66, 'cpa': 92.3, 'cpc': 5.22, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 53, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220517', 'ctr': 2.63, 'depth_passenger_cnt': 0, 'cpm': 244.56, 'visit_page_cnt': 2, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 39.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 27.88, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 114, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 9.29, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220517', 'ctr': 5.49, 'depth_passenger_cnt': 0, 'cpm': 932.91, 'visit_page_cnt': 49, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 22.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 12, 'cost': 221.1, 'coupon_cnt': 2, 'total_order_sum': 128.6, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.58, 'new_customers_cnt': 1, 'impressions': 237, 'indirect_order_sum': 128.6, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 23.08, 'cpa': 73.7, 'cpc': 17.01, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 13, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220517', 'ctr': 4.72, 'depth_passenger_cnt': 1, 'cpm': 799.44, 'visit_page_cnt': 134, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 5, 'direct_order_cnt': 2, 'indirect_cart_cnt': 15, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 15.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 21, 'cost': 643.55, 'coupon_cnt': 7, 'total_order_sum': 2110.0, 'total_cart_cnt': 25, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.28, 'new_customers_cnt': 7, 'impressions': 805, 'indirect_order_sum': 1073.0, 'direct_order_sum': 1037.0, 'goods_attention_cnt': 0, 'total_order_cvs': 18.42, 'cpa': 91.94, 'cpc': 16.94, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 38, 'total_order_cnt': 7, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220517', 'ctr': 3.71, 'depth_passenger_cnt': 7, 'cpm': 133.22, 'visit_page_cnt': 125, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 4, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 16.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 17, 'visitor_cnt': 31, 'cost': 179.58, 'coupon_cnt': 0, 'total_order_sum': 341.0, 'total_cart_cnt': 19, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.9, 'new_customers_cnt': 5, 'impressions': 1348, 'indirect_order_sum': 114.0, 'direct_order_sum': 227.0, 'goods_attention_cnt': 0, 'total_order_cvs': 10.0, 'cpa': 35.92, 'cpc': 3.59, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 50, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220517', 'ctr': 4.07, 'depth_passenger_cnt': 0, 'cpm': 674.39, 'visit_page_cnt': 47, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 10.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 82.95, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 123, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 16.59, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 5, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220517', 'ctr': 2.37, 'depth_passenger_cnt': 0, 'cpm': 218.97, 'visit_page_cnt': 51, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 14.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 6, 'cost': 83.21, 'coupon_cnt': 0, 'total_order_sum': 318.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.82, 'new_customers_cnt': 2, 'impressions': 380, 'indirect_order_sum': 0.0, 'direct_order_sum': 318.0, 'goods_attention_cnt': 0, 'total_order_cvs': 22.22, 'cpa': 41.61, 'cpc': 9.25, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 9, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220517', 'ctr': 4.9, 'depth_passenger_cnt': 0, 'cpm': 672.45, 'visit_page_cnt': 16, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 18.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 3, 'cost': 96.16, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 143, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 13.74, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220517', 'ctr': 0.9, 'depth_passenger_cnt': 0, 'cpm': 18.97, 'visit_page_cnt': 4, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 3.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 4.23, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 223, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 2.12, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220517', 'ctr': 0.35, 'depth_passenger_cnt': 0, 'cpm': 13.0, 'visit_page_cnt': 3, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 56.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 7.33, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 564, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 3.67, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220517', 'ctr': 1.96, 'depth_passenger_cnt': 0, 'cpm': 119.08, 'visit_page_cnt': 38, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 40.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 14, 'cost': 85.26, 'coupon_cnt': 1, 'total_order_sum': 0.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 716, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 6.09, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 14, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220517', 'ctr': 8.55, 'depth_passenger_cnt': 0, 'cpm': 203.85, 'visit_page_cnt': 167, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 5, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 20.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 15, 'visitor_cnt': 44, 'cost': 150.24, 'coupon_cnt': 1, 'total_order_sum': 17383.8, 'total_cart_cnt': 20, 'presale_indirect_order_cnt': 0, 'total_order_roi': 115.71, 'new_customers_cnt': 6, 'impressions': 737, 'indirect_order_sum': 17319.8, 'direct_order_sum': 64.0, 'goods_attention_cnt': 0, 'total_order_cvs': 12.7, 'cpa': 18.78, 'cpc': 2.38, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 63, 'total_order_cnt': 8, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-17', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220517', 'ctr': 0.66, 'depth_passenger_cnt': 0, 'cpm': 11.52, 'visit_page_cnt': 9, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 13.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 1.74, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 151, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.74, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 1, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220516', 'ctr': 5.83, 'depth_passenger_cnt': 0, 'cpm': 1008.5, 'visit_page_cnt': 110, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 11, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 9.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 5, 'cost': 121.02, 'coupon_cnt': 3, 'total_order_sum': 458.0, 'total_cart_cnt': 13, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.78, 'new_customers_cnt': 0, 'impressions': 120, 'indirect_order_sum': 230.0, 'direct_order_sum': 228.0, 'goods_attention_cnt': 0, 'total_order_cvs': 28.57, 'cpa': 60.51, 'cpc': 17.29, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220516', 'ctr': 1.88, 'depth_passenger_cnt': 2, 'cpm': 65.19, 'visit_page_cnt': 6, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 6.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 1, 'cost': 10.43, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 160, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 3.48, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220516', 'ctr': 5.8, 'depth_passenger_cnt': 0, 'cpm': 1166.67, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 80.5, 'coupon_cnt': 0, 'total_order_sum': 29.9, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.37, 'new_customers_cnt': 1, 'impressions': 69, 'indirect_order_sum': 29.9, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 80.5, 'cpc': 20.13, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220516', 'ctr': 9.22, 'depth_passenger_cnt': 0, 'cpm': 183.05, 'visit_page_cnt': 82, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 0, 'indirect_cart_cnt': 6, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 30.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 4, 'cost': 25.81, 'coupon_cnt': 2, 'total_order_sum': 198.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 7.67, 'new_customers_cnt': 2, 'impressions': 141, 'indirect_order_sum': 198.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 15.38, 'cpa': 12.91, 'cpc': 1.99, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 13, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220516', 'ctr': 2.9, 'depth_passenger_cnt': 0, 'cpm': 217.97, 'visit_page_cnt': 80, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 27.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 9, 'cost': 127.95, 'coupon_cnt': 1, 'total_order_sum': 69.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.54, 'new_customers_cnt': 1, 'impressions': 587, 'indirect_order_sum': 0.0, 'direct_order_sum': 69.0, 'goods_attention_cnt': 0, 'total_order_cvs': 5.88, 'cpa': 127.95, 'cpc': 7.53, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 17, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220516', 'ctr': 1.75, 'depth_passenger_cnt': 0, 'cpm': 59.37, 'visit_page_cnt': 233, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 26, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 27.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 24, 'cost': 54.38, 'coupon_cnt': 16, 'total_order_sum': 905.0, 'total_cart_cnt': 29, 'presale_indirect_order_cnt': 0, 'total_order_roi': 16.64, 'new_customers_cnt': 1, 'impressions': 916, 'indirect_order_sum': 675.0, 'direct_order_sum': 230.0, 'goods_attention_cnt': 0, 'total_order_cvs': 18.75, 'cpa': 18.13, 'cpc': 3.4, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 16, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220516', 'ctr': 7.05, 'depth_passenger_cnt': 2, 'cpm': 128.66, 'visit_page_cnt': 151, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 3, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 19.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 40, 'cost': 98.55, 'coupon_cnt': 2, 'total_order_sum': 192.7, 'total_cart_cnt': 11, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.96, 'new_customers_cnt': 5, 'impressions': 766, 'indirect_order_sum': 141.5, 'direct_order_sum': 51.2, 'goods_attention_cnt': 0, 'total_order_cvs': 11.11, 'cpa': 16.43, 'cpc': 1.83, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 54, 'total_order_cnt': 6, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220516', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 125, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220516', 'ctr': 2.2, 'depth_passenger_cnt': 4, 'cpm': 51.18, 'visit_page_cnt': 56, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 21.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 12, 'cost': 39.46, 'coupon_cnt': 0, 'total_order_sum': 112.9, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.86, 'new_customers_cnt': 2, 'impressions': 771, 'indirect_order_sum': 85.0, 'direct_order_sum': 27.9, 'goods_attention_cnt': 0, 'total_order_cvs': 11.76, 'cpa': 19.73, 'cpc': 2.32, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 17, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220516', 'ctr': 2.93, 'depth_passenger_cnt': 3, 'cpm': 101.22, 'visit_page_cnt': 61, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 3, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 13.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 31, 'cost': 165.59, 'coupon_cnt': 0, 'total_order_sum': 272.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.64, 'new_customers_cnt': 3, 'impressions': 1636, 'indirect_order_sum': 0.0, 'direct_order_sum': 272.0, 'goods_attention_cnt': 0, 'total_order_cvs': 6.25, 'cpa': 55.2, 'cpc': 3.45, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 48, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220516', 'ctr': 1.23, 'depth_passenger_cnt': 0, 'cpm': 12.96, 'visit_page_cnt': 14, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 30.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 1.05, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 81, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.05, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 1, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220516', 'ctr': 4.52, 'depth_passenger_cnt': 0, 'cpm': 815.08, 'visit_page_cnt': 42, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 3, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 22.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 7, 'cost': 144.27, 'coupon_cnt': 1, 'total_order_sum': 469.4, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.25, 'new_customers_cnt': 0, 'impressions': 177, 'indirect_order_sum': 0.0, 'direct_order_sum': 469.4, 'goods_attention_cnt': 0, 'total_order_cvs': 37.5, 'cpa': 48.09, 'cpc': 18.03, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220516', 'ctr': 2.72, 'depth_passenger_cnt': 8, 'cpm': 146.46, 'visit_page_cnt': 92, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 29.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 27, 'cost': 188.2, 'coupon_cnt': 4, 'total_order_sum': 318.0, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.69, 'new_customers_cnt': 2, 'impressions': 1285, 'indirect_order_sum': 159.0, 'direct_order_sum': 159.0, 'goods_attention_cnt': 0, 'total_order_cvs': 5.71, 'cpa': 94.1, 'cpc': 5.38, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 35, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-16', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220516', 'ctr': 3.19, 'depth_passenger_cnt': 16, 'cpm': 92.79, 'visit_page_cnt': 210, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 4, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 16.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 17, 'visitor_cnt': 29, 'cost': 119.33, 'coupon_cnt': 2, 'total_order_sum': 287.0, 'total_cart_cnt': 24, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.41, 'new_customers_cnt': 4, 'impressions': 1286, 'indirect_order_sum': 0.0, 'direct_order_sum': 287.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.76, 'cpa': 29.83, 'cpc': 2.91, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 41, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220515', 'ctr': 4.32, 'depth_passenger_cnt': 12, 'cpm': 172.53, 'visit_page_cnt': 201, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 5, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 16.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 17, 'visitor_cnt': 50, 'cost': 267.77, 'coupon_cnt': 0, 'total_order_sum': 292.0, 'total_cart_cnt': 22, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.09, 'new_customers_cnt': 4, 'impressions': 1552, 'indirect_order_sum': 0.0, 'direct_order_sum': 292.0, 'goods_attention_cnt': 0, 'total_order_cvs': 7.46, 'cpa': 53.55, 'cpc': 4.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 67, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220515', 'ctr': 5.45, 'depth_passenger_cnt': 0, 'cpm': 727.76, 'visit_page_cnt': 116, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 2, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 22.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 18, 'cost': 360.24, 'coupon_cnt': 0, 'total_order_sum': 751.0, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.08, 'new_customers_cnt': 1, 'impressions': 495, 'indirect_order_sum': 433.0, 'direct_order_sum': 318.0, 'goods_attention_cnt': 0, 'total_order_cvs': 14.81, 'cpa': 90.06, 'cpc': 13.34, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 27, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220515', 'ctr': 7.58, 'depth_passenger_cnt': 0, 'cpm': 850.76, 'visit_page_cnt': 51, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 0, 'indirect_cart_cnt': 8, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 24.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 9, 'cost': 112.3, 'coupon_cnt': 2, 'total_order_sum': 368.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.28, 'new_customers_cnt': 1, 'impressions': 132, 'indirect_order_sum': 368.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 20.0, 'cpa': 56.15, 'cpc': 11.23, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 10, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220515', 'ctr': 3.8, 'depth_passenger_cnt': 3, 'cpm': 128.48, 'visit_page_cnt': 117, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 5, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 14.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 26, 'cost': 131.69, 'coupon_cnt': 0, 'total_order_sum': 612.0, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 4.65, 'new_customers_cnt': 6, 'impressions': 1025, 'indirect_order_sum': 272.0, 'direct_order_sum': 340.0, 'goods_attention_cnt': 0, 'total_order_cvs': 17.95, 'cpa': 18.81, 'cpc': 3.38, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 39, 'total_order_cnt': 7, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220515', 'ctr': 4.55, 'depth_passenger_cnt': 1, 'cpm': 152.27, 'visit_page_cnt': 10, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 50.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 4, 'cost': 13.4, 'coupon_cnt': 1, 'total_order_sum': 199.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 14.85, 'new_customers_cnt': 1, 'impressions': 88, 'indirect_order_sum': 0.0, 'direct_order_sum': 199.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 13.4, 'cpc': 3.35, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220515', 'ctr': 3.25, 'depth_passenger_cnt': 7, 'cpm': 52.87, 'visit_page_cnt': 28, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 13.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 12, 'cost': 32.57, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 616, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.63, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 20, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220515', 'ctr': 1.28, 'depth_passenger_cnt': 0, 'cpm': 22.69, 'visit_page_cnt': 1, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 10.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 1.77, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 78, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.77, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 1, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220515', 'ctr': 9.21, 'depth_passenger_cnt': 1, 'cpm': 228.77, 'visit_page_cnt': 190, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 5, 'direct_order_cnt': 9, 'indirect_cart_cnt': 19, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 25.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 18, 'visitor_cnt': 40, 'cost': 156.48, 'coupon_cnt': 8, 'total_order_sum': 408.7, 'total_cart_cnt': 37, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.61, 'new_customers_cnt': 12, 'impressions': 684, 'indirect_order_sum': 242.3, 'direct_order_sum': 166.4, 'goods_attention_cnt': 0, 'total_order_cvs': 22.22, 'cpa': 11.18, 'cpc': 2.48, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 63, 'total_order_cnt': 14, 'shop_attention_cnt': 1}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220515', 'ctr': 3.64, 'depth_passenger_cnt': 0, 'cpm': 162.59, 'visit_page_cnt': 13, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 38.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 35.77, 'coupon_cnt': 1, 'total_order_sum': 99.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.77, 'new_customers_cnt': 1, 'impressions': 220, 'indirect_order_sum': 99.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 12.5, 'cpa': 35.77, 'cpc': 4.47, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220515', 'ctr': 1.77, 'depth_passenger_cnt': 0, 'cpm': 116.59, 'visit_page_cnt': 13, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 22.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 6, 'cost': 46.17, 'coupon_cnt': 1, 'total_order_sum': 69.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.49, 'new_customers_cnt': 1, 'impressions': 396, 'indirect_order_sum': 0.0, 'direct_order_sum': 69.0, 'goods_attention_cnt': 0, 'total_order_cvs': 14.29, 'cpa': 46.17, 'cpc': 6.6, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220515', 'ctr': 0.67, 'depth_passenger_cnt': 0, 'cpm': 43.71, 'visit_page_cnt': 80, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 23.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 7, 'cost': 51.93, 'coupon_cnt': 0, 'total_order_sum': 460.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 8.86, 'new_customers_cnt': 1, 'impressions': 1188, 'indirect_order_sum': 0.0, 'direct_order_sum': 460.0, 'goods_attention_cnt': 1, 'total_order_cvs': 25.0, 'cpa': 25.97, 'cpc': 6.49, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220515', 'ctr': 17.39, 'depth_passenger_cnt': 0, 'cpm': 3369.13, 'visit_page_cnt': 18, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 40.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 77.49, 'coupon_cnt': 1, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 23, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 19.37, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220515', 'ctr': 6.73, 'depth_passenger_cnt': 0, 'cpm': 1067.98, 'visit_page_cnt': 110, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 2, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 31.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 10, 'cost': 222.14, 'coupon_cnt': 3, 'total_order_sum': 416.0, 'total_cart_cnt': 11, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.87, 'new_customers_cnt': 3, 'impressions': 208, 'indirect_order_sum': 278.0, 'direct_order_sum': 138.0, 'goods_attention_cnt': 0, 'total_order_cvs': 28.57, 'cpa': 55.54, 'cpc': 15.87, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 14, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-15', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220515', 'ctr': 0.81, 'depth_passenger_cnt': 0, 'cpm': 39.52, 'visit_page_cnt': 4, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 46.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 2, 'cost': 9.8, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 248, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.9, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220514', 'ctr': 3.39, 'depth_passenger_cnt': 0, 'cpm': 64.75, 'visit_page_cnt': 3, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 4.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 3.82, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 59, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.91, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220514', 'ctr': 5.42, 'depth_passenger_cnt': 2, 'cpm': 124.49, 'visit_page_cnt': 116, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 12, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 26.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 30, 'cost': 89.63, 'coupon_cnt': 6, 'total_order_sum': 64.4, 'total_cart_cnt': 19, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.72, 'new_customers_cnt': 3, 'impressions': 720, 'indirect_order_sum': 51.6, 'direct_order_sum': 12.8, 'goods_attention_cnt': 0, 'total_order_cvs': 7.69, 'cpa': 29.88, 'cpc': 2.3, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 39, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220514', 'ctr': 3.16, 'depth_passenger_cnt': 0, 'cpm': 68.02, 'visit_page_cnt': 24, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 16.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 6, 'cost': 17.21, 'coupon_cnt': 1, 'total_order_sum': 0.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 253, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 2.15, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220514', 'ctr': 1.49, 'depth_passenger_cnt': 0, 'cpm': 110.53, 'visit_page_cnt': 43, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 21.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 7, 'cost': 88.87, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 804, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 1, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 7.41, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 12, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220514', 'ctr': 3.16, 'depth_passenger_cnt': 0, 'cpm': 229.54, 'visit_page_cnt': 64, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 10.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 9, 'cost': 109.03, 'coupon_cnt': 1, 'total_order_sum': 0.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 475, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 7.27, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 15, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220514', 'ctr': 4.26, 'depth_passenger_cnt': 0, 'cpm': 573.69, 'visit_page_cnt': 18, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 41.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 5, 'cost': 80.89, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 141, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 13.48, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220514', 'ctr': 6.84, 'depth_passenger_cnt': 0, 'cpm': 1202.0, 'visit_page_cnt': 47, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 24.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 10, 'cost': 228.38, 'coupon_cnt': 3, 'total_order_sum': 290.9, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.27, 'new_customers_cnt': 0, 'impressions': 190, 'indirect_order_sum': 221.0, 'direct_order_sum': 69.9, 'goods_attention_cnt': 0, 'total_order_cvs': 15.38, 'cpa': 114.19, 'cpc': 17.57, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 13, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220514', 'ctr': 1.25, 'depth_passenger_cnt': 0, 'cpm': 93.13, 'visit_page_cnt': 23, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 32.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 4, 'cost': 29.71, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 319, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 7.43, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220514', 'ctr': 4.19, 'depth_passenger_cnt': 13, 'cpm': 138.63, 'visit_page_cnt': 152, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 4, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 25.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 17, 'visitor_cnt': 52, 'cost': 231.37, 'coupon_cnt': 0, 'total_order_sum': 236.0, 'total_cart_cnt': 19, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.02, 'new_customers_cnt': 4, 'impressions': 1669, 'indirect_order_sum': 0.0, 'direct_order_sum': 236.0, 'goods_attention_cnt': 0, 'total_order_cvs': 5.71, 'cpa': 57.84, 'cpc': 3.31, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 70, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220514', 'ctr': 4.18, 'depth_passenger_cnt': 3, 'cpm': 452.9, 'visit_page_cnt': 89, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 2, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 47.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 18, 'cost': 346.92, 'coupon_cnt': 4, 'total_order_sum': 1319.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.8, 'new_customers_cnt': 4, 'impressions': 766, 'indirect_order_sum': 580.0, 'direct_order_sum': 739.0, 'goods_attention_cnt': 0, 'total_order_cvs': 12.5, 'cpa': 86.73, 'cpc': 10.84, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 32, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220514', 'ctr': 4.49, 'depth_passenger_cnt': 0, 'cpm': 647.98, 'visit_page_cnt': 10, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 69.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 4, 'cost': 57.67, 'coupon_cnt': 1, 'total_order_sum': 159.8, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.77, 'new_customers_cnt': 1, 'impressions': 89, 'indirect_order_sum': 0.0, 'direct_order_sum': 159.8, 'goods_attention_cnt': 0, 'total_order_cvs': 50.0, 'cpa': 28.84, 'cpc': 14.42, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220514', 'ctr': 4.95, 'depth_passenger_cnt': 1, 'cpm': 204.65, 'visit_page_cnt': 46, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 23.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 17, 'cost': 95.16, 'coupon_cnt': 0, 'total_order_sum': 136.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.43, 'new_customers_cnt': 1, 'impressions': 465, 'indirect_order_sum': 136.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 4.35, 'cpa': 95.16, 'cpc': 4.14, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 23, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220514', 'ctr': 1.23, 'depth_passenger_cnt': 0, 'cpm': 18.77, 'visit_page_cnt': 1, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 3.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 1.52, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 81, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.52, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 1, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-14', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220514', 'ctr': 2.91, 'depth_passenger_cnt': 4, 'cpm': 72.54, 'visit_page_cnt': 48, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 17.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 13, 'cost': 52.3, 'coupon_cnt': 0, 'total_order_sum': 196.2, 'total_cart_cnt': 9, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.75, 'new_customers_cnt': 3, 'impressions': 721, 'indirect_order_sum': 168.3, 'direct_order_sum': 27.9, 'goods_attention_cnt': 1, 'total_order_cvs': 14.29, 'cpa': 17.43, 'cpc': 2.49, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 21, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220513', 'ctr': 0.56, 'depth_passenger_cnt': 0, 'cpm': 71.01, 'visit_page_cnt': 6, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 30.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 25.21, 'coupon_cnt': 0, 'total_order_sum': 209.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 8.29, 'new_customers_cnt': 1, 'impressions': 355, 'indirect_order_sum': 209.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 50.0, 'cpa': 25.21, 'cpc': 12.61, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220513', 'ctr': 6.01, 'depth_passenger_cnt': 0, 'cpm': 1726.5, 'visit_page_cnt': 75, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 1, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 29.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 10, 'cost': 315.95, 'coupon_cnt': 1, 'total_order_sum': 137.7, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.44, 'new_customers_cnt': 2, 'impressions': 183, 'indirect_order_sum': 64.7, 'direct_order_sum': 73.0, 'goods_attention_cnt': 0, 'total_order_cvs': 36.36, 'cpa': 78.99, 'cpc': 28.72, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 11, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220513', 'ctr': 1.8, 'depth_passenger_cnt': 0, 'cpm': 176.41, 'visit_page_cnt': 23, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 24.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 10, 'cost': 167.06, 'coupon_cnt': 0, 'total_order_sum': 99.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.59, 'new_customers_cnt': 0, 'impressions': 947, 'indirect_order_sum': 99.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 5.88, 'cpa': 167.06, 'cpc': 9.83, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 17, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220513', 'ctr': 2.9, 'depth_passenger_cnt': 0, 'cpm': 220.14, 'visit_page_cnt': 15, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 55.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 8, 'cost': 75.95, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 345, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 7.6, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 10, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220513', 'ctr': 5.81, 'depth_passenger_cnt': 0, 'cpm': 162.95, 'visit_page_cnt': 65, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 12, 'direct_order_cnt': 0, 'indirect_cart_cnt': 17, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 27.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 7, 'cost': 39.27, 'coupon_cnt': 2, 'total_order_sum': 1188.0, 'total_cart_cnt': 19, 'presale_indirect_order_cnt': 0, 'total_order_roi': 30.25, 'new_customers_cnt': 0, 'impressions': 241, 'indirect_order_sum': 1188.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 85.71, 'cpa': 3.27, 'cpc': 2.81, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 14, 'total_order_cnt': 12, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677598445, 'click_date': '20220513', 'ctr': 7.69, 'depth_passenger_cnt': 0, 'cpm': 1494.23, 'visit_page_cnt': 20, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒72粒', 'visit_time_average': 22.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 77.7, 'coupon_cnt': 1, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 52, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 19.43, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220513', 'ctr': 6.78, 'depth_passenger_cnt': 3, 'cpm': 163.24, 'visit_page_cnt': 122, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 21.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 23, 'cost': 79.5, 'coupon_cnt': 0, 'total_order_sum': 12.8, 'total_cart_cnt': 11, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.16, 'new_customers_cnt': 1, 'impressions': 487, 'indirect_order_sum': 0.0, 'direct_order_sum': 12.8, 'goods_attention_cnt': 0, 'total_order_cvs': 3.03, 'cpa': 79.5, 'cpc': 2.41, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 33, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220513', 'ctr': 5.08, 'depth_passenger_cnt': 0, 'cpm': 51.36, 'visit_page_cnt': 9, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 14.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 3.03, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 59, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.01, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220513', 'ctr': 3.38, 'depth_passenger_cnt': 0, 'cpm': 690.68, 'visit_page_cnt': 39, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 4, 'direct_order_cnt': 0, 'indirect_cart_cnt': 8, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 45.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 5, 'cost': 102.22, 'coupon_cnt': 0, 'total_order_sum': 152.97, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.5, 'new_customers_cnt': 0, 'impressions': 148, 'indirect_order_sum': 152.97, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 80.0, 'cpa': 25.56, 'cpc': 20.44, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 5, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 677648580, 'click_date': '20220513', 'ctr': 3.39, 'depth_passenger_cnt': 0, 'cpm': 85.25, 'visit_page_cnt': 17, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒120粒', 'visit_time_average': 57.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 5.03, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 59, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 2.52, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220513', 'ctr': 6.45, 'depth_passenger_cnt': 1, 'cpm': 158.81, 'visit_page_cnt': 169, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 5, 'direct_order_cnt': 7, 'indirect_cart_cnt': 6, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 19.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 13, 'visitor_cnt': 56, 'cost': 187.24, 'coupon_cnt': 0, 'total_order_sum': 1292.0, 'total_cart_cnt': 19, 'presale_indirect_order_cnt': 0, 'total_order_roi': 6.9, 'new_customers_cnt': 11, 'impressions': 1179, 'indirect_order_sum': 816.0, 'direct_order_sum': 476.0, 'goods_attention_cnt': 0, 'total_order_cvs': 15.79, 'cpa': 15.6, 'cpc': 2.46, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 76, 'total_order_cnt': 12, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220513', 'ctr': 3.42, 'depth_passenger_cnt': 4, 'cpm': 163.93, 'visit_page_cnt': 98, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 26.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 24, 'cost': 153.27, 'coupon_cnt': 0, 'total_order_sum': 110.2, 'total_cart_cnt': 9, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.72, 'new_customers_cnt': 2, 'impressions': 935, 'indirect_order_sum': 83.3, 'direct_order_sum': 26.9, 'goods_attention_cnt': 0, 'total_order_cvs': 6.25, 'cpa': 76.64, 'cpc': 4.79, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 32, 'total_order_cnt': 2, 'shop_attention_cnt': 1}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220513', 'ctr': 3.26, 'depth_passenger_cnt': 2, 'cpm': 531.43, 'visit_page_cnt': 81, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 23.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 19, 'cost': 408.14, 'coupon_cnt': 2, 'total_order_sum': 940.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.3, 'new_customers_cnt': 3, 'impressions': 768, 'indirect_order_sum': 781.0, 'direct_order_sum': 159.0, 'goods_attention_cnt': 1, 'total_order_cvs': 12.0, 'cpa': 136.05, 'cpc': 16.33, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 25, 'total_order_cnt': 3, 'shop_attention_cnt': 1}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-13', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220513', 'ctr': 3.52, 'depth_passenger_cnt': 6, 'cpm': 163.1, 'visit_page_cnt': 172, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 5, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 15.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 14, 'visitor_cnt': 30, 'cost': 199.14, 'coupon_cnt': 1, 'total_order_sum': 280.0, 'total_cart_cnt': 15, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.41, 'new_customers_cnt': 5, 'impressions': 1221, 'indirect_order_sum': 0.0, 'direct_order_sum': 280.0, 'goods_attention_cnt': 3, 'total_order_cvs': 11.63, 'cpa': 39.83, 'cpc': 4.63, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 43, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-12', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220512', 'ctr': 5.13, 'depth_passenger_cnt': 0, 'cpm': 740.56, 'visit_page_cnt': 36, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 16.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 7, 'cost': 144.41, 'coupon_cnt': 0, 'total_order_sum': 146.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.01, 'new_customers_cnt': 0, 'impressions': 195, 'indirect_order_sum': 146.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 10.0, 'cpa': 144.41, 'cpc': 14.44, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 10, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-12', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220512', 'ctr': 19.11, 'depth_passenger_cnt': 0, 'cpm': 619.87, 'visit_page_cnt': 67, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 4, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 26.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 11, 'visitor_cnt': 20, 'cost': 97.32, 'coupon_cnt': 0, 'total_order_sum': 272.0, 'total_cart_cnt': 11, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.79, 'new_customers_cnt': 4, 'impressions': 157, 'indirect_order_sum': 0.0, 'direct_order_sum': 272.0, 'goods_attention_cnt': 0, 'total_order_cvs': 13.33, 'cpa': 24.33, 'cpc': 3.24, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 30, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-12', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220512', 'ctr': 1.8, 'depth_passenger_cnt': 7, 'cpm': 24.6, 'visit_page_cnt': 48, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 18.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 13, 'cost': 24.58, 'coupon_cnt': 0, 'total_order_sum': 99.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 4.03, 'new_customers_cnt': 1, 'impressions': 999, 'indirect_order_sum': 99.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 5.56, 'cpa': 24.58, 'cpc': 1.37, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 18, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-12', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220512', 'ctr': 3.38, 'depth_passenger_cnt': 3, 'cpm': 567.94, 'visit_page_cnt': 66, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 2, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 32.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 12, 'visitor_cnt': 17, 'cost': 437.31, 'coupon_cnt': 1, 'total_order_sum': 956.0, 'total_cart_cnt': 14, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.19, 'new_customers_cnt': 4, 'impressions': 770, 'indirect_order_sum': 479.0, 'direct_order_sum': 477.0, 'goods_attention_cnt': 0, 'total_order_cvs': 15.38, 'cpa': 109.33, 'cpc': 16.82, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 26, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-12', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220512', 'ctr': 3.47, 'depth_passenger_cnt': 9, 'cpm': 103.32, 'visit_page_cnt': 98, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 16.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 25, 'cost': 104.25, 'coupon_cnt': 0, 'total_order_sum': 112.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.07, 'new_customers_cnt': 1, 'impressions': 1009, 'indirect_order_sum': 0.0, 'direct_order_sum': 112.0, 'goods_attention_cnt': 0, 'total_order_cvs': 5.71, 'cpa': 52.13, 'cpc': 2.98, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 35, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-12', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220512', 'ctr': 4.68, 'depth_passenger_cnt': 2, 'cpm': 562.81, 'visit_page_cnt': 38, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 25.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 9, 'cost': 156.46, 'coupon_cnt': 0, 'total_order_sum': 334.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.13, 'new_customers_cnt': 2, 'impressions': 278, 'indirect_order_sum': 179.0, 'direct_order_sum': 155.0, 'goods_attention_cnt': 0, 'total_order_cvs': 15.38, 'cpa': 78.23, 'cpc': 12.04, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 13, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-12', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220512', 'ctr': 5.56, 'depth_passenger_cnt': 0, 'cpm': 982.36, 'visit_page_cnt': 31, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 23.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 5, 'cost': 141.46, 'coupon_cnt': 2, 'total_order_sum': 73.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.52, 'new_customers_cnt': 0, 'impressions': 144, 'indirect_order_sum': 0.0, 'direct_order_sum': 73.0, 'goods_attention_cnt': 0, 'total_order_cvs': 12.5, 'cpa': 141.46, 'cpc': 17.68, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-12', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220512', 'ctr': 2.31, 'depth_passenger_cnt': 0, 'cpm': 217.88, 'visit_page_cnt': 42, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 30.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 12, 'cost': 122.45, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 562, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 9.42, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 13, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-12', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220512', 'ctr': 2.16, 'depth_passenger_cnt': 0, 'cpm': 217.04, 'visit_page_cnt': 38, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 0, 'indirect_cart_cnt': 6, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 32.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 16, 'cost': 190.56, 'coupon_cnt': 1, 'total_order_sum': 32.8, 'total_cart_cnt': 9, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.17, 'new_customers_cnt': 1, 'impressions': 878, 'indirect_order_sum': 32.8, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 10.53, 'cpa': 95.28, 'cpc': 10.03, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 19, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-12', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220512', 'ctr': 1.14, 'depth_passenger_cnt': 0, 'cpm': 14.09, 'visit_page_cnt': 2, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 8.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 2.48, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 176, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.24, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-12', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220512', 'ctr': 7.15, 'depth_passenger_cnt': 2, 'cpm': 120.52, 'visit_page_cnt': 316, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 3, 'indirect_cart_cnt': 56, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 14.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 29, 'cost': 74.12, 'coupon_cnt': 6, 'total_order_sum': 30060.1, 'total_cart_cnt': 62, 'presale_indirect_order_cnt': 0, 'total_order_roi': 405.56, 'new_customers_cnt': 5, 'impressions': 615, 'indirect_order_sum': 30000.0, 'direct_order_sum': 60.1, 'goods_attention_cnt': 0, 'total_order_cvs': 13.64, 'cpa': 12.35, 'cpc': 1.68, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 44, 'total_order_cnt': 6, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-12', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220512', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 51, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-11', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220511', 'ctr': 2.25, 'depth_passenger_cnt': 0, 'cpm': 23.6, 'visit_page_cnt': 1, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 129.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 2.1, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 89, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.05, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-11', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220511', 'ctr': 4.48, 'depth_passenger_cnt': 1, 'cpm': 110.08, 'visit_page_cnt': 141, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 6, 'direct_order_cnt': 2, 'indirect_cart_cnt': 11, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 22.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 28, 'cost': 93.35, 'coupon_cnt': 7, 'total_order_sum': 163.3, 'total_cart_cnt': 16, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.75, 'new_customers_cnt': 4, 'impressions': 848, 'indirect_order_sum': 137.7, 'direct_order_sum': 25.6, 'goods_attention_cnt': 0, 'total_order_cvs': 21.05, 'cpa': 11.67, 'cpc': 2.46, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 38, 'total_order_cnt': 8, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-11', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220511', 'ctr': 1.67, 'depth_passenger_cnt': 0, 'cpm': 105.67, 'visit_page_cnt': 54, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 47.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 8, 'cost': 69.53, 'coupon_cnt': 1, 'total_order_sum': 96.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.38, 'new_customers_cnt': 1, 'impressions': 658, 'indirect_order_sum': 96.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.09, 'cpa': 69.53, 'cpc': 6.32, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 11, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-11', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220511', 'ctr': 1.29, 'depth_passenger_cnt': 0, 'cpm': 101.57, 'visit_page_cnt': 63, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 0, 'indirect_cart_cnt': 8, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 27.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 10, 'cost': 86.44, 'coupon_cnt': 0, 'total_order_sum': 468.8, 'total_cart_cnt': 11, 'presale_indirect_order_cnt': 0, 'total_order_roi': 5.42, 'new_customers_cnt': 1, 'impressions': 851, 'indirect_order_sum': 468.8, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 27.27, 'cpa': 28.81, 'cpc': 7.86, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 11, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-11', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220511', 'ctr': 2.99, 'depth_passenger_cnt': 0, 'cpm': 5.75, 'visit_page_cnt': 18, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 12.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 2, 'cost': 0.77, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 134, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.19, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-11', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220511', 'ctr': 2.73, 'depth_passenger_cnt': 0, 'cpm': 336.14, 'visit_page_cnt': 79, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 27.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 12, 'cost': 209.08, 'coupon_cnt': 0, 'total_order_sum': 448.0, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.14, 'new_customers_cnt': 2, 'impressions': 622, 'indirect_order_sum': 293.0, 'direct_order_sum': 155.0, 'goods_attention_cnt': 0, 'total_order_cvs': 17.65, 'cpa': 69.69, 'cpc': 12.3, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 17, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-11', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220511', 'ctr': 8.39, 'depth_passenger_cnt': 0, 'cpm': 1171.61, 'visit_page_cnt': 72, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 2, 'indirect_cart_cnt': 9, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 20.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 9, 'cost': 167.54, 'coupon_cnt': 2, 'total_order_sum': 529.9, 'total_cart_cnt': 14, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.16, 'new_customers_cnt': 2, 'impressions': 143, 'indirect_order_sum': 383.9, 'direct_order_sum': 146.0, 'goods_attention_cnt': 0, 'total_order_cvs': 33.33, 'cpa': 41.89, 'cpc': 13.96, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 12, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-11', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220511', 'ctr': 4.91, 'depth_passenger_cnt': 12, 'cpm': 230.89, 'visit_page_cnt': 226, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 7, 'indirect_cart_cnt': 8, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 17.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 14, 'visitor_cnt': 45, 'cost': 296.0, 'coupon_cnt': 0, 'total_order_sum': 402.0, 'total_cart_cnt': 22, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.36, 'new_customers_cnt': 7, 'impressions': 1282, 'indirect_order_sum': 0.0, 'direct_order_sum': 402.0, 'goods_attention_cnt': 0, 'total_order_cvs': 11.11, 'cpa': 42.29, 'cpc': 4.7, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 63, 'total_order_cnt': 7, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-11', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220511', 'ctr': 5.77, 'depth_passenger_cnt': 1, 'cpm': 1347.19, 'visit_page_cnt': 58, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 23.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 24, 'cost': 747.69, 'coupon_cnt': 2, 'total_order_sum': 308.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.41, 'new_customers_cnt': 1, 'impressions': 555, 'indirect_order_sum': 0.0, 'direct_order_sum': 308.0, 'goods_attention_cnt': 0, 'total_order_cvs': 3.13, 'cpa': 747.69, 'cpc': 23.37, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 32, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-11', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220511', 'ctr': 1.56, 'depth_passenger_cnt': 5, 'cpm': 19.39, 'visit_page_cnt': 49, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 37.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 15, 'cost': 28.52, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 1471, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 1, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.24, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 23, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-11', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220511', 'ctr': 8.43, 'depth_passenger_cnt': 0, 'cpm': 240.63, 'visit_page_cnt': 81, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 5, 'indirect_cart_cnt': 9, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 23.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 24, 'cost': 99.86, 'coupon_cnt': 2, 'total_order_sum': 385.8, 'total_cart_cnt': 15, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.86, 'new_customers_cnt': 5, 'impressions': 415, 'indirect_order_sum': 25.8, 'direct_order_sum': 360.0, 'goods_attention_cnt': 0, 'total_order_cvs': 20.0, 'cpa': 14.27, 'cpc': 2.85, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 35, 'total_order_cnt': 7, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-11', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220511', 'ctr': 8.08, 'depth_passenger_cnt': 0, 'cpm': 1212.17, 'visit_page_cnt': 86, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 40.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 15, 'cost': 240.01, 'coupon_cnt': 2, 'total_order_sum': 173.8, 'total_cart_cnt': 7, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.72, 'new_customers_cnt': 0, 'impressions': 198, 'indirect_order_sum': 98.9, 'direct_order_sum': 74.9, 'goods_attention_cnt': 0, 'total_order_cvs': 18.75, 'cpa': 80.0, 'cpc': 15.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 16, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-10', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220510', 'ctr': 2.59, 'depth_passenger_cnt': 4, 'cpm': 56.74, 'visit_page_cnt': 48, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 13.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 21, 'cost': 70.02, 'coupon_cnt': 0, 'total_order_sum': 118.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.69, 'new_customers_cnt': 2, 'impressions': 1234, 'indirect_order_sum': 0.0, 'direct_order_sum': 118.0, 'goods_attention_cnt': 0, 'total_order_cvs': 6.25, 'cpa': 35.01, 'cpc': 2.19, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 32, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-10', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220510', 'ctr': 6.08, 'depth_passenger_cnt': 6, 'cpm': 1205.2, 'visit_page_cnt': 166, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 4, 'direct_order_cnt': 5, 'indirect_cart_cnt': 6, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 24.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 19, 'visitor_cnt': 30, 'cost': 1089.5, 'coupon_cnt': 7, 'total_order_sum': 2675.0, 'total_cart_cnt': 25, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.46, 'new_customers_cnt': 7, 'impressions': 904, 'indirect_order_sum': 1252.0, 'direct_order_sum': 1423.0, 'goods_attention_cnt': 0, 'total_order_cvs': 16.36, 'cpa': 121.06, 'cpc': 19.81, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 55, 'total_order_cnt': 9, 'shop_attention_cnt': 1}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-10', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220510', 'ctr': 1.35, 'depth_passenger_cnt': 4, 'cpm': 15.1, 'visit_page_cnt': 16, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 28.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 11, 'cost': 20.08, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 1330, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.12, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 18, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-10', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220510', 'ctr': 9.55, 'depth_passenger_cnt': 1, 'cpm': 366.8, 'visit_page_cnt': 97, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 5, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 18.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 11, 'visitor_cnt': 31, 'cost': 195.87, 'coupon_cnt': 1, 'total_order_sum': 340.0, 'total_cart_cnt': 13, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.74, 'new_customers_cnt': 4, 'impressions': 534, 'indirect_order_sum': 0.0, 'direct_order_sum': 340.0, 'goods_attention_cnt': 1, 'total_order_cvs': 9.8, 'cpa': 39.17, 'cpc': 3.84, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 51, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-10', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220510', 'ctr': 5.38, 'depth_passenger_cnt': 0, 'cpm': 683.01, 'visit_page_cnt': 238, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 4, 'direct_order_cnt': 2, 'indirect_cart_cnt': 21, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 25.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 19, 'cost': 254.08, 'coupon_cnt': 4, 'total_order_sum': 486.7, 'total_cart_cnt': 24, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.92, 'new_customers_cnt': 2, 'impressions': 372, 'indirect_order_sum': 262.0, 'direct_order_sum': 224.7, 'goods_attention_cnt': 0, 'total_order_cvs': 30.0, 'cpa': 42.35, 'cpc': 12.7, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 20, 'total_order_cnt': 6, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-10', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220510', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 94, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-10', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220510', 'ctr': 6.13, 'depth_passenger_cnt': 0, 'cpm': 111.61, 'visit_page_cnt': 135, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 7, 'direct_order_cnt': 2, 'indirect_cart_cnt': 20, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 22.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 11, 'visitor_cnt': 42, 'cost': 114.73, 'coupon_cnt': 4, 'total_order_sum': 272.8, 'total_cart_cnt': 31, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.38, 'new_customers_cnt': 8, 'impressions': 1028, 'indirect_order_sum': 234.4, 'direct_order_sum': 38.4, 'goods_attention_cnt': 0, 'total_order_cvs': 14.29, 'cpa': 12.75, 'cpc': 1.82, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 63, 'total_order_cnt': 9, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-10', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220510', 'ctr': 1.23, 'depth_passenger_cnt': 0, 'cpm': 54.26, 'visit_page_cnt': 42, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 25.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 11, 'cost': 57.3, 'coupon_cnt': 1, 'total_order_sum': 451.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 7.87, 'new_customers_cnt': 3, 'impressions': 1056, 'indirect_order_sum': 392.0, 'direct_order_sum': 59.0, 'goods_attention_cnt': 0, 'total_order_cvs': 23.08, 'cpa': 19.1, 'cpc': 4.41, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 13, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-10', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220510', 'ctr': 2.46, 'depth_passenger_cnt': 0, 'cpm': 120.02, 'visit_page_cnt': 65, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 37.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 13, 'cost': 68.29, 'coupon_cnt': 1, 'total_order_sum': 168.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.46, 'new_customers_cnt': 2, 'impressions': 569, 'indirect_order_sum': 99.0, 'direct_order_sum': 69.0, 'goods_attention_cnt': 0, 'total_order_cvs': 14.29, 'cpa': 34.15, 'cpc': 4.88, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 14, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-10', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220510', 'ctr': 2.9, 'depth_passenger_cnt': 0, 'cpm': 252.54, 'visit_page_cnt': 4, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 81.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 2, 'cost': 34.85, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 138, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 8.71, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-10', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220510', 'ctr': 1.16, 'depth_passenger_cnt': 0, 'cpm': 52.06, 'visit_page_cnt': 13, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 39.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 4, 'cost': 22.44, 'coupon_cnt': 0, 'total_order_sum': 159.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 7.09, 'new_customers_cnt': 1, 'impressions': 431, 'indirect_order_sum': 0.0, 'direct_order_sum': 159.0, 'goods_attention_cnt': 0, 'total_order_cvs': 20.0, 'cpa': 22.44, 'cpc': 4.49, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 5, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-10', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220510', 'ctr': 2.33, 'depth_passenger_cnt': 0, 'cpm': 254.94, 'visit_page_cnt': 42, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 23.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 4, 'cost': 43.85, 'coupon_cnt': 2, 'total_order_sum': 73.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.66, 'new_customers_cnt': 1, 'impressions': 172, 'indirect_order_sum': 0.0, 'direct_order_sum': 73.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 43.85, 'cpc': 10.96, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220509', 'ctr': 5.0, 'depth_passenger_cnt': 10, 'cpm': 769.45, 'visit_page_cnt': 112, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 4, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 38.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 13, 'visitor_cnt': 38, 'cost': 877.94, 'coupon_cnt': 4, 'total_order_sum': 1254.0, 'total_cart_cnt': 16, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.43, 'new_customers_cnt': 4, 'impressions': 1141, 'indirect_order_sum': 320.0, 'direct_order_sum': 934.0, 'goods_attention_cnt': 1, 'total_order_cvs': 8.77, 'cpa': 175.59, 'cpc': 15.4, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 57, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220509', 'ctr': 7.31, 'depth_passenger_cnt': 7, 'cpm': 94.24, 'visit_page_cnt': 122, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 1, 'indirect_cart_cnt': 6, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 48.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 29, 'cost': 52.87, 'coupon_cnt': 0, 'total_order_sum': 20204.0, 'total_cart_cnt': 13, 'presale_indirect_order_cnt': 0, 'total_order_roi': 382.14, 'new_customers_cnt': 2, 'impressions': 561, 'indirect_order_sum': 20136.0, 'direct_order_sum': 68.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.76, 'cpa': 13.22, 'cpc': 1.29, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 41, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220509', 'ctr': 1.97, 'depth_passenger_cnt': 1, 'cpm': 56.52, 'visit_page_cnt': 84, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 20.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 15, 'visitor_cnt': 24, 'cost': 91.62, 'coupon_cnt': 0, 'total_order_sum': 53.8, 'total_cart_cnt': 15, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.59, 'new_customers_cnt': 2, 'impressions': 1621, 'indirect_order_sum': 0.0, 'direct_order_sum': 53.8, 'goods_attention_cnt': 0, 'total_order_cvs': 6.25, 'cpa': 45.81, 'cpc': 2.86, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 32, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220509', 'ctr': 3.6, 'depth_passenger_cnt': 6, 'cpm': 826.26, 'visit_page_cnt': 34, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 6, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 33.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 9, 'cost': 229.7, 'coupon_cnt': 1, 'total_order_sum': 159.8, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.7, 'new_customers_cnt': 0, 'impressions': 278, 'indirect_order_sum': 0.0, 'direct_order_sum': 159.8, 'goods_attention_cnt': 0, 'total_order_cvs': 20.0, 'cpa': 114.85, 'cpc': 22.97, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 10, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220509', 'ctr': 3.74, 'depth_passenger_cnt': 4, 'cpm': 71.53, 'visit_page_cnt': 76, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 11.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 22, 'cost': 63.09, 'coupon_cnt': 0, 'total_order_sum': 324.0, 'total_cart_cnt': 14, 'presale_indirect_order_cnt': 0, 'total_order_roi': 5.14, 'new_customers_cnt': 2, 'impressions': 882, 'indirect_order_sum': 209.0, 'direct_order_sum': 115.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.09, 'cpa': 21.03, 'cpc': 1.91, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 33, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220509', 'ctr': 6.08, 'depth_passenger_cnt': 0, 'cpm': 994.19, 'visit_page_cnt': 146, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 1, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 27.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 18, 'cost': 327.09, 'coupon_cnt': 0, 'total_order_sum': 304.7, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.93, 'new_customers_cnt': 1, 'impressions': 329, 'indirect_order_sum': 59.7, 'direct_order_sum': 245.0, 'goods_attention_cnt': 0, 'total_order_cvs': 20.0, 'cpa': 81.77, 'cpc': 16.35, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 20, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220509', 'ctr': 0.76, 'depth_passenger_cnt': 0, 'cpm': 53.92, 'visit_page_cnt': 6, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 57.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 28.36, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 526, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 7.09, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220509', 'ctr': 4.39, 'depth_passenger_cnt': 95, 'cpm': 57.12, 'visit_page_cnt': 2124, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 5, 'direct_order_cnt': 0, 'indirect_cart_cnt': 118, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 20.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 14, 'cost': 11.71, 'coupon_cnt': 13, 'total_order_sum': 40099.0, 'total_cart_cnt': 119, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3424.34, 'new_customers_cnt': 1, 'impressions': 205, 'indirect_order_sum': 40099.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 1, 'total_order_cvs': 55.56, 'cpa': 2.34, 'cpc': 1.3, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 9, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220509', 'ctr': 1.59, 'depth_passenger_cnt': 0, 'cpm': 58.57, 'visit_page_cnt': 5, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 15.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 3, 'cost': 14.76, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 252, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 3.69, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220509', 'ctr': 5.74, 'depth_passenger_cnt': 5, 'cpm': 835.93, 'visit_page_cnt': 56, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 40.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 17, 'cost': 305.95, 'coupon_cnt': 3, 'total_order_sum': 225.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.74, 'new_customers_cnt': 0, 'impressions': 366, 'indirect_order_sum': 225.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 4.76, 'cpa': 305.95, 'cpc': 14.57, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 21, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 674939130, 'click_date': '20220509', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒120粒', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 66, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 11, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 405140640, 'click_date': '20220509', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '秒杀计划', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 17, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-09', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220509', 'ctr': 6.64, 'depth_passenger_cnt': 1, 'cpm': 103.15, 'visit_page_cnt': 119, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 6, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 19.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 16, 'visitor_cnt': 50, 'cost': 125.84, 'coupon_cnt': 2, 'total_order_sum': 126.5, 'total_cart_cnt': 20, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.01, 'new_customers_cnt': 6, 'impressions': 1220, 'indirect_order_sum': 36.9, 'direct_order_sum': 89.6, 'goods_attention_cnt': 0, 'total_order_cvs': 8.64, 'cpa': 17.98, 'cpc': 1.55, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 81, 'total_order_cnt': 7, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-08', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220508', 'ctr': 1.85, 'depth_passenger_cnt': 0, 'cpm': 126.58, 'visit_page_cnt': 12, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 11.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 8, 'cost': 54.81, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 433, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 6.85, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-08', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220508', 'ctr': 6.97, 'depth_passenger_cnt': 0, 'cpm': 756.35, 'visit_page_cnt': 40, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 4, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 34.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 12, 'cost': 184.55, 'coupon_cnt': 0, 'total_order_sum': 496.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.69, 'new_customers_cnt': 2, 'impressions': 244, 'indirect_order_sum': 299.0, 'direct_order_sum': 197.0, 'goods_attention_cnt': 0, 'total_order_cvs': 29.41, 'cpa': 36.91, 'cpc': 10.86, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 17, 'total_order_cnt': 5, 'shop_attention_cnt': 1}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-08', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220508', 'ctr': 2.79, 'depth_passenger_cnt': 0, 'cpm': 158.72, 'visit_page_cnt': 5, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 73.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 3, 'cost': 28.41, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 179, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 5.68, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 5, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-08', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220508', 'ctr': 1.49, 'depth_passenger_cnt': 0, 'cpm': 62.43, 'visit_page_cnt': 14, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 5.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 12.61, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 202, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.2, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-08', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220508', 'ctr': 4.86, 'depth_passenger_cnt': 3, 'cpm': 659.0, 'visit_page_cnt': 40, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 38.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 15, 'cost': 216.81, 'coupon_cnt': 0, 'total_order_sum': 149.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.69, 'new_customers_cnt': 0, 'impressions': 329, 'indirect_order_sum': 149.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 6.25, 'cpa': 216.81, 'cpc': 13.55, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 16, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-08', 'mobile_type': '全部', 'campaign_type': 11, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 405140640, 'click_date': '20220508', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '秒杀计划', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 8, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-08', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220508', 'ctr': 5.44, 'depth_passenger_cnt': 0, 'cpm': 129.44, 'visit_page_cnt': 154, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 2, 'indirect_cart_cnt': 13, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 29.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 12, 'visitor_cnt': 51, 'cost': 199.99, 'coupon_cnt': 2, 'total_order_sum': 102.9, 'total_cart_cnt': 25, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.51, 'new_customers_cnt': 5, 'impressions': 1545, 'indirect_order_sum': 64.5, 'direct_order_sum': 38.4, 'goods_attention_cnt': 0, 'total_order_cvs': 5.95, 'cpa': 40.0, 'cpc': 2.38, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 84, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-08', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220508', 'ctr': 4.19, 'depth_passenger_cnt': 2, 'cpm': 548.54, 'visit_page_cnt': 94, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 3, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 28.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 29, 'cost': 706.52, 'coupon_cnt': 2, 'total_order_sum': 1729.0, 'total_cart_cnt': 12, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.45, 'new_customers_cnt': 6, 'impressions': 1288, 'indirect_order_sum': 1093.0, 'direct_order_sum': 636.0, 'goods_attention_cnt': 1, 'total_order_cvs': 11.11, 'cpa': 117.75, 'cpc': 13.08, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 54, 'total_order_cnt': 6, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-08', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 640039438, 'click_date': '20220508', 'ctr': 21.65, 'depth_passenger_cnt': 0, 'cpm': 254.43, 'visit_page_cnt': 46, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 2, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '太极睡好片', 'visit_time_average': 38.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 17, 'cost': 24.68, 'coupon_cnt': 0, 'total_order_sum': 340.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 13.78, 'new_customers_cnt': 3, 'impressions': 97, 'indirect_order_sum': 136.0, 'direct_order_sum': 204.0, 'goods_attention_cnt': 0, 'total_order_cvs': 14.29, 'cpa': 8.23, 'cpc': 1.18, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 21, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-08', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220508', 'ctr': 1.01, 'depth_passenger_cnt': 2, 'cpm': 20.61, 'visit_page_cnt': 45, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 30.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 8, 'visitor_cnt': 25, 'cost': 69.51, 'coupon_cnt': 0, 'total_order_sum': 53.8, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.77, 'new_customers_cnt': 1, 'impressions': 3373, 'indirect_order_sum': 0.0, 'direct_order_sum': 53.8, 'goods_attention_cnt': 0, 'total_order_cvs': 2.94, 'cpa': 69.51, 'cpc': 2.04, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 34, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-08', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220508', 'ctr': 13.38, 'depth_passenger_cnt': 3, 'cpm': 4048.45, 'visit_page_cnt': 62, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 35.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 17, 'cost': 574.88, 'coupon_cnt': 2, 'total_order_sum': 340.8, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.59, 'new_customers_cnt': 2, 'impressions': 142, 'indirect_order_sum': 265.9, 'direct_order_sum': 74.9, 'goods_attention_cnt': 0, 'total_order_cvs': 15.79, 'cpa': 191.63, 'cpc': 30.26, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 19, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-08', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220508', 'ctr': 4.07, 'depth_passenger_cnt': 5, 'cpm': 60.98, 'visit_page_cnt': 65, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 10.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 9, 'visitor_cnt': 20, 'cost': 35.92, 'coupon_cnt': 0, 'total_order_sum': 112.0, 'total_cart_cnt': 9, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.12, 'new_customers_cnt': 2, 'impressions': 589, 'indirect_order_sum': 0.0, 'direct_order_sum': 112.0, 'goods_attention_cnt': 0, 'total_order_cvs': 8.33, 'cpa': 17.96, 'cpc': 1.5, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 24, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-07', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220507', 'ctr': 0.99, 'depth_passenger_cnt': 0, 'cpm': 29.27, 'visit_page_cnt': 9, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 9.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 8.87, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 303, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 2.96, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-07', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220507', 'ctr': 8.12, 'depth_passenger_cnt': 0, 'cpm': 1716.45, 'visit_page_cnt': 53, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 3, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 36.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 13, 'cost': 401.65, 'coupon_cnt': 3, 'total_order_sum': 293.9, 'total_cart_cnt': 9, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.73, 'new_customers_cnt': 1, 'impressions': 234, 'indirect_order_sum': 74.9, 'direct_order_sum': 219.0, 'goods_attention_cnt': 0, 'total_order_cvs': 21.05, 'cpa': 100.41, 'cpc': 21.14, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 19, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-07', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220507', 'ctr': 8.55, 'depth_passenger_cnt': 0, 'cpm': 581.28, 'visit_page_cnt': 31, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 33.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 8, 'cost': 68.01, 'coupon_cnt': 0, 'total_order_sum': 547.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 8.04, 'new_customers_cnt': 3, 'impressions': 117, 'indirect_order_sum': 547.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 30.0, 'cpa': 22.67, 'cpc': 6.8, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 10, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-07', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220507', 'ctr': 0.84, 'depth_passenger_cnt': 0, 'cpm': 66.0, 'visit_page_cnt': 9, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 16.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 31.48, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 477, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 7.87, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-07', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220507', 'ctr': 0.85, 'depth_passenger_cnt': 0, 'cpm': 122.8, 'visit_page_cnt': 1, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 5.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 1, 'cost': 14.49, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 118, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 14.49, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 1, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-07', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220507', 'ctr': 5.71, 'depth_passenger_cnt': 0, 'cpm': 126.61, 'visit_page_cnt': 235, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 5, 'direct_order_cnt': 1, 'indirect_cart_cnt': 27, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 30.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 12, 'visitor_cnt': 52, 'cost': 173.08, 'coupon_cnt': 3, 'total_order_sum': 128.0, 'total_cart_cnt': 39, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.74, 'new_customers_cnt': 5, 'impressions': 1367, 'indirect_order_sum': 115.2, 'direct_order_sum': 12.8, 'goods_attention_cnt': 1, 'total_order_cvs': 7.69, 'cpa': 28.85, 'cpc': 2.22, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 78, 'total_order_cnt': 6, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-07', 'mobile_type': '全部', 'campaign_type': 11, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 405140640, 'click_date': '20220507', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '秒杀计划', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 59, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-07', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220507', 'ctr': 8.24, 'depth_passenger_cnt': 6, 'cpm': 2127.29, 'visit_page_cnt': 46, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 23.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 18, 'cost': 542.46, 'coupon_cnt': 0, 'total_order_sum': 149.8, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.28, 'new_customers_cnt': 1, 'impressions': 255, 'indirect_order_sum': 0.0, 'direct_order_sum': 149.8, 'goods_attention_cnt': 0, 'total_order_cvs': 9.52, 'cpa': 271.23, 'cpc': 25.83, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 21, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-07', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220507', 'ctr': 1.85, 'depth_passenger_cnt': 5, 'cpm': 32.74, 'visit_page_cnt': 96, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 23.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 9, 'visitor_cnt': 36, 'cost': 85.13, 'coupon_cnt': 0, 'total_order_sum': 26.9, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.32, 'new_customers_cnt': 1, 'impressions': 2600, 'indirect_order_sum': 0.0, 'direct_order_sum': 26.9, 'goods_attention_cnt': 0, 'total_order_cvs': 2.08, 'cpa': 85.13, 'cpc': 1.77, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 48, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-07', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220507', 'ctr': 5.61, 'depth_passenger_cnt': 7, 'cpm': 733.71, 'visit_page_cnt': 120, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 5, 'direct_order_cnt': 0, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 20.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 28, 'cost': 484.25, 'coupon_cnt': 8, 'total_order_sum': 1572.0, 'total_cart_cnt': 15, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.25, 'new_customers_cnt': 5, 'impressions': 660, 'indirect_order_sum': 1572.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 13.51, 'cpa': 96.85, 'cpc': 13.09, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 37, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-07', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220507', 'ctr': 3.39, 'depth_passenger_cnt': 2, 'cpm': 64.02, 'visit_page_cnt': 96, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 22.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 29, 'cost': 68.05, 'coupon_cnt': 0, 'total_order_sum': 112.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.65, 'new_customers_cnt': 1, 'impressions': 1063, 'indirect_order_sum': 0.0, 'direct_order_sum': 112.0, 'goods_attention_cnt': 0, 'total_order_cvs': 5.56, 'cpa': 34.03, 'cpc': 1.89, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 36, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-06', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220506', 'ctr': 7.16, 'depth_passenger_cnt': 12, 'cpm': 1029.68, 'visit_page_cnt': 213, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 6, 'direct_order_cnt': 4, 'indirect_cart_cnt': 19, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 35.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 9, 'visitor_cnt': 26, 'cost': 489.1, 'coupon_cnt': 3, 'total_order_sum': 630.38, 'total_cart_cnt': 28, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.29, 'new_customers_cnt': 6, 'impressions': 475, 'indirect_order_sum': 320.78, 'direct_order_sum': 309.6, 'goods_attention_cnt': 0, 'total_order_cvs': 29.41, 'cpa': 48.91, 'cpc': 14.39, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 34, 'total_order_cnt': 10, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-06', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220506', 'ctr': 1.9, 'depth_passenger_cnt': 5, 'cpm': 39.01, 'visit_page_cnt': 121, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 18.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 11, 'visitor_cnt': 49, 'cost': 160.31, 'coupon_cnt': 0, 'total_order_sum': 112.9, 'total_cart_cnt': 13, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.7, 'new_customers_cnt': 2, 'impressions': 4109, 'indirect_order_sum': 85.0, 'direct_order_sum': 27.9, 'goods_attention_cnt': 0, 'total_order_cvs': 2.56, 'cpa': 80.16, 'cpc': 2.06, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 78, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-06', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220506', 'ctr': 2.47, 'depth_passenger_cnt': 5, 'cpm': 117.21, 'visit_page_cnt': 54, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 34.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 13, 'cost': 80.64, 'coupon_cnt': 1, 'total_order_sum': 0.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 688, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.74, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 17, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-06', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220506', 'ctr': 1.52, 'depth_passenger_cnt': 4, 'cpm': 22.34, 'visit_page_cnt': 50, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 14.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 20, 'cost': 32.26, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 1444, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.47, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 22, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-06', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220506', 'ctr': 1.41, 'depth_passenger_cnt': 0, 'cpm': 162.06, 'visit_page_cnt': 2, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 53.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 2, 'cost': 57.53, 'coupon_cnt': 0, 'total_order_sum': 318.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 5.53, 'new_customers_cnt': 1, 'impressions': 355, 'indirect_order_sum': 0.0, 'direct_order_sum': 318.0, 'goods_attention_cnt': 0, 'total_order_cvs': 20.0, 'cpa': 57.53, 'cpc': 11.51, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 5, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-06', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220506', 'ctr': 5.56, 'depth_passenger_cnt': 2, 'cpm': 1274.47, 'visit_page_cnt': 49, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 26.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 17, 'cost': 550.57, 'coupon_cnt': 0, 'total_order_sum': 147.9, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.27, 'new_customers_cnt': 2, 'impressions': 432, 'indirect_order_sum': 74.9, 'direct_order_sum': 73.0, 'goods_attention_cnt': 0, 'total_order_cvs': 8.33, 'cpa': 275.29, 'cpc': 22.94, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 24, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-06', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220506', 'ctr': 0.9, 'depth_passenger_cnt': 0, 'cpm': 65.54, 'visit_page_cnt': 23, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 21.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 4, 'cost': 36.44, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 556, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 7.29, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 5, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-06', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220506', 'ctr': 4.2, 'depth_passenger_cnt': 0, 'cpm': 367.82, 'visit_page_cnt': 14, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 15.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 3, 'cost': 43.77, 'coupon_cnt': 0, 'total_order_sum': 46.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.05, 'new_customers_cnt': 1, 'impressions': 119, 'indirect_order_sum': 0.0, 'direct_order_sum': 46.0, 'goods_attention_cnt': 0, 'total_order_cvs': 20.0, 'cpa': 43.77, 'cpc': 8.75, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 5, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-06', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220506', 'ctr': 3.11, 'depth_passenger_cnt': 0, 'cpm': 37.52, 'visit_page_cnt': 8, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 48.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 3, 'cost': 6.04, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 161, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 1.21, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 5, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-06', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220506', 'ctr': 7.26, 'depth_passenger_cnt': 0, 'cpm': 154.32, 'visit_page_cnt': 210, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 6, 'indirect_cart_cnt': 8, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 24.7, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 13, 'visitor_cnt': 54, 'cost': 199.69, 'coupon_cnt': 0, 'total_order_sum': 130.4, 'total_cart_cnt': 21, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.65, 'new_customers_cnt': 7, 'impressions': 1294, 'indirect_order_sum': 53.6, 'direct_order_sum': 76.8, 'goods_attention_cnt': 0, 'total_order_cvs': 8.51, 'cpa': 24.96, 'cpc': 2.12, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 94, 'total_order_cnt': 8, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-06', 'mobile_type': '全部', 'campaign_type': 11, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 405140640, 'click_date': '20220506', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '秒杀计划', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 104, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-05', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220505', 'ctr': 7.19, 'depth_passenger_cnt': 0, 'cpm': 161.28, 'visit_page_cnt': 147, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 7, 'direct_order_cnt': 5, 'indirect_cart_cnt': 12, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 35.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 22, 'visitor_cnt': 53, 'cost': 188.38, 'coupon_cnt': 3, 'total_order_sum': 299.9, 'total_cart_cnt': 34, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.59, 'new_customers_cnt': 11, 'impressions': 1168, 'indirect_order_sum': 223.1, 'direct_order_sum': 76.8, 'goods_attention_cnt': 0, 'total_order_cvs': 14.29, 'cpa': 15.7, 'cpc': 2.24, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 84, 'total_order_cnt': 12, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-05', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220505', 'ctr': 1.03, 'depth_passenger_cnt': 0, 'cpm': 81.37, 'visit_page_cnt': 9, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 72.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 6, 'cost': 47.6, 'coupon_cnt': 1, 'total_order_sum': 69.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.45, 'new_customers_cnt': 1, 'impressions': 585, 'indirect_order_sum': 0.0, 'direct_order_sum': 69.0, 'goods_attention_cnt': 0, 'total_order_cvs': 16.67, 'cpa': 47.6, 'cpc': 7.93, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-05', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220505', 'ctr': 5.61, 'depth_passenger_cnt': 0, 'cpm': 456.07, 'visit_page_cnt': 31, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 18.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 5, 'cost': 48.8, 'coupon_cnt': 1, 'total_order_sum': 99.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.03, 'new_customers_cnt': 1, 'impressions': 107, 'indirect_order_sum': 99.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 1, 'total_order_cvs': 16.67, 'cpa': 48.8, 'cpc': 8.13, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-05', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220505', 'ctr': 1.25, 'depth_passenger_cnt': 0, 'cpm': 64.69, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 10.35, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 160, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 5.18, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-05', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220505', 'ctr': 2.14, 'depth_passenger_cnt': 1, 'cpm': 121.07, 'visit_page_cnt': 17, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 15.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 9, 'cost': 50.85, 'coupon_cnt': 0, 'total_order_sum': 159.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.13, 'new_customers_cnt': 0, 'impressions': 420, 'indirect_order_sum': 0.0, 'direct_order_sum': 159.0, 'goods_attention_cnt': 0, 'total_order_cvs': 11.11, 'cpa': 50.85, 'cpc': 5.65, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 9, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-05', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220505', 'ctr': 6.58, 'depth_passenger_cnt': 0, 'cpm': 856.3, 'visit_page_cnt': 36, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 36.1, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 12, 'cost': 273.16, 'coupon_cnt': 1, 'total_order_sum': 99.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.36, 'new_customers_cnt': 1, 'impressions': 319, 'indirect_order_sum': 99.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 4.76, 'cpa': 273.16, 'cpc': 13.01, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 21, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-05', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220505', 'ctr': 2.17, 'depth_passenger_cnt': 3, 'cpm': 54.28, 'visit_page_cnt': 97, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 14.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 26, 'cost': 87.66, 'coupon_cnt': 0, 'total_order_sum': 59.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.67, 'new_customers_cnt': 1, 'impressions': 1615, 'indirect_order_sum': 0.0, 'direct_order_sum': 59.0, 'goods_attention_cnt': 1, 'total_order_cvs': 2.86, 'cpa': 87.66, 'cpc': 2.5, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 35, 'total_order_cnt': 1, 'shop_attention_cnt': 1}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-05', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220505', 'ctr': 4.91, 'depth_passenger_cnt': 6, 'cpm': 591.06, 'visit_page_cnt': 64, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 3, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 36.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 11, 'visitor_cnt': 26, 'cost': 517.18, 'coupon_cnt': 0, 'total_order_sum': 793.0, 'total_cart_cnt': 14, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.53, 'new_customers_cnt': 4, 'impressions': 875, 'indirect_order_sum': 316.0, 'direct_order_sum': 477.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.3, 'cpa': 129.3, 'cpc': 12.03, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 43, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-05', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220505', 'ctr': 1.63, 'depth_passenger_cnt': 2, 'cpm': 27.14, 'visit_page_cnt': 59, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 15.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 8, 'visitor_cnt': 32, 'cost': 101.71, 'coupon_cnt': 0, 'total_order_sum': 82.7, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.81, 'new_customers_cnt': 2, 'impressions': 3747, 'indirect_order_sum': 0.0, 'direct_order_sum': 82.7, 'goods_attention_cnt': 1, 'total_order_cvs': 3.28, 'cpa': 50.86, 'cpc': 1.67, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 61, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-05', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220505', 'ctr': 2.54, 'depth_passenger_cnt': 0, 'cpm': 304.25, 'visit_page_cnt': 16, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 20.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 8, 'cost': 131.74, 'coupon_cnt': 1, 'total_order_sum': 0.0, 'total_cart_cnt': 5, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 433, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 11.98, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 11, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-04', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220504', 'ctr': 2.64, 'depth_passenger_cnt': 6, 'cpm': 60.56, 'visit_page_cnt': 109, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 4, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 18.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 12, 'visitor_cnt': 31, 'cost': 101.08, 'coupon_cnt': 0, 'total_order_sum': 233.0, 'total_cart_cnt': 15, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.31, 'new_customers_cnt': 4, 'impressions': 1669, 'indirect_order_sum': 0.0, 'direct_order_sum': 233.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.09, 'cpa': 25.27, 'cpc': 2.3, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 44, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-04', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220504', 'ctr': 4.93, 'depth_passenger_cnt': 11, 'cpm': 594.05, 'visit_page_cnt': 87, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 1, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 32.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 23, 'cost': 397.42, 'coupon_cnt': 0, 'total_order_sum': 1279.0, 'total_cart_cnt': 10, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.22, 'new_customers_cnt': 4, 'impressions': 669, 'indirect_order_sum': 723.0, 'direct_order_sum': 556.0, 'goods_attention_cnt': 0, 'total_order_cvs': 12.12, 'cpa': 99.36, 'cpc': 12.04, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 33, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-04', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220504', 'ctr': 1.86, 'depth_passenger_cnt': 11, 'cpm': 28.65, 'visit_page_cnt': 199, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 7, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 16.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 16, 'visitor_cnt': 71, 'cost': 158.34, 'coupon_cnt': 0, 'total_order_sum': 138.2, 'total_cart_cnt': 23, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.87, 'new_customers_cnt': 2, 'impressions': 5526, 'indirect_order_sum': 85.0, 'direct_order_sum': 53.2, 'goods_attention_cnt': 0, 'total_order_cvs': 1.94, 'cpa': 79.17, 'cpc': 1.54, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 103, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-04', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220504', 'ctr': 1.64, 'depth_passenger_cnt': 0, 'cpm': 79.84, 'visit_page_cnt': 6, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 21.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 29.22, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 366, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.87, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-04', 'mobile_type': '全部', 'campaign_type': 11, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 405140640, 'click_date': '20220504', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '秒杀计划', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 68, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-04', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220504', 'ctr': 5.63, 'depth_passenger_cnt': 0, 'cpm': 105.0, 'visit_page_cnt': 297, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 9, 'direct_order_cnt': 5, 'indirect_cart_cnt': 28, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 37.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 15, 'visitor_cnt': 66, 'cost': 171.46, 'coupon_cnt': 8, 'total_order_sum': 1052.2, 'total_cart_cnt': 43, 'presale_indirect_order_cnt': 0, 'total_order_roi': 6.14, 'new_customers_cnt': 10, 'impressions': 1633, 'indirect_order_sum': 977.8, 'direct_order_sum': 74.4, 'goods_attention_cnt': 0, 'total_order_cvs': 15.22, 'cpa': 12.25, 'cpc': 1.86, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 92, 'total_order_cnt': 14, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-04', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220504', 'ctr': 8.4, 'depth_passenger_cnt': 0, 'cpm': 583.28, 'visit_page_cnt': 121, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 26.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 11, 'cost': 76.41, 'coupon_cnt': 0, 'total_order_sum': 14.9, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.2, 'new_customers_cnt': 1, 'impressions': 131, 'indirect_order_sum': 14.9, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.09, 'cpa': 76.41, 'cpc': 6.95, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 11, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-04', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220504', 'ctr': 2.62, 'depth_passenger_cnt': 0, 'cpm': 189.25, 'visit_page_cnt': 35, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 2, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 21.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 11, 'cost': 93.87, 'coupon_cnt': 1, 'total_order_sum': 311.9, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.32, 'new_customers_cnt': 3, 'impressions': 496, 'indirect_order_sum': 173.9, 'direct_order_sum': 138.0, 'goods_attention_cnt': 0, 'total_order_cvs': 30.77, 'cpa': 23.47, 'cpc': 7.22, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 13, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-04', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220504', 'ctr': 3.51, 'depth_passenger_cnt': 0, 'cpm': 300.0, 'visit_page_cnt': 11, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 0, 'indirect_cart_cnt': 6, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 31.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 51.3, 'coupon_cnt': 2, 'total_order_sum': 158.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 3.08, 'new_customers_cnt': 1, 'impressions': 171, 'indirect_order_sum': 158.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 33.33, 'cpa': 25.65, 'cpc': 8.55, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-04', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220504', 'ctr': 1.79, 'depth_passenger_cnt': 0, 'cpm': 40.03, 'visit_page_cnt': 4, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 10.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 3, 'cost': 13.45, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 336, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 2.24, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-04', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220504', 'ctr': 5.39, 'depth_passenger_cnt': 2, 'cpm': 1058.52, 'visit_page_cnt': 145, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 6, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 24.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 11, 'visitor_cnt': 29, 'cost': 628.76, 'coupon_cnt': 6, 'total_order_sum': 1163.0, 'total_cart_cnt': 15, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.85, 'new_customers_cnt': 7, 'impressions': 594, 'indirect_order_sum': 569.0, 'direct_order_sum': 594.0, 'goods_attention_cnt': 0, 'total_order_cvs': 28.13, 'cpa': 69.86, 'cpc': 19.65, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 32, 'total_order_cnt': 9, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-03', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220503', 'ctr': 1.63, 'depth_passenger_cnt': 4, 'cpm': 34.76, 'visit_page_cnt': 144, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 0, 'indirect_cart_cnt': 11, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 25.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 9, 'visitor_cnt': 69, 'cost': 232.48, 'coupon_cnt': 0, 'total_order_sum': 254.0, 'total_cart_cnt': 20, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.09, 'new_customers_cnt': 2, 'impressions': 6689, 'indirect_order_sum': 254.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 1.83, 'cpa': 116.24, 'cpc': 2.13, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 109, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-03', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220503', 'ctr': 2.05, 'depth_passenger_cnt': 0, 'cpm': 64.62, 'visit_page_cnt': 8, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 34.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 12.6, 'coupon_cnt': 1, 'total_order_sum': 295.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 23.41, 'new_customers_cnt': 0, 'impressions': 195, 'indirect_order_sum': 295.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 25.0, 'cpa': 12.6, 'cpc': 3.15, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 4, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-03', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220503', 'ctr': 6.96, 'depth_passenger_cnt': 6, 'cpm': 1109.94, 'visit_page_cnt': 162, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 1, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 31.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 9, 'visitor_cnt': 38, 'cost': 972.31, 'coupon_cnt': 0, 'total_order_sum': 477.0, 'total_cart_cnt': 13, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.49, 'new_customers_cnt': 2, 'impressions': 876, 'indirect_order_sum': 169.0, 'direct_order_sum': 308.0, 'goods_attention_cnt': 0, 'total_order_cvs': 3.28, 'cpa': 486.16, 'cpc': 15.94, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 61, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-03', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220503', 'ctr': 1.77, 'depth_passenger_cnt': 4, 'cpm': 48.19, 'visit_page_cnt': 127, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 11.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 19, 'visitor_cnt': 47, 'cost': 182.73, 'coupon_cnt': 0, 'total_order_sum': 115.0, 'total_cart_cnt': 19, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.63, 'new_customers_cnt': 2, 'impressions': 3792, 'indirect_order_sum': 0.0, 'direct_order_sum': 115.0, 'goods_attention_cnt': 0, 'total_order_cvs': 2.99, 'cpa': 91.37, 'cpc': 2.73, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 67, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-03', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220503', 'ctr': 6.78, 'depth_passenger_cnt': 5, 'cpm': 1162.16, 'visit_page_cnt': 217, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 6, 'direct_order_cnt': 7, 'indirect_cart_cnt': 12, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 25.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 13, 'visitor_cnt': 40, 'cost': 840.24, 'coupon_cnt': 15, 'total_order_sum': 888.6, 'total_cart_cnt': 25, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.06, 'new_customers_cnt': 8, 'impressions': 723, 'indirect_order_sum': 294.6, 'direct_order_sum': 594.0, 'goods_attention_cnt': 0, 'total_order_cvs': 26.53, 'cpa': 64.63, 'cpc': 17.15, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 49, 'total_order_cnt': 13, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-03', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220503', 'ctr': 2.78, 'depth_passenger_cnt': 0, 'cpm': 137.82, 'visit_page_cnt': 8, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 37.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 5, 'cost': 34.73, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 252, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.96, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-03', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220503', 'ctr': 4.58, 'depth_passenger_cnt': 0, 'cpm': 200.54, 'visit_page_cnt': 15, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 2, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 30.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 6, 'cost': 48.13, 'coupon_cnt': 0, 'total_order_sum': 49.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.02, 'new_customers_cnt': 1, 'impressions': 240, 'indirect_order_sum': 49.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.09, 'cpa': 48.13, 'cpc': 4.38, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 11, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-03', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220503', 'ctr': 3.03, 'depth_passenger_cnt': 0, 'cpm': 387.16, 'visit_page_cnt': 17, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 39.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 6, 'cost': 102.21, 'coupon_cnt': 1, 'total_order_sum': 99.0, 'total_cart_cnt': 3, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.97, 'new_customers_cnt': 1, 'impressions': 264, 'indirect_order_sum': 99.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 12.5, 'cpa': 102.21, 'cpc': 12.78, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-03', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220503', 'ctr': 1.17, 'depth_passenger_cnt': 0, 'cpm': 83.75, 'visit_page_cnt': 46, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 1, 'indirect_cart_cnt': 5, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 24.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 3, 'visitor_cnt': 7, 'cost': 50.0, 'coupon_cnt': 1, 'total_order_sum': 486.0, 'total_cart_cnt': 8, 'presale_indirect_order_cnt': 0, 'total_order_roi': 9.72, 'new_customers_cnt': 2, 'impressions': 597, 'indirect_order_sum': 417.0, 'direct_order_sum': 69.0, 'goods_attention_cnt': 0, 'total_order_cvs': 57.14, 'cpa': 12.5, 'cpc': 7.14, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 7, 'total_order_cnt': 4, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-03', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220503', 'ctr': 5.41, 'depth_passenger_cnt': 0, 'cpm': 71.84, 'visit_page_cnt': 123, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 0, 'indirect_cart_cnt': 11, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 18.9, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 7, 'visitor_cnt': 36, 'cost': 78.31, 'coupon_cnt': 1, 'total_order_sum': 29.7, 'total_cart_cnt': 18, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.38, 'new_customers_cnt': 2, 'impressions': 1090, 'indirect_order_sum': 29.7, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 3.39, 'cpa': 39.16, 'cpc': 1.33, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 59, 'total_order_cnt': 2, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-03', 'mobile_type': '全部', 'campaign_type': 11, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 405140640, 'click_date': '20220503', 'ctr': 0.0, 'depth_passenger_cnt': 0, 'cpm': 0.0, 'visit_page_cnt': 0, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '秒杀计划', 'visit_time_average': 0.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 0, 'cost': 0.0, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 17, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 0.0, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 0, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-02', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220502', 'ctr': 8.33, 'depth_passenger_cnt': 16, 'cpm': 2690.93, 'visit_page_cnt': 192, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 4, 'direct_order_cnt': 2, 'indirect_cart_cnt': 19, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 23.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 20, 'cost': 1065.61, 'coupon_cnt': 2, 'total_order_sum': 535.7, 'total_cart_cnt': 25, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.5, 'new_customers_cnt': 3, 'impressions': 396, 'indirect_order_sum': 379.7, 'direct_order_sum': 156.0, 'goods_attention_cnt': 0, 'total_order_cvs': 18.18, 'cpa': 177.6, 'cpc': 32.29, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 33, 'total_order_cnt': 6, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-02', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220502', 'ctr': 0.39, 'depth_passenger_cnt': 0, 'cpm': 17.87, 'visit_page_cnt': 3, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 17.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 1, 'cost': 4.61, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 2, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 258, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.61, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 1, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-02', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220502', 'ctr': 2.89, 'depth_passenger_cnt': 0, 'cpm': 136.65, 'visit_page_cnt': 4, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 39.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 23.64, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 173, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 4.73, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 5, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-02', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220502', 'ctr': 2.86, 'depth_passenger_cnt': 0, 'cpm': 213.7, 'visit_page_cnt': 39, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 1, 'direct_order_cnt': 0, 'indirect_cart_cnt': 3, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 41.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 12, 'cost': 104.5, 'coupon_cnt': 0, 'total_order_sum': 222.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.12, 'new_customers_cnt': 0, 'impressions': 489, 'indirect_order_sum': 222.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 7.14, 'cpa': 104.5, 'cpc': 7.46, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 14, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-02', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220502', 'ctr': 8.77, 'depth_passenger_cnt': 0, 'cpm': 924.32, 'visit_page_cnt': 114, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 9, 'direct_order_cnt': 1, 'indirect_cart_cnt': 16, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 18.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 2, 'visitor_cnt': 17, 'cost': 263.43, 'coupon_cnt': 3, 'total_order_sum': 407.3, 'total_cart_cnt': 18, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.55, 'new_customers_cnt': 3, 'impressions': 285, 'indirect_order_sum': 361.3, 'direct_order_sum': 46.0, 'goods_attention_cnt': 0, 'total_order_cvs': 40.0, 'cpa': 26.34, 'cpc': 10.54, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 25, 'total_order_cnt': 10, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-02', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220502', 'ctr': 6.05, 'depth_passenger_cnt': 0, 'cpm': 69.18, 'visit_page_cnt': 118, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 3, 'direct_order_cnt': 2, 'indirect_cart_cnt': 20, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 23.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 11, 'visitor_cnt': 38, 'cost': 65.17, 'coupon_cnt': 1, 'total_order_sum': 147.9, 'total_cart_cnt': 31, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.27, 'new_customers_cnt': 5, 'impressions': 942, 'indirect_order_sum': 110.7, 'direct_order_sum': 37.2, 'goods_attention_cnt': 0, 'total_order_cvs': 8.77, 'cpa': 13.03, 'cpc': 1.14, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 57, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-02', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220502', 'ctr': 1.9, 'depth_passenger_cnt': 5, 'cpm': 49.24, 'visit_page_cnt': 146, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 3, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 20.4, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 13, 'visitor_cnt': 71, 'cost': 282.48, 'coupon_cnt': 0, 'total_order_sum': 111.6, 'total_cart_cnt': 14, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.4, 'new_customers_cnt': 2, 'impressions': 5737, 'indirect_order_sum': 0.0, 'direct_order_sum': 111.6, 'goods_attention_cnt': 0, 'total_order_cvs': 2.75, 'cpa': 94.16, 'cpc': 2.59, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 109, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-02', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220502', 'ctr': 1.33, 'depth_passenger_cnt': 0, 'cpm': 79.25, 'visit_page_cnt': 4, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 10.8, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 17.91, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 226, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 5.97, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 3, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-02', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220502', 'ctr': 7.31, 'depth_passenger_cnt': 4, 'cpm': 1472.62, 'visit_page_cnt': 190, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 4, 'direct_order_cnt': 3, 'indirect_cart_cnt': 14, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 31.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 17, 'visitor_cnt': 45, 'cost': 1490.29, 'coupon_cnt': 1, 'total_order_sum': 2180.0, 'total_cart_cnt': 31, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.46, 'new_customers_cnt': 7, 'impressions': 1012, 'indirect_order_sum': 1405.0, 'direct_order_sum': 775.0, 'goods_attention_cnt': 0, 'total_order_cvs': 9.46, 'cpa': 212.9, 'cpc': 20.14, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 74, 'total_order_cnt': 7, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-02', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220502', 'ctr': 1.77, 'depth_passenger_cnt': 0, 'cpm': 55.56, 'visit_page_cnt': 125, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 3, 'indirect_cart_cnt': 1, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 16.5, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 18, 'visitor_cnt': 47, 'cost': 210.18, 'coupon_cnt': 0, 'total_order_sum': 168.0, 'total_cart_cnt': 19, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.8, 'new_customers_cnt': 3, 'impressions': 3783, 'indirect_order_sum': 0.0, 'direct_order_sum': 168.0, 'goods_attention_cnt': 0, 'total_order_cvs': 4.48, 'cpa': 70.06, 'cpc': 3.14, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 67, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-01', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662635543, 'click_date': '20220501', 'ctr': 1.74, 'depth_passenger_cnt': 0, 'cpm': 60.44, 'visit_page_cnt': 56, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 1, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪白瓶', 'visit_time_average': 11.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 4, 'visitor_cnt': 27, 'cost': 142.16, 'coupon_cnt': 0, 'total_order_sum': 118.0, 'total_cart_cnt': 4, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.83, 'new_customers_cnt': 1, 'impressions': 2352, 'indirect_order_sum': 0.0, 'direct_order_sum': 118.0, 'goods_attention_cnt': 0, 'total_order_cvs': 2.44, 'cpa': 142.16, 'cpc': 3.47, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 41, 'total_order_cnt': 1, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-01', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 617625984, 'click_date': '20220501', 'ctr': 7.51, 'depth_passenger_cnt': 1, 'cpm': 1551.92, 'visit_page_cnt': 180, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 7, 'direct_order_cnt': 6, 'indirect_cart_cnt': 12, 'pin': 'zhienpop2020', 'campaign_name': '易善复96粒', 'visit_time_average': 26.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 25, 'visitor_cnt': 54, 'cost': 1798.67, 'coupon_cnt': 1, 'total_order_sum': 4736.0, 'total_cart_cnt': 37, 'presale_indirect_order_cnt': 0, 'total_order_roi': 2.63, 'new_customers_cnt': 11, 'impressions': 1159, 'indirect_order_sum': 3047.0, 'direct_order_sum': 1689.0, 'goods_attention_cnt': 0, 'total_order_cvs': 14.94, 'cpa': 138.36, 'cpc': 20.67, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 87, 'total_order_cnt': 13, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-01', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 524830613, 'click_date': '20220501', 'ctr': 2.8, 'depth_passenger_cnt': 1, 'cpm': 183.36, 'visit_page_cnt': 19, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '艾丽30粒60mg', 'visit_time_average': 19.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 1, 'visitor_cnt': 6, 'cost': 52.44, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 1, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 286, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 6.56, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 8, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-01', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662633976, 'click_date': '20220501', 'ctr': 2.1, 'depth_passenger_cnt': 1, 'cpm': 65.83, 'visit_page_cnt': 197, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 8, 'pin': 'zhienpop2020', 'campaign_name': '星鲨', 'visit_time_average': 20.6, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 12, 'visitor_cnt': 72, 'cost': 331.8, 'coupon_cnt': 1, 'total_order_sum': 294.1, 'total_cart_cnt': 20, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.89, 'new_customers_cnt': 2, 'impressions': 5040, 'indirect_order_sum': 238.3, 'direct_order_sum': 55.8, 'goods_attention_cnt': 0, 'total_order_cvs': 2.83, 'cpa': 110.6, 'cpc': 3.13, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 106, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-01', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 639931883, 'click_date': '20220501', 'ctr': 5.48, 'depth_passenger_cnt': 0, 'cpm': 81.39, 'visit_page_cnt': 98, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 4, 'direct_order_cnt': 1, 'indirect_cart_cnt': 4, 'pin': 'zhienpop2020', 'campaign_name': '健胃消食片', 'visit_time_average': 24.3, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 10, 'visitor_cnt': 47, 'cost': 120.22, 'coupon_cnt': 0, 'total_order_sum': 136.1, 'total_cart_cnt': 14, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.13, 'new_customers_cnt': 5, 'impressions': 1477, 'indirect_order_sum': 123.3, 'direct_order_sum': 12.8, 'goods_attention_cnt': 0, 'total_order_cvs': 6.17, 'cpa': 24.04, 'cpc': 1.48, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 81, 'total_order_cnt': 5, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-01', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 655775171, 'click_date': '20220501', 'ctr': 1.2, 'depth_passenger_cnt': 0, 'cpm': 101.69, 'visit_page_cnt': 2, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '谷宜甘', 'visit_time_average': 4.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 2, 'cost': 16.88, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 166, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 8.44, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 2, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-01', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 403906316, 'click_date': '20220501', 'ctr': 1.25, 'depth_passenger_cnt': 0, 'cpm': 97.73, 'visit_page_cnt': 6, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 0, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '雅塑白盒40粒', 'visit_time_average': 90.0, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 0, 'visitor_cnt': 4, 'cost': 39.09, 'coupon_cnt': 0, 'total_order_sum': 0.0, 'total_cart_cnt': 0, 'presale_indirect_order_cnt': 0, 'total_order_roi': 0.0, 'new_customers_cnt': 0, 'impressions': 400, 'indirect_order_sum': 0.0, 'direct_order_sum': 0.0, 'goods_attention_cnt': 0, 'total_order_cvs': 0.0, 'cpa': 0.0, 'cpc': 7.82, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 5, 'total_order_cnt': 0, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-01', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 626841273, 'click_date': '20220501', 'ctr': 5.84, 'depth_passenger_cnt': 2, 'cpm': 498.52, 'visit_page_cnt': 26, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 2, 'direct_order_cnt': 1, 'indirect_cart_cnt': 8, 'pin': 'zhienpop2020', 'campaign_name': '雅塑黑盒18粒', 'visit_time_average': 39.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 12, 'cost': 128.12, 'coupon_cnt': 0, 'total_order_sum': 197.9, 'total_cart_cnt': 14, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.54, 'new_customers_cnt': 2, 'impressions': 257, 'indirect_order_sum': 151.9, 'direct_order_sum': 46.0, 'goods_attention_cnt': 0, 'total_order_cvs': 20.0, 'cpa': 42.71, 'cpc': 8.54, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 15, 'total_order_cnt': 3, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-01', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 599474506, 'click_date': '20220501', 'ctr': 8.32, 'depth_passenger_cnt': 20, 'cpm': 2533.33, 'visit_page_cnt': 199, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 6, 'direct_order_cnt': 1, 'indirect_cart_cnt': 15, 'pin': 'zhienpop2020', 'campaign_name': '艾丽21粒120mg', 'visit_time_average': 18.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 5, 'visitor_cnt': 31, 'cost': 1279.33, 'coupon_cnt': 5, 'total_order_sum': 1370.88, 'total_cart_cnt': 20, 'presale_indirect_order_cnt': 0, 'total_order_roi': 1.07, 'new_customers_cnt': 6, 'impressions': 505, 'indirect_order_sum': 1297.88, 'direct_order_sum': 73.0, 'goods_attention_cnt': 0, 'total_order_cvs': 16.67, 'cpa': 182.76, 'cpc': 30.46, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 42, 'total_order_cnt': 7, 'shop_attention_cnt': 0}, {'shop_id': 10583535, 'shop': 'zhienpop2020', 'date': '2022-05-01', 'mobile_type': '全部', 'campaign_type': 2, 'campaign_put_type': 3, 'put_type': '商品', 'campaign_id': 662651814, 'click_date': '20220501', 'ctr': 2.06, 'depth_passenger_cnt': 2, 'cpm': 111.41, 'visit_page_cnt': 23, 'presale_indirect_order_sum': 0.0, 'presale_direct_order_cnt': 0, 'preorder_cnt': 0, 'indirect_order_cnt': 0, 'direct_order_cnt': 2, 'indirect_cart_cnt': 0, 'pin': 'zhienpop2020', 'campaign_name': '蔓迪黑瓶', 'visit_time_average': 13.2, 'total_presale_order_sum': 0.0, 'direct_cart_cnt': 6, 'visitor_cnt': 5, 'cost': 32.42, 'coupon_cnt': 0, 'total_order_sum': 310.0, 'total_cart_cnt': 6, 'presale_indirect_order_cnt': 0, 'total_order_roi': 9.56, 'new_customers_cnt': 2, 'impressions': 291, 'indirect_order_sum': 0.0, 'direct_order_sum': 310.0, 'goods_attention_cnt': 0, 'total_order_cvs': 33.33, 'cpa': 16.21, 'cpc': 5.4, 'total_presale_order_cnt': 0, 'presale_direct_order_sum': 0.0, 'clicks': 6, 'total_order_cnt': 2, 'shop_attention_cnt': 0}]
    d1, d2 = create_many_sql("jd_promotion_plan_repord", data)
    print(d1)
    print(d2)
