# Introduction #

This is a Python script that interacts with the AXIS door access control system to perform user management tasks such as getting all users, finding a user by username, id, or card number, and disabling a user.

# Axis Communications #

Axis Communications is company that does network video surveillance technology, offering a wide range of network cameras, video encoders, software, and other accessories for video surveillance applications. 

Axis Communications specializes in creating network-based surveillance solutions that can be easily integrated into existing IT infrastructure. Their products are designed to provide high-quality video surveillance, with features such as high-resolution video, remote monitoring and control, advanced analytics, and built-in intelligence.

Axis Communications' solutions are used in a variety of industries, including retail, transportation, education, healthcare, and more. Their products are known for their reliability, scalability, and ease of use, and they are widely used by businesses and organizations around the world to enhance security, increase efficiency, and improve operations.

Axis is a security platform that has a set of services for configuration and management of the access control systems.

# Installation #

    Pip install the package
        pip install Axis42
    
    Create a .env file in the root directory and set the following environment variables:
        - AXIS_USER: The username for the AXIS system
        - AXIS_PASSWORD: The password for the AXIS system
        - CAMPUS_ID: The ID of the campus for the Dropi system
        - AXIS_URL: The url where Axis is hosted, must be in this format http://[ip address]
        - LOG_FILE_PATH (Optional): The path to the log file that will be generated by the script, 
        - This variable is set by default in the script directory with the name axis.log
        - UID42: 42 app uid
        - SECRET42: 42 app secret
        - SCOPE42: 42 app scope
    If no env file is specified then the script will ask for input 
    There is a .env.example file in the root directory that explains how you should configure your environment


### Usage of class ###

To use the script, run it with the command python main.py in your terminal. This will execute the script and perform the tasks defined in the main function. The tasks are:

    Get all users
    Find a user by username, id, or card number
    Enable or Disable a user
    Create and Remove a user

## Step by step on how to use axis class ##

Create a Axis() object

```python
    
    axis: Axis = Axis()
    users: list[User] = axis.get_all_users() # Returns a list of User objects

    axis.create_user('Ricardo Martins', 'rimartin', '[42 student]', '123123123', 'Geral')

    # Find a user by username
    user = axis.get_user_by_login('rimartin')

    # Find a user by ID
    user = axis.get_user_by_id(12311)

    # Find a user by card number
    user = axis.get_user_by_card_number('123123123')

    # Disable a user
    axis.suspend_user(user, True)

    # Enable a user
    axis.enable_user('rimartin', True)

    # Remove a user
    axis.remove_user(user, True)
```

Axis class:
    Axis class is used to manage axis functionality, such as adding users, disabling users, and enabling users, and removing users.

The class has several properties:
    axis_api (Axis_api) -> Axis API object, which makes all the calls to the AXIS service available
    users (list[User]) -> list of users that are explained in the next step

Methods available on the class:

    get_user_by_xxx(xxx: str) -> User
        This functions will search for a user, it can used with login, fullname, id, card_number, user token, credential token and by tag 

    get_all_tags() -> list[str]
        This function will search for all the tags in the Axis platform and return them as a list (Ex. [42 Piscine], [42 Lisboa], [42 Student], etc...)

    create_user(fullname: str, login: str, tag: str, card_number: str, group_name: str = "Geral") -> User
        This function will create a user in the Axis platform, insert his card number and add this user to the access group. After that it will add the user to the Users list.

    delete_user(user: User | str, warning: bool = True) -> None
        This functin will deletes the user from axis
        The function can receive a User, a username from intra, or a card number.
        The warning is a boolean to ask if your certain about this action.

    suspend_user(user: User | str, warning: bool = True) -> None
        Checks if user is not enabled on axis, and if it is, it will suspend the user.
        The function can receive a User, a username from intra, or a card number.
        The warning is a boolean to ask if your certain about this action.

    enable_user(user: User | str, warning: bool = True) -> None
        Checks if user is enabled on axis, and if it is, it will activate the user.
        The function can receive a User, a username from intra, or a card number.
        The warning is a boolean to ask if your certain about this action.


User class:

    Overall, the User class is used to represent information about a user in the Axis system and provides convenient methods to retrieve and modify the user's properties.

The class has several properties:

    - login (str): login of the user
    - tag (str): tag of the user
    - fullname (str): fullname of the user
    - user_token (str): user token of the user, every user has a unique token
    - enabled (bool): True if user is enabled in Axis, False otherwise
    - credential_groups (list[str]): list of credential groups of the user
    - credential_token (str): credential token of the user, every credential has a unique token
    - card_number (str): card number of the user
    - axis_credential (dict): axis credential information of the user, when we make a request to Axis, they expect this format
    - axis_user (dict): axis user information, when we make a request to Axis, they expect this format
    - id (str): id of the user on 42 intra, which is not initalized, because it is time consuming and most times it's not necessary
    - status (UserStatusEnum): status of the user on 42 intra, which is not initalized, because it is time consuming and most times it's not necessary

The User class has an __init__ method that takes a dictionary as input. The keys in the dictionary correspond to the properties listed above. The method initializes all the properties using the values in the dictionary. The id and status properties are set to None initially.

### Project status ###

This code is functional, but may need additional documentation and testing.

### Glossario ###

    HTTP Digest Auth:
        It's a server side authentication mechanism, it will ask the user to autenticate by providing a username and password, 
        but the request will be sent over http, so if someone is watching the packages it's dangerous to send the credentials 
        in plain text withou some sort of encryption.
        To solve this Http Digest Auth will send a "challenge" which is a random string that the browser can't predict, so the
        browser combines it with the password and hashes the result. Then this value will be returned in the response. The server
        will do the same calculation with his copy of the password and compares the result with the response.



