"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pigeon = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const events = require("aws-cdk-lib/aws-events");
const targets = require("aws-cdk-lib/aws-events-targets");
const lambda = require("aws-cdk-lib/aws-lambda");
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const cloudwatchActions = require("aws-cdk-lib/aws-cloudwatch-actions");
const sns = require("aws-cdk-lib/aws-sns");
const snsSubscriptions = require("aws-cdk-lib/aws-sns-subscriptions");
class Pigeon extends constructs_1.Construct {
    /**
     *
     * @param {cdk.Construct} scope
     * @param {string} id
     * @param {cdk.StackProps=} props
     */
    constructor(scope, id, props) {
        super(scope, id);
        const { schedule, lambdaFunctionProps, lambdaTargetProps = {}, alertOnFailure = false, emailAddress, } = props;
        const lambdaFunction = new lambda.Function(this, `${id}-function`, {
            ...lambdaFunctionProps,
            // https://github.com/aws/aws-cdk/issues/19608
            ...lambdaTargetProps,
        });
        this.lambdaFunction = lambdaFunction;
        const rule = new events.Rule(this, `${id}-rule`, {
            schedule,
            targets: [
                new targets.LambdaFunction(this.lambdaFunction, lambdaTargetProps),
            ],
        });
        this.rule = rule;
        if (alertOnFailure) {
            const alarm = new cloudwatch.Alarm(this, `${id}-alarm`, {
                comparisonOperator: cloudwatch.ComparisonOperator.GREATER_THAN_THRESHOLD,
                threshold: 1,
                evaluationPeriods: 1,
                // Default: sum over 5 minutes
                metric: lambdaFunction.metricErrors(),
            });
            this.alarm = alarm;
            const topic = new sns.Topic(this, `${id}-topic`);
            this.topic = topic;
            alarm.addAlarmAction(new cloudwatchActions.SnsAction(topic));
            if (emailAddress) {
                topic.addSubscription(new snsSubscriptions.EmailSubscription(emailAddress, { json: true }));
            }
        }
    }
}
exports.Pigeon = Pigeon;
_a = JSII_RTTI_SYMBOL_1;
Pigeon[_a] = { fqn: "cdk-pigeon.Pigeon", version: "0.1.0" };
//# sourceMappingURL=data:application/json;base64,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