# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class PaymentResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "payment_id": "str",
        "batch_payment_id": "str",
        "date": "date",
        "amount": "float",
        "bank_amount": "float",
        "currency_rate": "float",
        "invoice": "InvoiceResponse",
        "credit_note": "CreditNoteResponse",
        "prepayment": "PrepaymentResponse",
        "overpayment": "OverpaymentResponse",
    }

    attribute_map = {
        "payment_id": "paymentId",
        "batch_payment_id": "batchPaymentId",
        "date": "date",
        "amount": "amount",
        "bank_amount": "bankAmount",
        "currency_rate": "currencyRate",
        "invoice": "invoice",
        "credit_note": "creditNote",
        "prepayment": "prepayment",
        "overpayment": "overpayment",
    }

    def __init__(
        self,
        payment_id=None,
        batch_payment_id=None,
        date=None,
        amount=None,
        bank_amount=None,
        currency_rate=None,
        invoice=None,
        credit_note=None,
        prepayment=None,
        overpayment=None,
    ):  # noqa: E501
        """PaymentResponse - a model defined in OpenAPI"""  # noqa: E501

        self._payment_id = None
        self._batch_payment_id = None
        self._date = None
        self._amount = None
        self._bank_amount = None
        self._currency_rate = None
        self._invoice = None
        self._credit_note = None
        self._prepayment = None
        self._overpayment = None
        self.discriminator = None

        if payment_id is not None:
            self.payment_id = payment_id
        if batch_payment_id is not None:
            self.batch_payment_id = batch_payment_id
        if date is not None:
            self.date = date
        if amount is not None:
            self.amount = amount
        if bank_amount is not None:
            self.bank_amount = bank_amount
        if currency_rate is not None:
            self.currency_rate = currency_rate
        if invoice is not None:
            self.invoice = invoice
        if credit_note is not None:
            self.credit_note = credit_note
        if prepayment is not None:
            self.prepayment = prepayment
        if overpayment is not None:
            self.overpayment = overpayment

    @property
    def payment_id(self):
        """Gets the payment_id of this PaymentResponse.  # noqa: E501

        Xero Identifier of payment  # noqa: E501

        :return: The payment_id of this PaymentResponse.  # noqa: E501
        :rtype: str
        """
        return self._payment_id

    @payment_id.setter
    def payment_id(self, payment_id):
        """Sets the payment_id of this PaymentResponse.

        Xero Identifier of payment  # noqa: E501

        :param payment_id: The payment_id of this PaymentResponse.  # noqa: E501
        :type: str
        """

        self._payment_id = payment_id

    @property
    def batch_payment_id(self):
        """Gets the batch_payment_id of this PaymentResponse.  # noqa: E501

        Xero Identifier of batch payment. Present if the payment was created as part of a batch.  # noqa: E501

        :return: The batch_payment_id of this PaymentResponse.  # noqa: E501
        :rtype: str
        """
        return self._batch_payment_id

    @batch_payment_id.setter
    def batch_payment_id(self, batch_payment_id):
        """Sets the batch_payment_id of this PaymentResponse.

        Xero Identifier of batch payment. Present if the payment was created as part of a batch.  # noqa: E501

        :param batch_payment_id: The batch_payment_id of this PaymentResponse.  # noqa: E501
        :type: str
        """

        self._batch_payment_id = batch_payment_id

    @property
    def date(self):
        """Gets the date of this PaymentResponse.  # noqa: E501

        Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06  # noqa: E501

        :return: The date of this PaymentResponse.  # noqa: E501
        :rtype: date
        """
        return self._date

    @date.setter
    def date(self, date):
        """Sets the date of this PaymentResponse.

        Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06  # noqa: E501

        :param date: The date of this PaymentResponse.  # noqa: E501
        :type: date
        """

        self._date = date

    @property
    def amount(self):
        """Gets the amount of this PaymentResponse.  # noqa: E501

        The amount of the payment  # noqa: E501

        :return: The amount of this PaymentResponse.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this PaymentResponse.

        The amount of the payment  # noqa: E501

        :param amount: The amount of this PaymentResponse.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def bank_amount(self):
        """Gets the bank_amount of this PaymentResponse.  # noqa: E501

        The bank amount of the payment  # noqa: E501

        :return: The bank_amount of this PaymentResponse.  # noqa: E501
        :rtype: float
        """
        return self._bank_amount

    @bank_amount.setter
    def bank_amount(self, bank_amount):
        """Sets the bank_amount of this PaymentResponse.

        The bank amount of the payment  # noqa: E501

        :param bank_amount: The bank_amount of this PaymentResponse.  # noqa: E501
        :type: float
        """

        self._bank_amount = bank_amount

    @property
    def currency_rate(self):
        """Gets the currency_rate of this PaymentResponse.  # noqa: E501

        Exchange rate when payment is received. Only used for non base currency invoices and credit notes e.g. 0.7500  # noqa: E501

        :return: The currency_rate of this PaymentResponse.  # noqa: E501
        :rtype: float
        """
        return self._currency_rate

    @currency_rate.setter
    def currency_rate(self, currency_rate):
        """Sets the currency_rate of this PaymentResponse.

        Exchange rate when payment is received. Only used for non base currency invoices and credit notes e.g. 0.7500  # noqa: E501

        :param currency_rate: The currency_rate of this PaymentResponse.  # noqa: E501
        :type: float
        """

        self._currency_rate = currency_rate

    @property
    def invoice(self):
        """Gets the invoice of this PaymentResponse.  # noqa: E501


        :return: The invoice of this PaymentResponse.  # noqa: E501
        :rtype: InvoiceResponse
        """
        return self._invoice

    @invoice.setter
    def invoice(self, invoice):
        """Sets the invoice of this PaymentResponse.


        :param invoice: The invoice of this PaymentResponse.  # noqa: E501
        :type: InvoiceResponse
        """

        self._invoice = invoice

    @property
    def credit_note(self):
        """Gets the credit_note of this PaymentResponse.  # noqa: E501


        :return: The credit_note of this PaymentResponse.  # noqa: E501
        :rtype: CreditNoteResponse
        """
        return self._credit_note

    @credit_note.setter
    def credit_note(self, credit_note):
        """Sets the credit_note of this PaymentResponse.


        :param credit_note: The credit_note of this PaymentResponse.  # noqa: E501
        :type: CreditNoteResponse
        """

        self._credit_note = credit_note

    @property
    def prepayment(self):
        """Gets the prepayment of this PaymentResponse.  # noqa: E501


        :return: The prepayment of this PaymentResponse.  # noqa: E501
        :rtype: PrepaymentResponse
        """
        return self._prepayment

    @prepayment.setter
    def prepayment(self, prepayment):
        """Sets the prepayment of this PaymentResponse.


        :param prepayment: The prepayment of this PaymentResponse.  # noqa: E501
        :type: PrepaymentResponse
        """

        self._prepayment = prepayment

    @property
    def overpayment(self):
        """Gets the overpayment of this PaymentResponse.  # noqa: E501


        :return: The overpayment of this PaymentResponse.  # noqa: E501
        :rtype: OverpaymentResponse
        """
        return self._overpayment

    @overpayment.setter
    def overpayment(self, overpayment):
        """Sets the overpayment of this PaymentResponse.


        :param overpayment: The overpayment of this PaymentResponse.  # noqa: E501
        :type: OverpaymentResponse
        """

        self._overpayment = overpayment
