
# Adding support for a new node in WalT

## Introduction

WalT is currently provided with support for several kinds of nodes:
* Raspberry Pi boards: models B, B+, 2B, 3B and 3B+
* Standard PC machines (x86 32bit or 64bit CPU)
* Virtual nodes

Check-out [`walt help show node-install`](node-install.md) for more info.

But WalT can also support any other kind of hardware, without having to update
its internal source code.
This page explains how this can be done.


## Steps

First, you should open an issue at https://github.com/drakkar-lig/walt-python-packages/issues
in order to let us assist you in this process.

On the technical side, support for a new kind of node in WalT requires:
* A network bootloader with appropriate configuration
* A default walt image that will be assigned to newly detected nodes of this kind


## Network bootloader

First, you may clone git repository https://github.com/drakkar-lig/walt-node-boot.
This repository currently allows to generate SD card content of walt raspberry pi nodes, and
USB device image of walt PC nodes. It can be a good starting point. Feel free to issue a
pull request if you want your work on this repository to be included.

Currently, Raspberry pi nodes use U-Boot network bootloader. And PC nodes use iPXE
network bootloader.

U-boot supports many single board computers, so you can probably use it for the new board.
However, check that u-Boot can handle the embedded network adapter, it may not be the case.
Support for newest boards may be limited at first, but usually improves over time.

In order to work properly, the bootloader should be configured to do the following on boot:
1. If handling several sub-models (such as the bootloader configuration we provide for
   raspberry pi boards), identify the sub-model of the board currently booting (e.g. `rpi-2-b`).
2. Perform a DHCP request. Important: the vendor class identifier (VCI) of the DHCP request must
   be set to `walt.node.<type>` (e.g. `walt.node.rpi-2-b`). This allows walt server to associate
   the default walt image appropriate for this type, on fist boot. Note that it is possible
   to set the UCI (User class identifier) to this value, instead of the VCI, if setting the
   VCI is not possible on this specific bootloader.
3. Download script file `start.uboot` using TFTP. On server side, this request will be
   redirected to file `[image]:/boot/<node-type>/start.uboot`.
4. Execute this script.

The script `rpi/builder_files/boot.scr.txt` in `walt-node-boot` repository is an example of
a u-boot script which follows these steps.


## Default walt image

In order to create a default walt image appropriate for this board, you should check out
[`walt help show image-from-scratch`](image-from-scratch.md).

As an example, the default image of raspberry pi boards is generated by the repository at:
https://github.com/drakkar-lig/walt-rpi-debian.
And the default image of PC nodes is generated by the repository at:
https://github.com/drakkar-lig/walt-pc-debian.

In order to let walt use your image as the default for this node type, you must import it
in walt own repository and rename it to `waltplatform/<node-type>-default:latest`.
For this, run the following as root on the server:
```
$ podman pull docker-daemon:<docker-image>:<tag>
$ podman tag docker.io/<docker-image>:<tag> docker.io/waltplatform/<node-type>-default:latest
```
Then you should let walt server daemon rescan its repository.
Flag `--refresh` of command `walt image show` will cause this rescan:
```
$ walt image show --refresh
```

You can now try to boot the new node for the first time.

After this initial try, you can of course use `walt node boot` to direct the new node to
another image within your account. This will make debugging easier than having to refresh
the default image again.

At the end of the debugging, in order to have your new default walt image pushed to the
docker hub, you should notify us about it (add a comment to the issue you initially reported),
and we will do it for you (since push authorization on `waltplatform` account is restricted).

