"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AthenaGetQueryResults = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const task_utils_1 = require("../private/task-utils");
/**
 * Get an Athena Query Results as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html
 * @stability stable
 */
class AthenaGetQueryResults extends sfn.TaskStateBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        this.integrationPattern = (_b = props.integrationPattern) !== null && _b !== void 0 ? _b : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, AthenaGetQueryResults.SUPPORTED_INTEGRATION_PATTERNS);
        const policyStatements = [
            new iam.PolicyStatement({
                resources: ['*'],
                actions: ['athena:getQueryResults'],
            }),
        ];
        policyStatements.push(new iam.PolicyStatement({
            actions: ['s3:GetObject'],
            resources: ['*'],
        }));
        this.taskPolicies = policyStatements;
    }
    /**
     * Provides the Athena get query results service integration task configuration
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('athena', 'getQueryResults', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                QueryExecutionId: this.props.queryExecutionId,
                NextToken: this.props.nextToken,
                MaxResults: this.props.maxResults,
            }),
        };
    }
}
exports.AthenaGetQueryResults = AthenaGetQueryResults;
_a = JSII_RTTI_SYMBOL_1;
AthenaGetQueryResults[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.AthenaGetQueryResults", version: "1.115.0" };
AthenaGetQueryResults.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
];
//# sourceMappingURL=data:application/json;base64,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