/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.AbstractElement;
import net.sourceforge.plantuml.salt.element.ElementMenuEntry;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class ElementMenuPopup
extends AbstractElement {
    private final Collection<ElementMenuEntry> entries = new ArrayList<ElementMenuEntry>();
    private final UFont font;
    private final ISkinSimple spriteContainer;

    public ElementMenuPopup(UFont font, ISkinSimple spriteContainer) {
        this.font = font;
        this.spriteContainer = spriteContainer;
    }

    public void addEntry(String s) {
        this.entries.add(new ElementMenuEntry(s, this.font, this.spriteContainer));
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        double w = 0.0;
        double h = 0.0;
        for (ElementMenuEntry entry : this.entries) {
            Dimension2D dim = entry.getPreferredDimension(stringBounder, x, y);
            w = Math.max(w, dim.getWidth());
            h += dim.getHeight();
        }
        return new Dimension2DDouble(w, h);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        if (zIndex != 1) {
            return;
        }
        ug.apply(HColorSet.instance().getColorOrWhite(this.getThemeStyle(), "#DDDDDD").bg()).draw(new URectangle(dimToUse.getWidth(), dimToUse.getHeight()));
        double y1 = 0.0;
        for (ElementMenuEntry entry : this.entries) {
            double h = entry.getPreferredDimension(ug.getStringBounder(), 0.0, y1).getHeight();
            if (entry.getText().equals("-")) {
                ug.apply(UTranslate.dy(y1 + h / 2.0)).draw(ULine.hline(dimToUse.getWidth()));
            } else {
                entry.drawU(ug.apply(UTranslate.dy(y1)), zIndex, dimToUse);
            }
            y1 += h;
        }
    }
}

