from com.inductiveautomation.ignition.modules.serial.scripting import SerialScriptModule
from java.lang import String
from typing import Any, List, Optional

PortManager = SerialScriptModule.PortManager
SerialConfigurator = SerialScriptModule.SerialConfigurator

def closeSerialPort(port: String) -> None: ...
def configureSerialPort(
    port: String,
    bitRate: Optional[int] = ...,
    dataBits: Optional[int] = ...,
    handshake: Optional[int] = ...,
    hardwareFlowControl: Optional[bool] = ...,
    parity: Optional[int] = ...,
    stopBits: Optional[int] = ...,
) -> SerialConfigurator: ...
def openSerialPort(port: String) -> None: ...
def port(
    port: String,
    bitRate: Optional[int] = ...,
    dataBits: Optional[int] = ...,
    handshake: Optional[int] = ...,
    hardwareFlowControl: Optional[bool] = ...,
    parity: Optional[int] = ...,
    stopBits: Optional[int] = ...,
) -> PortManager: ...
def readBytes(
    port: String, numberOfBytes: int, timeout: Optional[int] = ...
) -> List[Any]: ...
def readBytesAsString(
    port: String, numberOfBytes: int, timeout: int = ..., encoding: String = ...
) -> String: ...
def readLine(
    port: String, timeout: int = ..., encoding: String = ..., crlfRequired: bool = ...
) -> String: ...
def readUntil(
    port: String,
    delimiter: String,
    includeDelimiter: bool,
    timeout: Optional[int] = ...,
) -> String: ...
def sendBreak(port: String, millis: int) -> None: ...
def write(port: String, toWrite: String, encoding: Optional[String] = ...) -> None: ...
def writeBytes(port: String, toWrite: Any, timeout: Optional[int] = ...) -> None: ...
