from com.inductiveautomation.ignition.common import QualifiedPath
from com.inductiveautomation.ignition.common.user.schedule import ScheduleAdjustment
from java.lang import Object, String
from typing import Any, List, Optional

class ContactInfo(Object):
    contactType: String
    value: String
    def __init__(self, *args: Any) -> None: ...
    def getContactType(self) -> String: ...
    def getValue(self) -> String: ...
    def setContactType(self, contactType: String) -> None: ...
    def setValue(self, value: String) -> None: ...

class User:
    Badge: str
    DEFAULT_SCHEDULE_NAME: str
    FirstName: str
    Language: str
    LastName: str
    Notes: str
    Password: str
    Schedule: str
    Username: str
    USERNAME_PATTERN: str
    def getContactInfo(self) -> List[ContactInfo]: ...
    def getId(self) -> Any: ...
    def getPath(self) -> QualifiedPath: ...
    def getProfileName(self) -> String: ...
    def getRoles(self) -> List[String]: ...
    def getScheduleAdjustments(self) -> List[ScheduleAdjustment]: ...

class BasicUser(User):
    contactInfo: Optional[List[ContactInfo]]
    id: Any
    profileName: String
    roles: List[String]
    scheduleAdjustments: List[ScheduleAdjustment]
    def __init__(
        self,
        profileName: String,
        id_: Any,
        roles: List[String],
        contactInfo: Optional[List[ContactInfo]] = ...,
    ) -> None: ...
    def getContactInfo(self) -> List[ContactInfo]: ...
    def getId(self) -> Any: ...
    def getPath(self) -> QualifiedPath: ...
    def getProfileName(self) -> String: ...
    def getRoles(self) -> List[String]: ...
    def getScheduleAdjustments(self) -> List[ScheduleAdjustment]: ...

class PyUser(User):
    def __init__(self, user: Optional[User] = ...) -> None: ...
    def addContactInfo(self, *args) -> None: ...
    def addRole(self, role) -> None: ...
    def addRoles(self, roles) -> None: ...
    def addScheduleAdjustment(self, start, end, available, note) -> None: ...
    def addScheduleAdjustments(self, scheduleAdjustments) -> None: ...
    def contains(self, prop) -> None: ...
    def get(self, propertyName): ...
    def getContactInfo(self) -> List[ContactInfo]: ...
    def getCount(self): ...
    def getId(self) -> Any: ...
    def getOrDefault(self, prop) -> None: ...
    def getOrElse(self, property, value) -> None: ...
    def getPath(self) -> QualifiedPath: ...
    def getProfileName(self) -> String: ...
    def getProperties(self) -> None: ...
    def getRoles(self) -> List[String]: ...
    def getScheduleAdjustments(self) -> List[ScheduleAdjustment]: ...
    def getValues(self) -> None: ...
    def isExtended(self, prop) -> None: ...
    def isInherited(self, prop) -> None: ...
    def iterator(self) -> None: ...
    def merge(self, other, localOnly) -> None: ...
    def remove(self, prop) -> None: ...
    def removeContactInfo(self, contactType, value) -> None: ...
    def removeRole(self, role) -> None: ...
    def removeScheduleAdjustment(self, start, end, available, note) -> None: ...
    def set(self, *args) -> None: ...
    def setContactInfo(self, contactInfo) -> None: ...
    def setRoles(self, roles) -> None: ...
    def setScheduleAdjustments(self, scheduleAdjustments) -> None: ...

class UserSourceMeta(Object):
    description: String
    name: String
    type: String
    def __init__(self, name: String, description: String, type_: String) -> None: ...
    def getName(self) -> String: ...
    def getDescription(self) -> String: ...
    def getType(self) -> String: ...
