/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.text.StyledString;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;

public class DriverTextG2d
implements UDriver<Graphics2D> {
    private final EnsureVisible visible;

    public DriverTextG2d(EnsureVisible visible) {
        this.visible = visible;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        UText shape = (UText)ushape;
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        String text = shape.getText();
        List<StyledString> strings = StyledString.build(text);
        UFont font = fontConfiguration.getFont().scaled(param.getScale());
        for (StyledString styledString : strings) {
            FontConfiguration fc = styledString.getStyle() == FontStyle.BOLD ? fontConfiguration.bold() : fontConfiguration;
            Dimension2D dim = DriverTextG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(TikzFontDistortion.getDefault()), fc.getFont(), styledString.getText());
            this.printSingleText(g2d, fc, styledString.getText(), x, y, mapper, param);
            x += dim.getWidth();
        }
    }

    private void printSingleText(Graphics2D g2d, FontConfiguration fontConfiguration, String text, double x, double y, ColorMapper mapper, UParam param) {
        Dimension2D dim;
        UFont font = fontConfiguration.getFont().scaled(param.getScale());
        HColor extended = fontConfiguration.getExtendedColor();
        boolean orientation = false;
        Dimension2D dimBack = DriverTextG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(TikzFontDistortion.getDefault()), font, text);
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR)) {
            Rectangle2D.Double area = new Rectangle2D.Double(x, y - dimBack.getHeight() + 1.5, dimBack.getWidth(), dimBack.getHeight());
            if (extended instanceof HColorGradient) {
                GradientPaint paint = DriverRectangleG2d.getPaintGradient(x, y, mapper, dimBack.getWidth(), dimBack.getHeight(), extended);
                g2d.setPaint(paint);
                g2d.fill(area);
            } else {
                Color backColor = mapper.toColor(extended);
                if (backColor != null) {
                    g2d.setColor(backColor);
                    g2d.setBackground(backColor);
                    g2d.fill(area);
                }
            }
        }
        this.visible.ensureVisible(x, y - dimBack.getHeight() + 1.5);
        this.visible.ensureVisible(x + dimBack.getWidth(), y + 1.5);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setFont(font.getUnderlayingFont());
        g2d.setColor(mapper.toColor(fontConfiguration.getColor()));
        g2d.drawString(text, (float)x, (float)y);
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            if (extended != null) {
                g2d.setColor(mapper.toColor(extended));
            }
            dim = DriverTextG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(TikzFontDistortion.getDefault()), font, text);
            int ypos = (int)(y + 2.5);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine((int)x, ypos, (int)(x + dim.getWidth()), ypos);
            g2d.setStroke(new BasicStroke());
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            dim = DriverTextG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(TikzFontDistortion.getDefault()), font, text);
            int ypos = (int)(y + 2.5) - 1;
            if (extended != null) {
                g2d.setColor(mapper.toColor(extended));
            }
            int i = (int)x;
            while ((double)i < x + dim.getWidth() - 5.0) {
                g2d.drawLine(i, ypos - 0, i + 3, ypos + 1);
                g2d.drawLine(i + 3, ypos + 1, i + 6, ypos - 0);
                i += 6;
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            dim = DriverTextG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(TikzFontDistortion.getDefault()), font, text);
            FontMetrics fm = g2d.getFontMetrics(font.getUnderlayingFont());
            int ypos = (int)(y - (double)fm.getDescent() - 0.5);
            if (extended != null) {
                g2d.setColor(mapper.toColor(extended));
            }
            g2d.setStroke(new BasicStroke(1.5f));
            g2d.drawLine((int)x, ypos, (int)(x + dim.getWidth()), ypos);
            g2d.setStroke(new BasicStroke());
        }
    }

    public static Dimension2D calculateDimension(StringBounder stringBounder, UFont font, String text) {
        Dimension2D rect = stringBounder.calculateDimension(font, text);
        double h = rect.getHeight();
        if (h < 10.0) {
            h = 10.0;
        }
        return new Dimension2DDouble(rect.getWidth(), h);
    }
}

