/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class DriverTextAsPathG2d
implements UDriver<Graphics2D> {
    private final EnsureVisible visible;
    private final FontRenderContext fontRenderContext;

    public DriverTextAsPathG2d(EnsureVisible visible, FontRenderContext fontRenderContext) {
        this.visible = visible;
        this.fontRenderContext = fontRenderContext;
    }

    private static void printFont() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        int j = fontNames.length;
        for (int i = 0; i < j; ++i) {
            Log.info("Available fonts: " + fontNames[i]);
        }
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        Dimension2D dim;
        int ypos;
        Color extended;
        UText shape = (UText)ushape;
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        UFont font = fontConfiguration.getFont().scaled(param.getScale());
        Dimension2D dimBack = DriverTextAsPathG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(TikzFontDistortion.getDefault()), font, shape.getText());
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR) && (extended = mapper.toColor(fontConfiguration.getExtendedColor())) != null) {
            g2d.setColor(extended);
            g2d.setBackground(extended);
            g2d.fill(new Rectangle2D.Double(x, y - dimBack.getHeight() + 1.5, dimBack.getWidth(), dimBack.getHeight()));
        }
        this.visible.ensureVisible(x, y - dimBack.getHeight() + 1.5);
        this.visible.ensureVisible(x + dimBack.getWidth(), y + 1.5);
        g2d.setFont(font.getUnderlayingFont());
        g2d.setColor(mapper.toColor(fontConfiguration.getColor()));
        TextLayout t = new TextLayout(shape.getText(), font.getUnderlayingFont(), this.fontRenderContext);
        g2d.translate(x, y);
        g2d.fill(t.getOutline(null));
        g2d.translate(-x, -y);
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            HColor extended2 = fontConfiguration.getExtendedColor();
            if (extended2 != null) {
                g2d.setColor(mapper.toColor(extended2));
            }
            Dimension2D dim2 = DriverTextAsPathG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(TikzFontDistortion.getDefault()), font, shape.getText());
            ypos = (int)(y + 2.5);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine((int)x, ypos, (int)(x + dim2.getWidth()), ypos);
            g2d.setStroke(new BasicStroke());
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            dim = DriverTextAsPathG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(TikzFontDistortion.getDefault()), font, shape.getText());
            int ypos2 = (int)(y + 2.5) - 1;
            HColor extended3 = fontConfiguration.getExtendedColor();
            if (extended3 != null) {
                g2d.setColor(mapper.toColor(extended3));
            }
            int i = (int)x;
            while ((double)i < x + dim.getWidth() - 5.0) {
                g2d.drawLine(i, ypos2 - 0, i + 3, ypos2 + 1);
                g2d.drawLine(i + 3, ypos2 + 1, i + 6, ypos2 - 0);
                i += 6;
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            dim = DriverTextAsPathG2d.calculateDimension(FileFormat.PNG.getDefaultStringBounder(TikzFontDistortion.getDefault()), font, shape.getText());
            FontMetrics fm = g2d.getFontMetrics(font.getUnderlayingFont());
            ypos = (int)(y - (double)fm.getDescent() - 0.5);
            HColor extended4 = fontConfiguration.getExtendedColor();
            if (extended4 != null) {
                g2d.setColor(mapper.toColor(extended4));
            }
            g2d.setStroke(new BasicStroke(1.5f));
            g2d.drawLine((int)x, ypos, (int)(x + dim.getWidth()), ypos);
            g2d.setStroke(new BasicStroke());
        }
    }

    public static Dimension2D calculateDimension(StringBounder stringBounder, UFont font, String text) {
        Dimension2D rect = stringBounder.calculateDimension(font, text);
        double h = rect.getHeight();
        if (h < 10.0) {
            h = 10.0;
        }
        return new Dimension2DDouble(rect.getWidth(), h);
    }
}

