/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.debug;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import net.sourceforge.plantuml.ugraphic.debug.StringBounderDebug;

public class UGraphicDebug
extends AbstractCommonUGraphic
implements ClipContainer,
UGraphic2 {
    private final List<String> output;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicDebug(this, this.output);
    }

    private UGraphicDebug(UGraphicDebug other, List<String> output) {
        super(other);
        this.output = output;
    }

    public UGraphicDebug() {
        super(new ColorMapperIdentity());
        this.output = new ArrayList<String>();
    }

    @Override
    public StringBounder getStringBounder() {
        return new StringBounderDebug();
    }

    @Override
    public void draw(UShape shape) {
        if (shape instanceof ULine) {
            this.outLine((ULine)shape);
        } else if (shape instanceof URectangle) {
            this.outRectangle((URectangle)shape);
        } else if (shape instanceof UText) {
            this.outText((UText)shape);
        } else if (shape instanceof UPolygon) {
            this.outPolygon((UPolygon)shape);
        } else {
            throw new UnsupportedOperationException("UGraphicDebug " + shape.getClass().getSimpleName());
        }
    }

    private void outPolygon(UPolygon shape) {
        this.output.add("POLYGON:");
        this.output.add("  points:");
        for (Point2D point2D : shape.getPoints()) {
            double xp = this.getTranslateX() + point2D.getX();
            double yp = this.getTranslateY() + point2D.getY();
            this.output.add("   - " + this.pointd(xp, yp));
        }
        this.output.add("  stroke: " + this.getParam().getStroke());
        this.output.add("  shadow: " + (int)shape.getDeltaShadow());
        this.output.add("  color: " + this.colorToString(this.getParam().getColor()));
        this.output.add("  backcolor: " + this.colorToString(this.getParam().getBackcolor()));
        this.output.add("");
    }

    private void outText(UText shape) {
        this.output.add("TEXT:");
        this.output.add("  text: " + shape.getText());
        this.output.add("  position: " + this.pointd(this.getTranslateX(), this.getTranslateY()));
        this.output.add("  orientation: " + shape.getOrientation());
        this.output.add("  font: " + shape.getFontConfiguration().toStringDebug());
        this.output.add("  color: " + this.colorToString(this.getParam().getColor()));
        this.output.add("");
    }

    private void outRectangle(URectangle shape) {
        this.output.add("RECTANGLE:");
        this.output.add("  pt1: " + this.pointd(this.getTranslateX(), this.getTranslateY()));
        this.output.add("  pt2: " + this.pointd(this.getTranslateX() + shape.getWidth(), this.getTranslateY() + shape.getHeight()));
        this.output.add("  xCorner: " + (int)shape.getRx());
        this.output.add("  yCorner: " + (int)shape.getRy());
        this.output.add("  stroke: " + this.getParam().getStroke());
        this.output.add("  shadow: " + (int)shape.getDeltaShadow());
        this.output.add("  color: " + this.colorToString(this.getParam().getColor()));
        this.output.add("  backcolor: " + this.colorToString(this.getParam().getBackcolor()));
        this.output.add("");
    }

    private void outLine(ULine shape) {
        this.output.add("LINE:");
        this.output.add("  pt1: " + this.pointd(this.getTranslateX(), this.getTranslateY()));
        this.output.add("  pt2: " + this.pointd(this.getTranslateX() + shape.getDX(), this.getTranslateY() + shape.getDY()));
        this.output.add("  stroke: " + this.getParam().getStroke());
        this.output.add("  shadow: " + (int)shape.getDeltaShadow());
        this.output.add("  color: " + this.colorToString(this.getParam().getColor()));
        this.output.add("");
    }

    private String pointd(double x, double y) {
        return String.format(Locale.US, "[ %.4f ; %.4f ]", x, y);
    }

    private String colorToString(HColor color) {
        if (color instanceof HColorSimple) {
            HColorSimple simple = (HColorSimple)color;
            Color internal = simple.getColor999();
            if (simple.isMonochrome()) {
                return "monochrome " + Integer.toHexString(internal.getRGB());
            }
            return Integer.toHexString(internal.getRGB());
        }
        return color.getClass().getSimpleName();
    }

    @Override
    public void writeImageTOBEMOVED(OutputStream os, String metadata, int dpi) throws IOException {
        this.print(os, "DPI: " + dpi);
        this.print(os, "");
        for (String s : this.output) {
            this.print(os, s);
        }
        os.flush();
    }

    private void print(OutputStream os, String out) throws UnsupportedEncodingException, IOException {
        os.write(out.getBytes("UTF-8"));
        os.write("\n".getBytes("UTF-8"));
    }
}

