/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.Set;
import javax.swing.ImageIcon;
import net.sourceforge.plantuml.AnimatedGifEncoder;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.anim.AffineTransformation;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.api.ImageDataComplex;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.braille.UGraphicBraille;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.security.ImageIO;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.svg.LengthAdjust;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorBackground;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.ugraphic.debug.UGraphicDebug;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.hand.UGraphicHandwritten;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.tikz.UGraphicTikz;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;
import net.sourceforge.plantuml.ugraphic.visio.UGraphicVdx;

public class ImageBuilder {
    private final ImageParameter param;
    private final double top;
    private final double right;
    private final double bottom;
    private final double left;
    private UDrawable udrawable;
    private boolean randomPixel;

    public static ImageBuilder build(ImageParameter imageParameter) {
        return new ImageBuilder(imageParameter);
    }

    private ImageBuilder(ImageParameter imageParameter) {
        this.param = imageParameter;
        this.top = imageParameter.getMargins().getTop();
        this.right = imageParameter.getMargins().getRight();
        this.bottom = imageParameter.getMargins().getBottom();
        this.left = imageParameter.getMargins().getLeft();
    }

    public void setUDrawable(UDrawable udrawable) {
        this.udrawable = udrawable;
    }

    public ImageData writeImageTOBEMOVED(long seed, OutputStream os) throws IOException {
        return this.writeImageTOBEMOVED(this.param.getFileFormatOption(), seed, os);
    }

    public ImageData writeImageTOBEMOVED(FileFormatOption fileFormatOption, long seed, OutputStream os) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.MJPEG) {
            return this.writeImageMjpeg(os, fileFormatOption.getDefaultStringBounder(this.param.getSvgCharSizeHack()));
        }
        if (fileFormat == FileFormat.ANIMATED_GIF) {
            return this.writeImageAnimatedGif(os, fileFormatOption.getDefaultStringBounder(this.param.getSvgCharSizeHack()));
        }
        return this.writeImageInternal(fileFormatOption, seed, os, this.param.getAnimation());
    }

    private ImageData writeImageInternal(FileFormatOption fileFormatOption, long seed, OutputStream os, Animation animationArg) throws IOException {
        Set<Url> urls;
        Dimension2D dim = this.getFinalDimension(fileFormatOption.getDefaultStringBounder(this.param.getSvgCharSizeHack()));
        double dx = 0.0;
        double dy = 0.0;
        if (animationArg != null) {
            MinMax minmax = this.param.getAnimation().getMinMax(dim);
            animationArg.setDimension(dim);
            dim = minmax.getDimension();
            dx = -minmax.getMinX();
            dy = -minmax.getMinY();
        }
        UGraphic2 ug = this.createUGraphic(fileFormatOption, seed, dim, animationArg, dx, dy);
        UGraphic ug2 = ug;
        UStroke borderStroke = this.param.getBorderStroke();
        if (borderStroke != null) {
            HColor color = this.param.getBorderColor() == null ? HColorUtils.BLACK : this.param.getBorderColor();
            double width = dim.getWidth() - borderStroke.getThickness();
            double height = dim.getHeight() - borderStroke.getThickness();
            URectangle shape = new URectangle(width, height).rounded(this.param.getBorderCorner());
            ug2.apply(color).apply(borderStroke).draw(shape);
        }
        if (this.randomPixel) {
            this.drawRandomPoint(ug2);
        }
        ug2 = ug2.apply(new UTranslate(this.left, this.top));
        UGraphic ugDecored = this.handwritten(ug2);
        this.udrawable.drawU(ugDecored);
        ugDecored.flushUg();
        ug.writeImageTOBEMOVED(os, this.param.getMetadata(), 96);
        os.flush();
        if (ug instanceof UGraphicG2d && (urls = ((UGraphicG2d)ug).getAllUrlsEncountered()).size() > 0) {
            CMapData cmap = CMapData.cmapString(urls, this.param.getDpi());
            return new ImageDataComplex(dim, cmap, this.param.getWarningOrError());
        }
        return new ImageDataSimple(dim);
    }

    private void drawRandomPoint(UGraphic ug2) {
        Random rnd = new Random();
        int red = rnd.nextInt(40);
        int green = rnd.nextInt(40);
        int blue = rnd.nextInt(40);
        Color c = new Color(red, green, blue);
        HColorSimple color = new HColorSimple(c, false);
        ug2.apply(color).apply(color.bg()).draw(new URectangle(1.0, 1.0));
    }

    public Dimension2D getFinalDimension(StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dim = new Dimension2DDouble(limitFinder.getMaxX(), limitFinder.getMaxY());
        return new Dimension2DDouble(((Dimension2D)dim).getWidth() + 1.0 + this.left + this.right, ((Dimension2D)dim).getHeight() + 1.0 + this.top + this.bottom);
    }

    private UGraphic handwritten(UGraphic ug) {
        if (this.param.isUseHandwritten()) {
            return new UGraphicHandwritten(ug);
        }
        return ug;
    }

    private ImageData writeImageMjpeg(OutputStream os, StringBounder stringBounder) throws IOException {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dim = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.left + this.right, limitFinder.getMaxY() + 1.0 + this.top + this.bottom);
        SFile f = new SFile("c:/tmp.avi");
        int nbframe = 100;
        MJPEGGenerator m = new MJPEGGenerator(f, this.getAviImage(null).getWidth(null), this.getAviImage(null).getHeight(null), 12.0, 100);
        int i = 0;
        if (i < 100) {
            AffineTransform at = AffineTransform.getTranslateInstance(((Dimension2D)dim).getWidth() / 2.0, ((Dimension2D)dim).getHeight() / 2.0);
            at.rotate(1.5707963267948966 * (double)i / 100.0);
            at.translate(-((Dimension2D)dim).getWidth() / 2.0, -((Dimension2D)dim).getHeight() / 2.0);
            throw new UnsupportedOperationException();
        }
        m.finishAVI();
        FileUtils.copyToStream(f, os);
        return new ImageDataSimple(dim);
    }

    private ImageData writeImageAnimatedGif(OutputStream os, StringBounder stringBounder) throws IOException {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dim = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.left + this.right, limitFinder.getMaxY() + 1.0 + this.top + this.bottom);
        MinMax minmax = this.param.getAnimation().getMinMax(dim);
        AnimatedGifEncoder e = new AnimatedGifEncoder();
        e.setRepeat(0);
        e.start(os);
        e.setDelay(60);
        for (AffineTransformation at : this.param.getAnimation().getAll()) {
            ImageIcon ii = new ImageIcon(this.getAviImage(at));
            e.addFrame((BufferedImage)ii.getImage());
        }
        e.finish();
        return new ImageDataSimple(dim);
    }

    private Image getAviImage(AffineTransformation affineTransform) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeImageInternal(new FileFormatOption(FileFormat.PNG), 42L, baos, Animation.singleton(affineTransform));
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BufferedImage im = ImageIO.read(bais);
        bais.close();
        return im;
    }

    private UGraphic2 createUGraphic(FileFormatOption option, long seed, Dimension2D dim, Animation animationArg, double dx, double dy) {
        ColorMapper colorMapper = this.param.getColorMapper();
        double scaleFactor = (this.param.getScale() == null ? 1.0 : this.param.getScale().getScale(dim.getWidth(), dim.getHeight())) * (double)this.param.getDpi() / 96.0;
        FileFormat fileFormat = option.getFileFormat();
        switch (fileFormat) {
            case PNG: {
                return this.createUGraphicPNG(colorMapper, scaleFactor, dim, this.param.getBackcolor(), animationArg, dx, dy, option.getWatermark());
            }
            case SVG: {
                return this.createUGraphicSVG(colorMapper, scaleFactor, dim, this.param.getBackcolor(), option.getSvgLinkTarget(), option.getHoverColor(), seed, option.getPreserveAspectRatio(), this.param.getlengthAdjust());
            }
            case EPS: {
                return new UGraphicEps(colorMapper, EpsStrategy.getDefault2());
            }
            case EPS_TEXT: {
                return new UGraphicEps(colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            }
            case HTML5: {
                return new UGraphicHtml5(colorMapper);
            }
            case VDX: {
                return new UGraphicVdx(colorMapper);
            }
            case LATEX: {
                return new UGraphicTikz(colorMapper, scaleFactor, true, option.getTikzFontDistortion());
            }
            case LATEX_NO_PREAMBLE: {
                return new UGraphicTikz(colorMapper, scaleFactor, false, option.getTikzFontDistortion());
            }
            case BRAILLE_PNG: {
                return new UGraphicBraille(colorMapper, fileFormat);
            }
            case UTXT: 
            case ATXT: {
                return new UGraphicTxt();
            }
            case DEBUG: {
                return new UGraphicDebug();
            }
        }
        throw new UnsupportedOperationException(fileFormat.toString());
    }

    private UGraphic2 createUGraphicSVG(ColorMapper colorMapper, double scaleFactor, Dimension2D dim, HColor suggested, String svgLinkTarget, String hover, long seed, String preserveAspectRatio, LengthAdjust lengthAdjust) {
        UGraphicSvg ug;
        HColor backColor = HColorUtils.WHITE;
        if (suggested instanceof HColorSimple) {
            backColor = suggested;
        }
        boolean dimensionStyle = this.param.isSvgDimensionStyle();
        if (suggested instanceof HColorGradient) {
            ug = new UGraphicSvg(dimensionStyle, dim, colorMapper, (HColorGradient)suggested, false, scaleFactor, svgLinkTarget, hover, seed, preserveAspectRatio, this.param.getSvgCharSizeHack(), this.param.getlengthAdjust());
        } else if (backColor == null || colorMapper.toColor(backColor).equals(Color.WHITE)) {
            ug = new UGraphicSvg(dimensionStyle, dim, colorMapper, false, scaleFactor, svgLinkTarget, hover, seed, preserveAspectRatio, this.param.getSvgCharSizeHack(), this.param.getlengthAdjust());
        } else {
            String tmp = colorMapper.toSvg(backColor);
            ug = new UGraphicSvg(dimensionStyle, dim, colorMapper, tmp, false, scaleFactor, svgLinkTarget, hover, seed, preserveAspectRatio, this.param.getSvgCharSizeHack(), this.param.getlengthAdjust());
        }
        return ug;
    }

    private UGraphic2 createUGraphicPNG(ColorMapper colorMapper, double scaleFactor, Dimension2D dim, HColor mybackcolor, Animation affineTransforms, double dx, double dy, String watermark) {
        Color backColor = Color.WHITE;
        if (mybackcolor instanceof HColorSimple) {
            backColor = colorMapper.toColor(mybackcolor);
        } else if (mybackcolor instanceof HColorBackground) {
            backColor = null;
        }
        EmptyImageBuilder builder = new EmptyImageBuilder(watermark, (int)(dim.getWidth() * scaleFactor), (int)(dim.getHeight() * scaleFactor), backColor);
        Graphics2D graphics2D = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(colorMapper, graphics2D, scaleFactor, affineTransforms == null ? null : affineTransforms.getFirst(), dx, dy);
        ug.setBufferedImage(builder.getBufferedImage());
        BufferedImage im = ug.getBufferedImage();
        if (mybackcolor instanceof HColorGradient) {
            ug.apply(mybackcolor.bg()).draw(new URectangle((double)im.getWidth() / scaleFactor, (double)im.getHeight() / scaleFactor));
        }
        return ug;
    }

    public void setRandomPixel(boolean randomPixel) {
        this.randomPixel = randomPixel;
    }
}

