/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.timingdiagram.command.TimeTickBuilder;

public class CommandConstraint
extends SingleLineCommand2<TimingDiagram> {
    public CommandConstraint() {
        super(CommandConstraint.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandConstraint.class.getName(), RegexLeaf.start(), new RegexLeaf("PART1", "(([\\p{L}_][\\p{L}0-9_.]*))?"), TimeTickBuilder.expressionAtWithArobase("TIME1"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\<"), new RegexLeaf("ARROW", "(-+)"), new RegexLeaf("\\>"), RegexLeaf.spaceZeroOrMore(), TimeTickBuilder.expressionAtWithArobase("TIME2"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("MESSAGE", "(.*)"))), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg) {
        TimeTick tick1;
        Player player1;
        String part1 = arg.get("PART1", 0);
        if (part1 == null) {
            player1 = diagram.getLastPlayer();
            if (player1 == null) {
                return CommandExecutionResult.error("You have to provide a participant");
            }
        } else {
            player1 = diagram.getPlayer(part1);
            if (player1 == null) {
                return CommandExecutionResult.error("No such participant " + part1);
            }
        }
        if ((tick1 = TimeTickBuilder.parseTimeTick("TIME1", arg, diagram)) == null) {
            return CommandExecutionResult.error("Unknown time label");
        }
        diagram.updateNow(tick1);
        TimeTick tick2 = TimeTickBuilder.parseTimeTick("TIME2", arg, diagram);
        if (tick2 == null) {
            return CommandExecutionResult.error("Unknown time label");
        }
        player1.createConstraint(tick1, tick2, arg.get("MESSAGE", 0));
        return CommandExecutionResult.ok();
    }
}

