/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.expression;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.Knowledge;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.expression.Token;
import net.sourceforge.plantuml.tim.expression.TokenIterator;
import net.sourceforge.plantuml.tim.expression.TokenOperator;
import net.sourceforge.plantuml.tim.expression.TokenStack;
import net.sourceforge.plantuml.tim.expression.TokenType;

public class ReversePolishInterpretor {
    private final TValue result;
    private boolean trace = false;

    public ReversePolishInterpretor(TokenStack queue, Knowledge knowledge, TMemory memory, TContext context) throws EaterException, EaterExceptionLocated {
        this(null, queue, knowledge, memory, context);
    }

    public ReversePolishInterpretor(LineLocation location, TokenStack queue, Knowledge knowledge, TMemory memory, TContext context) throws EaterException, EaterExceptionLocated {
        ArrayDeque<TValue> stack = new ArrayDeque<TValue>();
        if (this.trace) {
            System.err.println("ReversePolishInterpretor::queue=" + queue);
        }
        TokenIterator it = queue.tokenIterator();
        while (it.hasMoreTokens()) {
            Token token = it.nextToken();
            if (this.trace) {
                System.err.println("rpn " + token);
            }
            if (token.getTokenType() == TokenType.NUMBER) {
                stack.addFirst(TValue.fromNumber(token));
                continue;
            }
            if (token.getTokenType() == TokenType.QUOTED_STRING) {
                stack.addFirst(TValue.fromString(token));
                continue;
            }
            if (token.getTokenType() == TokenType.JSON_DATA) {
                stack.addFirst(TValue.fromJson(token.getJson()));
                continue;
            }
            if (token.getTokenType() == TokenType.OPERATOR) {
                TValue v2 = (TValue)stack.removeFirst();
                TValue v1 = (TValue)stack.removeFirst();
                TokenOperator op = token.getTokenOperator();
                if (op == null) {
                    throw EaterException.unlocated("bad op");
                }
                TValue tmp = op.operate(v1, v2);
                stack.addFirst(tmp);
                continue;
            }
            if (token.getTokenType() == TokenType.OPEN_PAREN_FUNC) {
                int nb = Integer.parseInt(token.getSurface());
                Token token2 = it.nextToken();
                if (token2.getTokenType() != TokenType.FUNCTION_NAME) {
                    throw EaterException.unlocated("rpn43");
                }
                if (this.trace) {
                    System.err.println("token2=" + token2);
                }
                TFunction function = knowledge.getFunction(new TFunctionSignature(token2.getSurface(), nb));
                if (this.trace) {
                    System.err.println("function=" + function);
                }
                if (function == null) {
                    throw EaterException.unlocated("Unknow built-in function " + token2.getSurface());
                }
                if (!function.canCover(nb, Collections.<String>emptySet())) {
                    throw EaterException.unlocated("Bad number of arguments for " + function.getSignature().getFunctionName());
                }
                ArrayList<TValue> args = new ArrayList<TValue>();
                for (int i = 0; i < nb; ++i) {
                    args.add(0, (TValue)stack.removeFirst());
                }
                if (this.trace) {
                    System.err.println("args=" + args);
                }
                if (location == null) {
                    throw EaterException.unlocated("rpn44");
                }
                TValue r = function.executeReturnFunction(context, memory, location, args, Collections.<String, TValue>emptyMap());
                if (this.trace) {
                    System.err.println("r=" + r);
                }
                stack.addFirst(r);
                continue;
            }
            throw EaterException.unlocated("rpn41");
        }
        this.result = (TValue)stack.removeFirst();
    }

    public final TValue getResult() {
        return this.result;
    }
}

