/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sprite;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.donors.PSystemDonors;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockHorizontal;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.sprite.RessourcesUtils;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PSystemListInternalSprites
extends AbstractPSystem {
    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        UDrawable result = this.getGraphicStrings();
        HColor backcolor = HColorUtils.WHITE;
        ImageParameter imageParameter = new ImageParameter(new ColorMapperIdentity(), false, null, this.getMetadata(), null, ClockwiseTopRightBottomLeft.none(), backcolor);
        ImageBuilder imageBuilder = ImageBuilder.build(imageParameter);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private UDrawable getGraphicStrings() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("<b>List Current Sprites");
        lines.add("<i>Credit to");
        lines.add("http://www.archimatetool.com");
        lines.add(" ");
        for (String folder : RessourcesUtils.getJarFile("sprites", true)) {
            lines.add("<u>" + folder + "</u> :");
            lines.add(" ");
            for (String png : RessourcesUtils.getJarFile("sprites/" + folder, false)) {
                if (!png.endsWith(".png")) continue;
                String spriteName = png.substring(0, png.length() - 4);
                lines.add("<$archimate/" + spriteName + "> " + spriteName);
            }
        }
        List<TextBlock> cols = PSystemDonors.getCols(lines, 4, 0);
        return new TextBlockHorizontal(cols, VerticalAlignment.TOP);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Sprites)");
    }
}

