/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class DelayTile
extends AbstractTile
implements Tile {
    private final Delay delay;
    private final TileArguments tileArguments;
    private Real middle;

    @Override
    public Event getEvent() {
        return this.delay;
    }

    public DelayTile(Delay delay, TileArguments tileArguments) {
        super(tileArguments.getStringBounder());
        this.delay = delay;
        this.tileArguments = tileArguments;
    }

    private void init(StringBounder stringBounder) {
        if (this.middle != null) {
            return;
        }
        Real first = this.tileArguments.getFirstLivingSpace().getPosC(stringBounder);
        Component comp = this.getComponent(stringBounder);
        Real last = this.tileArguments.getLastLivingSpace().getPosC(stringBounder);
        this.middle = RealUtils.middle(first, last);
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.tileArguments.getSkin().createComponent(this.delay.getUsedStyles(), ComponentType.DELAY_TEXT, null, this.tileArguments.getSkinParam(), this.delay.getText());
        return comp;
    }

    private double getPreferredWidth(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return dim.getWidth();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        this.init(stringBounder);
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        Area area = new Area(this.getPreferredWidth(stringBounder), dim.getHeight());
        this.tileArguments.getLivingSpaces().delayOn(this.getY(), dim.getHeight());
        ug = ug.apply(UTranslate.dx(this.getMinX().getCurrentValue()));
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight() {
        Component comp = this.getComponent(this.getStringBounder());
        Dimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return dim.getHeight();
    }

    @Override
    public void addConstraints() {
    }

    @Override
    public Real getMinX() {
        this.init(this.getStringBounder());
        return this.middle.addFixed(-this.getPreferredWidth(this.getStringBounder()) / 2.0);
    }

    @Override
    public Real getMaxX() {
        this.init(this.getStringBounder());
        return this.middle.addFixed(this.getPreferredWidth(this.getStringBounder()) / 2.0);
    }
}

