/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandColorTask
extends SingleLineCommand2<GanttDiagram> {
    public CommandColorTask() {
        super(CommandColorTask.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandColorTask.class.getName(), RegexLeaf.start(), new RegexLeaf("CODE", "\\[([\\p{L}0-9_.]+)\\]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("COLORS", "#(\\w+)(?:/(#?\\w+))?"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String code = arg.get("CODE", 0);
        Task task = diagram.getExistingTask(code);
        if (task == null) {
            return CommandExecutionResult.error("No such task " + code);
        }
        String color1 = arg.get("COLORS", 0);
        String color2 = arg.get("COLORS", 1);
        HColor col1 = color1 == null ? null : diagram.getIHtmlColorSet().getColor(color1);
        HColor col2 = color2 == null ? null : diagram.getIHtmlColorSet().getColor(color2);
        task.setColors(new CenterBorderColor(col1, col2));
        return CommandExecutionResult.ok();
    }
}

