/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.png.PngIOMetadata;
import net.sourceforge.plantuml.security.ImageIO;
import net.sourceforge.plantuml.security.SFile;

public class PngIO {
    private static final String copyleft = "Generated by http://plantuml.com";

    public static void write(RenderedImage image, SFile file, int dpi) throws IOException {
        PngIO.write(image, file, null, dpi);
    }

    public static void write(RenderedImage image, OutputStream os, int dpi) throws IOException {
        PngIO.write(image, os, null, dpi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(RenderedImage image, SFile file, String metadata, int dpi) throws IOException {
        BufferedOutputStream os = null;
        try {
            os = file.createBufferedOutputStream();
            PngIO.write(image, os, metadata, dpi);
        }
        finally {
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
        Log.debug("File is " + file);
        Log.debug("File size " + file.length());
        if (file.length() == 0L) {
            Log.error("File size is zero: " + file);
            ImageIO.write(image, "png", file);
        }
    }

    public static void write(RenderedImage image, OutputStream os, String metadata, int dpi) throws IOException {
        PngIO.write(image, os, metadata, dpi, null);
    }

    public static void write(RenderedImage image, OutputStream os, String metadata, int dpi, String debugData) throws IOException {
        if (metadata == null) {
            ImageIO.write(image, "png", os);
        } else {
            PngIOMetadata.writeWithMetadata(image, os, metadata, dpi, debugData);
        }
    }
}

