/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.oregon;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.oregon.Keyboard;
import net.sourceforge.plantuml.oregon.KeyboardList;
import net.sourceforge.plantuml.oregon.NoInputException;
import net.sourceforge.plantuml.oregon.OregonBasicGame;
import net.sourceforge.plantuml.oregon.Screen;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class PSystemOregon
extends AbstractPSystem {
    private Screen screen;
    private List<String> inputs;

    @Deprecated
    public PSystemOregon(Keyboard keyboard) {
        OregonBasicGame game = new OregonBasicGame();
        try {
            game.run(keyboard);
            this.screen = game.getScreen();
        }
        catch (NoInputException e) {
            this.screen = game.getScreen();
        }
    }

    public PSystemOregon() {
        this.inputs = new ArrayList<String>();
    }

    public void add(String line) {
        if (StringUtils.isNotEmpty(line)) {
            this.inputs.add(line);
        }
    }

    private Screen getScreen() {
        if (this.screen == null) {
            KeyboardList keyboard = new KeyboardList(this.inputs);
            OregonBasicGame game = new OregonBasicGame();
            try {
                game.run(keyboard);
                this.screen = game.getScreen();
            }
            catch (NoInputException e) {
                this.screen = game.getScreen();
            }
        }
        return this.screen;
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        TextBlockBackcolored result = this.getGraphicStrings();
        HColor backcolor = result.getBackcolor();
        ImageParameter imageParameter = new ImageParameter(new ColorMapperIdentity(), false, null, this.getMetadata(), null, ClockwiseTopRightBottomLeft.none(), backcolor);
        ImageBuilder imageBuilder = ImageBuilder.build(imageParameter);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private TextBlockBackcolored getGraphicStrings() throws IOException {
        return GraphicStrings.createGreenOnBlackMonospaced(this.getScreen().getLines());
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(The Oregon Trail)");
    }
}

