/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.openiconic;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.openiconic.OpenIcon;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PSystemOpenIconic
extends AbstractPSystem {
    private final String iconName;
    private final double factor;

    public PSystemOpenIconic(String iconName, double factor) {
        this.iconName = iconName;
        this.factor = factor;
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        int margin2;
        int margin1;
        OpenIcon icon = OpenIcon.retrieve(this.iconName);
        if (UseStyle.useBetaStyle()) {
            margin1 = SkinParam.zeroMargin(5);
            margin2 = SkinParam.zeroMargin(5);
        } else {
            margin1 = 5;
            margin2 = 5;
        }
        ClockwiseTopRightBottomLeft margins = ClockwiseTopRightBottomLeft.margin1margin2(margin1, margin2);
        ImageParameter imageParameter = new ImageParameter(new ColorMapperIdentity(), false, null, null, null, margins, null);
        ImageBuilder imageBuilder = ImageBuilder.build(imageParameter);
        imageBuilder.setUDrawable(icon.asTextBlock(HColorUtils.BLACK, this.factor));
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Open iconic)");
    }
}

