/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.awt.geom.Dimension2D;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.nwdiag.LinkedElement;
import net.sourceforge.plantuml.nwdiag.Network;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class NwGroup {
    public static final HColorSet colors = HColorSet.instance();
    private final String name;
    private final Network network;
    private final Set<String> elements = new HashSet<String>();
    private HColor color;
    private String description;

    public String toString() {
        return this.name + " " + this.network + " " + this.elements;
    }

    public NwGroup(String name, Network network) {
        this.name = name;
        this.network = network;
    }

    public final String getName() {
        return this.name;
    }

    public void addElement(String name) {
        this.elements.add(name);
    }

    public boolean matches(LinkedElement tested) {
        if (this.network != null && this.network != tested.getNetwork()) {
            return false;
        }
        return this.elements.contains(tested.getElement().getName());
    }

    public final HColor getColor() {
        return this.color;
    }

    public final void setColor(HColor color) {
        this.color = color;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public void drawGroup(UGraphic ug, MinMax size, ISkinParam skinParam) {
        HColor color;
        TextBlock block = null;
        Dimension2D blockDim = null;
        if (this.description != null) {
            block = Display.getWithNewlines(this.description).create(this.getGroupDescriptionFontConfiguration(), HorizontalAlignment.LEFT, skinParam);
            blockDim = block.calculateDimension(ug.getStringBounder());
            double dy = size.getMinY() - blockDim.getHeight();
            size = size.addPoint(size.getMinX(), dy);
        }
        if ((color = this.getColor()) == null) {
            color = colors.getColorOrWhite("#AAA");
        }
        size.draw(ug, color);
        if (block != null) {
            block.drawU(ug.apply(new UTranslate(size.getMinX() + 5.0, size.getMinY())));
        }
    }

    private FontConfiguration getGroupDescriptionFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    public final Network getNetwork() {
        return this.network;
    }
}

