"""This module describe est applications which are available  through
the silx launcher.

Your environment should provide a command `est`. You can reach help with
`est --help`, and check the version with `est --version`.
"""

import logging
import sys
from silx.utils.launcher import Launcher
from est import __version__


def main():
    """Main function of the launcher

    This function is referenced in the setup.py file, to create a
    launcher script generated by setuptools.

    :rtype: int
    :returns: The execution status
    """
    launcher = Launcher(prog="est", version=__version__)
    launcher.add_command(
        "canvas",
        module_name="ewoksorange.canvas.main",
        description="open the orange-canvas",
    )
    launcher.add_command(
        "xas-viewer",
        module_name="est.app.xas_viewer",
        description="Open a viewer for browsing xas data",
    )

    status = launcher.execute(sys.argv)
    return status


if __name__ == "__main__":
    # executed when using python -m PROJECT_NAME
    logging.basicConfig()
    status = main()
    sys.exit(status)
