import argparse
import logging
import sys

from .worker import Worker


def cli(config, source_dir, build_directory, log_level=logging.INFO):
    # CLI options
    parser = argparse.ArgumentParser()

    subparsers = parser.add_subparsers(dest="subparser_name")

    build_parser = subparsers.add_parser("build", aliases=["b"])  # noqa

    watch_parser = subparsers.add_parser("watch", aliases=["w"])  # noqa

    serve_parser = subparsers.add_parser("serve", aliases=["s"])  # noqa
    serve_parser.add_argument("-p", "--port", type=int)
    serve_parser.add_argument("-a", "--address")

    args = parser.parse_args()

    # Set up logging
    root_logger = logging.getLogger("staticpipes")
    root_logger.setLevel(log_level)
    handler = logging.StreamHandler(sys.stdout)
    handler.setLevel(log_level)
    handler.setFormatter(
        logging.Formatter("%(levelname)s - %(asctime)s - %(name)s - %(message)s")
    )
    root_logger.addHandler(handler)

    # Do work
    if args.subparser_name == "build" or args.subparser_name == "b":
        worker = Worker(config, source_dir, build_directory)
        worker.build()

    elif args.subparser_name == "watch" or args.subparser_name == "w":
        worker = Worker(config, source_dir, build_directory)
        worker.watch()

    elif args.subparser_name == "serve" or args.subparser_name == "s":
        worker = Worker(config, source_dir, build_directory)
        worker.serve(
            server_address=args.address or "localhost", server_port=args.port or 8000
        )
