from typing import List, Optional

from com.inductiveautomation.ignition.common.user import ContactInfo, PyUser
from incendium.helper.types import AnyStr

class IncendiumUser:
    def __init__(self, user: PyUser) -> None: ...
    @property
    def contact_info(self) -> List[ContactInfo]: ...
    @property
    def email(self) -> List[AnyStr]: ...
    @property
    def first_name(self) -> AnyStr: ...
    @property
    def full_name(self) -> AnyStr: ...
    @property
    def last_name(self) -> AnyStr: ...
    @property
    def locale(self) -> AnyStr: ...
    @property
    def roles(self) -> List[AnyStr]: ...

def get_users(user_source: AnyStr = ..., filter_role: AnyStr = ...) -> List[PyUser]: ...
def get_emails(
    user_source: AnyStr = ..., filter_role: AnyStr = ...
) -> List[AnyStr]: ...
def get_user(
    user_source: AnyStr = ..., failover: Optional[AnyStr] = ...
) -> IncendiumUser: ...
def get_user_email_address(
    user_source: AnyStr = ..., failover: Optional[AnyStr] = ...
) -> List[AnyStr]: ...
def get_user_first_name(
    user_source: AnyStr = ..., failover: Optional[AnyStr] = ...
) -> AnyStr: ...
def get_user_full_name(
    user_source: AnyStr = ..., failover: Optional[AnyStr] = ...
) -> AnyStr: ...
