"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedactionLambda = exports.AccessConrtolLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sam = require("aws-cdk-lib/aws-sam");
const cdk = require("aws-cdk-lib/core");
const constructs_1 = require("constructs");
class AccessConrtolLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const semanticVersion = props.semanticVersion ?? '1.0.2';
        const confidenceThreshold = props.confidenceThreshold ?? '0.5';
        const containsPiiEntitiesThreadCount = props.containsPiiEntitiesThreadCount ?? '20';
        const defaultLanguageCode = props.defaultLanguageCode ?? 'en';
        const documentMaxSize = props.documentMaxSize ?? '102400';
        const documentMaxSizeContainsPiiEntities = props.documentMaxSizeContainsPiiEntities ?? '50000';
        const isPartialObjectSupported = props.isPartialObjectSupported ?? 'false';
        const logLevel = props.logLevel ?? 'INFO';
        const maxCharsOverlap = props.maxCharsOverlap ?? '200';
        const piiEntityTypes = props.piiEntityTypes ?? 'ALL';
        const publishCloudWatchMetrics = props.publishCloudWatchMetrics ?? 'true';
        const subsegmentOverlappingTokens = props.subsegmentOverlappingTokens ?? '20';
        const unsupportedFileHandling = props.unsupportedFileHandling ?? 'FAIL';
        this.samApplication = new sam.CfnApplication(this, 'ComprehendPiiAccessControlS3ObjectLambda', {
            location: {
                applicationId: 'arn:aws:serverlessrepo:us-east-1:839782855223:applications/ComprehendPiiAccessControlS3ObjectLambda',
                semanticVersion: semanticVersion,
            },
            parameters: {
                ['ConfidenceThreshold']: confidenceThreshold,
                ['ContainsPiiEntitiesThreadCount']: containsPiiEntitiesThreadCount,
                ['DefaultLanguageCode']: defaultLanguageCode,
                ['DocumentMaxSize']: documentMaxSize,
                ['DocumentMaxSizeContainsPiiEntities']: documentMaxSizeContainsPiiEntities,
                ['IsPartialObjectSupported']: isPartialObjectSupported,
                ['LogLevel']: logLevel,
                ['MaxCharsOverlap']: maxCharsOverlap,
                ['PiiEntityTypes']: piiEntityTypes,
                ['PublishCloudWatchMetrics']: publishCloudWatchMetrics,
                ['SubsegmentOverlappingTokens']: subsegmentOverlappingTokens,
                ['UnsupportedFileHandling']: unsupportedFileHandling,
            },
        });
        this.stackName = cdk.Token.asString(this.samApplication.ref);
    }
}
exports.AccessConrtolLambda = AccessConrtolLambda;
_a = JSII_RTTI_SYMBOL_1;
AccessConrtolLambda[_a] = { fqn: "cdk-comprehend-s3olap.AccessConrtolLambda", version: "2.0.311" };
class RedactionLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const semanticVersion = props?.semanticVersion ?? '1.0.2';
        const logLevel = props?.logLevel ?? 'INFO';
        const unsupportedFileHandling = props?.unsupportedFileHandling ?? 'FAIL';
        const isPartialObjectSupported = props?.isPartialObjectSupported ?? 'false';
        const documentMaxSizeContainsPiiEntities = props?.documentMaxSizeContainsPiiEntities ?? '50000';
        const documentMaxSizeDetectPiiEntities = props?.documentMaxSizeDetectPiiEntities ?? '5000';
        const piiEntityTypes = props?.piiEntityTypes ?? 'ALL';
        const maskCharacter = props?.maskCharacter ?? '*';
        const maskMode = props?.maskMode ?? 'MASK';
        const subsegmentOverlappingTokens = props?.subsegmentOverlappingTokens ?? '20';
        const documentMaxSize = props?.documentMaxSize ?? '102400';
        const confidenceThreshold = props?.confidenceThreshold ?? '0.5';
        const maxCharsOverlap = props?.maxCharsOverlap ?? '200';
        const defaultLanguageCode = props?.defaultLanguageCode ?? 'en';
        const detectPiiEntitiesThreadCount = props?.detectPiiEntitiesThreadCount ?? '8';
        const containsPiiEntitiesThreadCount = props?.containsPiiEntitiesThreadCount ?? '20';
        const publishCloudWatchMetrics = props?.publishCloudWatchMetrics ?? 'true';
        this.samApplication = new sam.CfnApplication(this, 'ComprehendPiiAccessControlS3ObjectLambda', {
            location: {
                applicationId: 'arn:aws:serverlessrepo:us-east-1:839782855223:applications/ComprehendPiiRedactionS3ObjectLambda',
                semanticVersion: semanticVersion,
            },
            parameters: {
                ['LogLevel']: logLevel,
                ['UnsupportedFileHandling']: unsupportedFileHandling,
                ['IsPartialObjectSupported']: isPartialObjectSupported,
                ['DocumentMaxSizeContainsPiiEntities']: documentMaxSizeContainsPiiEntities,
                ['DocumentMaxSizeDetectPiiEntities']: documentMaxSizeDetectPiiEntities,
                ['PiiEntityTypes']: piiEntityTypes,
                ['MaskCharacter']: maskCharacter,
                ['MaskMode']: maskMode,
                ['SubsegmentOverlappingTokens']: subsegmentOverlappingTokens,
                ['DocumentMaxSize']: documentMaxSize,
                ['ConfidenceThreshold']: confidenceThreshold,
                ['MaxCharsOverlap']: maxCharsOverlap,
                ['DefaultLanguageCode']: defaultLanguageCode,
                ['DetectPiiEntitiesThreadCount']: detectPiiEntitiesThreadCount,
                ['ContainsPiiEntitiesThreadCount']: containsPiiEntitiesThreadCount,
                ['PublishCloudWatchMetrics']: publishCloudWatchMetrics,
            },
        });
        this.stackName = cdk.Token.asString(this.samApplication.ref);
    }
}
exports.RedactionLambda = RedactionLambda;
_b = JSII_RTTI_SYMBOL_1;
RedactionLambda[_b] = { fqn: "cdk-comprehend-s3olap.RedactionLambda", version: "2.0.311" };
//# sourceMappingURL=data:application/json;base64,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