#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.product_structure_interfaces.product import Product
from pycatia.system_interfaces.any_object import AnyObject


class StrComputeServices(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     StrComputeServices
                | 
                | Represents a structure service object.
                | Structure service object extracts properties on structure objects. Methods of
                | this interface are computing the mass properties of the main body (PartBody) of
                | each Structure Object (Member and Plate)
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.str_compute_services = com_object

    def get_center_of_gravity(self, i_product: Product, o_x: float, o_y: float, o_z: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetCenterOfGravity(Product iProduct,
                | double oX,
                | double oY,
                | double oZ)
                | 
                |     Retreive the center of gravity for a structure object.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The selected structure object 
                |         oX
                |             The x coordinate of the center of gravity 
                |         oY
                |             The y coordinate of the center of gravity 
                |         oZ
                |             The z coordinate of the center of gravity

        :param Product i_product:
        :param float o_x:
        :param float o_y:
        :param float o_z:
        :rtype: None
        """
        return self.str_compute_services.GetCenterOfGravity(i_product.com_object, o_x, o_y, o_z)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_center_of_gravity'
        # # vba_code = """
        # # Public Function get_center_of_gravity(str_compute_services)
        # #     Dim iProduct (2)
        # #     str_compute_services.GetCenterOfGravity iProduct
        # #     get_center_of_gravity = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_length(self, i_product: Product) -> float:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetLength(Product iProduct) As double
                | 
                |     Returns the length to cut for a member object.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The selected structure object

        :param Product i_product:
        :rtype: float
        """
        return self.str_compute_services.GetLength(i_product.com_object)

    def get_mass(self, i_product: Product) -> float:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetMass(Product iProduct) As double
                | 
                |     Returns the mass for a structure object.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The selected structure object

        :param Product i_product:
        :rtype: float
        """
        return self.str_compute_services.GetMass(i_product.com_object)

    def get_material_name(self, i_product: Product) -> str:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetMaterialName(Product iProduct) As CATBSTR
                | 
                |     Returns the material name for a structure object.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The selected structure object 
                |         oName
                |             The name of the material

        :param Product i_product:
        :rtype: str
        """
        return self.str_compute_services.GetMaterialName(i_product.com_object)

    def get_surface(self, i_product: Product) -> float:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetSurface(Product iProduct) As double
                | 
                |     Returns the surface for a structure object.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The selected structure object

        :param Product i_product:
        :rtype: float
        """
        return self.str_compute_services.GetSurface(i_product.com_object)

    def get_volume(self, i_product: Product) -> float:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetVolume(Product iProduct) As double
                | 
                |     Returns the volume for a structure object.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The selected structure object

        :param Product i_product:
        :rtype: float
        """
        return self.str_compute_services.GetVolume(i_product.com_object)

    def get_wet_area(self, i_product: Product) -> float:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetWetArea(Product iProduct) As double
                | 
                |     Returns the wet area for a structure object.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The selected structure object

        :param Product i_product:
        :rtype: float
        """
        return self.str_compute_services.GetWetArea(i_product.com_object)

    def __repr__(self):
        return f'StrComputeServices(name="{self.name}")'
