#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class FreeSpace(AnyObject):

    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     FreeSpace
                | 
                | Interface to access a CATIAFreeSpace
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.free_space = com_object

    @property
    def volume(self) -> float:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property Volume() As double (Read Only)
                | 
                |     Returns the volume.

        :rtype: float
        """

        return self.free_space.Volume

    def get_gravity_center(self, o_gravity_center_coordinates_array: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetGravityCenter(CATSafeArrayVariant
                | oGravityCenterCoordinatesArray)
                | 
                |     Returns the gravity center.

        :param tuple o_gravity_center_coordinates_array:
        :rtype: None
        """
        return self.free_space.GetGravityCenter(o_gravity_center_coordinates_array)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_gravity_center'
        # # vba_code = """
        # # Public Function get_gravity_center(free_space)
        # #     Dim oGravityCenterCoordinatesArray (2)
        # #     free_space.GetGravityCenter oGravityCenterCoordinatesArray
        # #     get_gravity_center = oGravityCenterCoordinatesArray
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'FreeSpace(name="{ self.name }")'
