#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.product_structure_interfaces.product import Product
from pycatia.system_interfaces.any_object import AnyObject


class Replay(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     Replay
                | 
                | The interface to access a CATIAReplay
                | 
                | Use this interface to customize the Replay object
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.replay = com_object

    def add_product_motion(self, i_product: Product) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func AddProductMotion(Product iProduct) As long
                | 
                |     Adds a product to be taken into account in the Replay
                |     object.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             CATIAProduct. Product to add. 
                |         oChannel
                |             Channel number.

        :param Product i_product:
        :rtype: int
        """
        return self.replay.AddProductMotion(i_product.com_object)

    def add_sample(self, i_channel: int, i_current_time: float, i_position: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSample(long iChannel,
                | double iCurrentTime,
                | CATSafeArrayVariant iPosition)
                | 
                |     Adds a sample(set of values) for a channel at a specific
                |     time
                | 
                |     Parameters:
                | 
                |         iChannel
                |             Channel number. 
                |         iCurrentTime
                |             Time. 
                |         iPosition
                |             Array of values to consider the the specified
                |             channel.

        :param int i_channel:
        :param float i_current_time:
        :param tuple i_position:
        :rtype: None
        """
        return self.replay.AddSample(i_channel, i_current_time, i_position)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_sample'
        # # vba_code = """
        # # Public Function add_sample(replay)
        # #     Dim iChannel (2)
        # #     replay.AddSample iChannel
        # #     add_sample = iChannel
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_nb_product_motion(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNbProductMotion() As long
                | 
                |     Get the number of channel related to products.
                | 
                |     Parameters:
                | 
                |         oNbChannel
                |             Number of channel associated to products.

        :rtype: int
        """
        return self.replay.GetNbProductMotion()

    def get_nb_sample(self, i_channel: int) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNbSample(long iChannel) As long
                | 
                |     Get the number of samples for a channel number.
                | 
                |     Parameters:
                | 
                |         iChannel
                |             Channel index. 
                |         oNbSample
                |             Number of samples.

        :param int i_channel:
        :rtype: int
        """
        return self.replay.GetNbSample(i_channel)

    def get_product(self, i_channel: int) -> Product:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetProduct(long iChannel) As Product
                | 
                |     Get the product for a channel.
                | 
                |     Parameters:
                | 
                |         iChannel
                |             Channel index. 
                |         oProduct
                |             Product.

        :param int i_channel:
        :rtype: Product
        """
        return Product(self.replay.GetProduct(i_channel))

    def get_sample_position(self, i_channel: int, i_sample: int, o_position: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetSamplePosition(long iChannel,
                | long iSample,
                | CATSafeArrayVariant oPosition)
                | 
                |     Get the sample values.
                | 
                |     Parameters:
                | 
                |         iChannel
                |             Channel index. 
                |         iSample
                |             Sample index. 
                |         oPosition
                |             Array of values.

        :param int i_channel:
        :param int i_sample:
        :param tuple o_position:
        :rtype: None
        """
        return self.replay.GetSamplePosition(i_channel, i_sample, o_position)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_sample_position'
        # # vba_code = """
        # # Public Function get_sample_position(replay)
        # #     Dim iChannel (2)
        # #     replay.GetSamplePosition iChannel
        # #     get_sample_position = iChannel
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_sample_time(self, i_channel: int, i_sample: int) -> float:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetSampleTime(long iChannel,
                | long iSample) As double
                | 
                |     Get the sample time.
                | 
                |     Parameters:
                | 
                |         iChannel
                |             Channel index. 
                |         iSample
                |             Sample index. 
                |         oTime
                |             Time value.

        :param int i_channel:
        :param int i_sample:
        :rtype: float
        """
        return self.replay.GetSampleTime(i_channel, i_sample)

    def remove_sample(self, i_channel: int, i_sample: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveSample(long iChannel,
                | long iSample)
                | 
                |     Remove a specific sample.
                | 
                |     Parameters:
                | 
                |         iChannel
                |             Channel index. 
                |         iSample
                |             Sample index.

        :param int i_channel:
        :param int i_sample:
        :rtype: None
        """
        return self.replay.RemoveSample(i_channel, i_sample)

    def __repr__(self):
        return f'Replay(name="{self.name}")'
