#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.manufacturing_interfaces.manufacturing_generator_data import ManufacturingGeneratorData
from pycatia.system_interfaces.any_object import AnyObject


class ManufacturingOutputGenerator(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     ManufacturingOutputGenerator
                | 
                | Father object to generate output machining code.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.manufacturing_output_generator = com_object

    def add_me_to_buffer(self, o_add_me: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddMeToBuffer(long oAddMe)
                | 
                |     Management of specific buffer for aligned points elimination.

        :param int o_add_me:
        :rtype: None
        """
        return self.manufacturing_output_generator.AddMeToBuffer(o_add_me)

    def generate_output_code(self, i_data: ManufacturingGeneratorData) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GenerateOutputCode(ManufacturingGeneratorData iData)
                | 
                |     Return the Output Code for an object in the right CNC Machine.

        :param ManufacturingGeneratorData i_data:
        :rtype: None
        """
        return self.manufacturing_output_generator.GenerateOutputCode(i_data.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'generate_output_code'
        # # vba_code = """
        # # Public Function generate_output_code(manufacturing_output_generator)
        # #     Dim iData (2)
        # #     manufacturing_output_generator.GenerateOutputCode iData
        # #     generate_output_code = iData
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_apt_code(self, i_data: ManufacturingGeneratorData, o_code: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAPTCode(ManufacturingGeneratorData iData,
                | CATBSTR oCode)
                | 
                |     Retrieve generated APT code.

        :param ManufacturingGeneratorData i_data:
        :param str o_code:
        :rtype: None
        """
        return self.manufacturing_output_generator.GetAPTCode(i_data.com_object, o_code)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_apt_code'
        # # vba_code = """
        # # Public Function get_apt_code(manufacturing_output_generator)
        # #     Dim iData (2)
        # #     manufacturing_output_generator.GetAPTCode iData
        # #     get_apt_code = iData
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_current_object(self, o_current_object: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetCurrentObject(long oCurrentObject)
                | 
                |     Get current object from buffer.

        :param int o_current_object:
        :rtype: None
        """
        return self.manufacturing_output_generator.GetCurrentObject(o_current_object)

    def has_to_reset_modal_values(self, o_is_modal: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub HasToResetModalValues(long oIsModal)
                | 
                |     Return the characteristic of an object : Reset or not Modal Values.

        :param int o_is_modal:
        :rtype: None
        """
        return self.manufacturing_output_generator.HasToResetModalValues(o_is_modal)

    def init_file_generator(self, i_format: str, i_file_name: str, o_data: ManufacturingGeneratorData) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub InitFileGenerator(CATBSTR iFormat,
                | CATBSTR iFileName,
                | ManufacturingGeneratorData oData)
                | 
                |     Init the Output Generator on the current Object and initialise all datas.
                |     Generation of NC code can start from the Process, Setup, Program or an
                |     Activity.
                | 
                |     Parameters:
                | 
                |         iFormat
                |             Format of the output file : "APT", ... 
                |         iFileName
                |             Output file name 
                |         oData
                |             iData contains all the information about the generated NC
                |             code

        :param str i_format:
        :param str i_file_name:
        :param ManufacturingGeneratorData o_data:
        :rtype: None
        """
        return self.manufacturing_output_generator.InitFileGenerator(i_format, i_file_name, o_data.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'init_file_generator'
        # # vba_code = """
        # # Public Function init_file_generator(manufacturing_output_generator)
        # #     Dim iFormat (2)
        # #     manufacturing_output_generator.InitFileGenerator iFormat
        # #     init_file_generator = iFormat
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def is_modal(self, o_is_modal: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub IsModal(long oIsModal)
                | 
                |     Return the characteristic of an object : Modal or Not Modal.

        :param int o_is_modal:
        :rtype: None
        """
        return self.manufacturing_output_generator.IsModal(o_is_modal)

    def is_similar_to(self, i_object: 'ManufacturingOutputGenerator') -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func IsSimilarTo(ManufacturingOutputGenerator iObject) As
                | long
                | 
                |     Implement a method to specify if two objects are same (when Modal Mode).
                |     The result depends on the tolerance on the values (to points)

        :param ManufacturingOutputGenerator i_object:
        :rtype: int
        """
        return self.manufacturing_output_generator.IsSimilarTo(i_object.com_object)

    def run_file_generator(self, i_data: ManufacturingGeneratorData) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RunFileGenerator(ManufacturingGeneratorData iData)
                | 
                |     Runs the Output Generator on the datas used for generation. Generation of
                |     NC code can start from the Process, Setup, Program or an
                |     Activity.
                | 
                |     Parameters:
                | 
                |         iData
                |             iData contains all the information about the generated NC
                |             code

        :param ManufacturingGeneratorData i_data:
        :rtype: None
        """
        return self.manufacturing_output_generator.RunFileGenerator(i_data.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'run_file_generator'
        # # vba_code = """
        # # Public Function run_file_generator(manufacturing_output_generator)
        # #     Dim iData (2)
        # #     manufacturing_output_generator.RunFileGenerator iData
        # #     run_file_generator = iData
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_current_object(self, i_current_object: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetCurrentObject(long iCurrentObject)
                | 
                |     Set current object to buffer.

        :param int i_current_object:
        :rtype: None
        """
        return self.manufacturing_output_generator.SetCurrentObject(i_current_object)

    def __repr__(self):
        return f'ManufacturingOutputGenerator(name="{self.name}")'
