#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.funct_system_interfaces.funct_association import FunctAssociation
from pycatia.system_interfaces.collection import Collection
from pycatia.types.general import cat_variant


class FunctAssociations(Collection):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.Collection
                |                     FunctAssociations
                | 
                | The interface to access a set of Functional Associations.
                | 
                | It is managed on a Functional Element, thru the MultiRep Facet Manager
                | (MRM).
    
    """

    def __init__(self, com_object, child_object=FunctAssociation):
        super().__init__(com_object, child_object=FunctAssociation)
        self.funct_associations = com_object
        self.child_object = child_object

    def create(self, i_name: str) -> FunctAssociation:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Create(CATBSTR iName) As FunctAssociation
                | 
                |     Create a FunctAssociation.

        :param str i_name:
        :rtype: FunctAssociation
        """
        return FunctAssociation(self.funct_associations.Create(i_name))

    def delete(self, i_association: FunctAssociation) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Delete(FunctAssociation iAssociation)
                | 
                |     Delete a FunctAssociation.

        :param FunctAssociation i_association:
        :rtype: None
        """
        return self.funct_associations.Delete(i_association.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'delete'
        # # vba_code = """
        # # Public Function delete(funct_associations)
        # #     Dim iAssociation (2)
        # #     funct_associations.Delete iAssociation
        # #     delete = iAssociation
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def elem(self, i_index: cat_variant) -> FunctAssociation:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Elem(CATVariant iIndex) As FunctAssociation
                | 
                |     Returns an association using its index or its name from the associations
                |     collection.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index or the name of the association to retrieve from the
                |             collection of associations. As a numerics, this index is the rank of the
                |             association in the collection. The index of the first association in the
                |             collection is 1, and the index of the last association is Count. As a string,
                |             it is the name you assigned to the association using the
                |             
                | 
                |         AnyObject.Name property. 
                |     Returns:
                |         The retrieved association 
                |     Example:
                |         This example retrieves in Act1 the fifth association in the collection
                |         and in Act2 the association named Moves.
                | 
                |          Dim FunctElem As FunctionalObject
                |          Set FunctElem = FunctDoc.CurrentDescription.Objects.Elem("Valve")
                |          Dim FacetMRM As FunctionalMultiRepMgr
                |          Set FacetMRM = FunctElem.GetFacetByName("MRM")
                |          Dim Assoc1 As FunctAssociation
                |          Set Assoc1 = FacetMRM.Associations.Elem(5)
                |          Dim Assoc2 As FunctAssociation
                |          Set Assoc2 = FacetMRM.Associations.Elem("Skeleton 2D")

        :param cat_variant i_index:
        :rtype: FunctAssociation
        """
        return FunctAssociation(self.funct_associations.Elem(i_index))

    def __repr__(self):
        return f'FunctAssociations(name="{self.name}")'
