#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.fitting_interfaces.sampled import Sampled


class Track(Sampled):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     FittingInterfaces.Sampled
                |                         Track
                | 
                | The interface to access a CATIATrack.
                | Role: A CATIATrack (or track) object is an object to define motion to various
                | items (such as a product or a shuttle). These tracks can be simulated which
                | results in them to move along the defined trajectory (with a set
                | speed).
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.track = com_object

    @property
    def move_mode(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property MoveMode() As DMUTrackMoveMode
                | 
                |     Returns or sets the track's movement mode. Can be speed or time based. In
                |     Speed mode, the total time is calculated based on the time need to travel the
                |     distance of the track at the given speed. In Time mode, the movement speed to
                |     calculated so that the end of the track is reached by the end of the total
                |     time. Uses enum DMUTrackMoveMode, which defined is in this interface.

        :return: enum dmu_track_move_mode
        :rtype: int
        """

        return self.track.MoveMode

    @move_mode.setter
    def move_mode(self, value: int):
        """
        :param int value: enum dmu_track_move_mode
        """

        self.track.MoveMode = value

    @property
    def speed(self) -> float:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property Speed() As double
                | 
                |     Returns or sets the track speed. Please note that the value of the speed
                |     should be greater than zero.
                | 
                |     Example
                |         This example sets the track speed to 17.54.
                | 
                |          myTrack.Speed =  17.54

        :rtype: float
        """

        return self.track.Speed

    @speed.setter
    def speed(self, value: float):
        """
        :param float value:
        """

        self.track.Speed = value

    def get_matrix_all(self, o_matrix_all: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetMatrixAll(CATSafeArrayVariant oMatrixAll)
                | 
                |     GetMatrixAll Gets the base location of the track. The sum of several
                |     internal transforms.
                | 
                |     Parameters:
                | 
                |         oMatrixAll
                |             An array of 12 doubles. A 3 by 3 rotation matrix followed by a
                |             position (x/y/z) vector, in millimeters. 
                | 
                |     Returns:
                |         S_OK if everything was succcessfull

        :param tuple o_matrix_all:
        :rtype: None
        """
        return self.track.GetMatrixAll(o_matrix_all)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_matrix_all'
        # # vba_code = """
        # # Public Function get_matrix_all(track)
        # #     Dim oMatrixAll (2)
        # #     track.GetMatrixAll oMatrixAll
        # #     get_matrix_all = oMatrixAll
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def mirror(self, i_point: tuple, i_normal: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Mirror(CATSafeArrayVariant iPoint,
                | CATSafeArrayVariant iNormal)
                | 
                |     Produces a "mirror image" of the track. Role: Determines the "mirror image"
                |     of a track. The "mirror" is a 3d plane specified by a point on the plane and
                |     the normal to the surface of the plane. The mirror calculation involves going
                |     through each shot and projecting it in the space on the other side of the
                |     mirror plane. The projection "reflects" the point perpendicularly to the
                |     plane.
                | 
                |     Parameters:
                | 
                |         iPoint
                |             A point on the plane that will be used to define the mirror.
                |             
                |         iNormal
                |             A normal to the plane that will be used to define the
                |             mirror.

        :param tuple i_point:
        :param tuple i_normal:
        :rtype: None
        """
        return self.track.Mirror(i_point, i_normal)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'mirror'
        # # vba_code = """
        # # Public Function mirror(track)
        # #     Dim iPoint (2)
        # #     track.Mirror iPoint
        # #     mirror = iPoint
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def move(self, i_transform: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Move(CATSafeArrayVariant iTransfo)
                | 
                |     Moves the track a certain position.
                | 
                |     Parameters:
                | 
                |         iTransfo
                |             Specifies a relative amount to move the track.

        :param tuple i_transform:
        :rtype: None
        """
        return self.track.Move(i_transform)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'move'
        # # vba_code = """
        # # Public Function move(track)
        # #     Dim iTransfo (2)
        # #     track.Move iTransfo
        # #     move = iTransfo
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'Track(name="{self.name}")'
