#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dnb_robot_interfaces.tcp_trace import TCPTrace
from pycatia.system_interfaces.any_object import AnyObject


class TCPTraceManager(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     TCPTraceManager
                | 
                | Interface representing an accessor to TCP traces object from a
                | product.
                | 
                | Role: This interface is used to retrieve TCP traces from a product. This
                | product is the assembly node representing the inverse kinematics
                | assembly.
                | 
                | A TCP trace is the graphical output of a task simulation. This output is the
                | trajectory path generated by the TCP, defined by lines and points. Each point
                | represents the location of the TCP at a given time.
                | 
                | The following code snippet can be used to obtain a handle from a
                | product:
                | 
                |    Dim MyRobot As Product
                |    'retrieval of the product
                |    ...
                | 
                |    'retrieval of the trace manager
                |    Dim objDevice As TCPTraceManager
                |    set objDevice = MyRobot.GetTechnologicalObject("TCPTraceManager")
                |    
                |    'activate the trace
                |    objDevice.TCPTraceMode=True
                | 
                |    'Get the last path
                |    Dim NbPath As Long
                |    NbPath = objDevice.GetNbPath
                |    If NbPath>0 Then
                |       ' retrieval of the last trace
                |       Dim RobotTCPTrace As TCPTrace
                |       Set RobotTCPTrace = objDevice.GetPath(NbPath)
                | 
                |       'Export the trace points
                |       RobotTCPTrace.Export("C:/TEMP/DEBUG.xls")
                |    End If
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.tcp_trace_manager = com_object

    @property
    def init_status(self) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property InitStatus() As boolean
                | 
                |     Indicates whether the tracing capability must delete previous traces when
                |     the simulation starts.
                | 
                |         True: previous traces are deleted
                |         False: previous traces are kept
                | 
                |     Parameters:
                | 
                |         oInitStatus
                |             Boolean. Indicates if the tracing capability is activ or
                |             not.

        :rtype: bool
        """

        return self.tcp_trace_manager.InitStatus

    @init_status.setter
    def init_status(self, value: bool):
        """
        :param bool value:
        """

        self.tcp_trace_manager.InitStatus = value

    @property
    def tcp_trace_mode(self) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property TCPTraceMode() As boolean
                | 
                |     Indicates if the tracing capability is activ or not.
                | 
                |         True: tracing capability activated
                |         False: tracing capability deactivated
                | 
                |     Parameters:
                | 
                |         oTCPTraceMode
                |             Boolean. Indicates if the tracing capability is activ or
                |             not.

        :rtype: bool
        """

        return self.tcp_trace_manager.TCPTraceMode

    @tcp_trace_mode.setter
    def tcp_trace_mode(self, value: bool):
        """
        :param bool value:
        """

        self.tcp_trace_manager.TCPTraceMode = value

    def get_attached_owner(self) -> AnyObject:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetAttachedOwner() As AnyObject
                | 
                |     Retrieves the default attached owner of the trace. By default, the owner of
                |     the trace is the robot assembly node. If the robot is moved, the trace will
                |     follow. However, in some scenarios, the trace might be drawn related to another
                |     product (or even with respect to the world) like for example when dealing with
                |     a workpiece positioner.
                | 
                |     Parameters:
                | 
                |         oOwner
                |             CATIABase. Attached owner of the trace. Output parameter. Returns
                |             nothing if the trace is defined related to the world

        :rtype: AnyObject
        """
        return AnyObject(self.tcp_trace_manager.GetAttachedOwner())

    def get_nb_path(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetNbPath() As long
                | 
                |     Get the number of TCP trace.
                | 
                |     Parameters:
                | 
                |         oNb
                |             Long. Number of traces. Output parameter.

        :rtype: int
        """
        return self.tcp_trace_manager.GetNbPath()

    def get_path(self, i_index: int) -> TCPTrace:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetPath(long iIndex) As TCPTrace
                | 
                |     Get the iIndex path(trace)(starting at 1).
                | 
                |     Parameters:
                | 
                |         iIndex
                |             Long. Path/Trace index starting at 1. Input parameter.
                |             
                |         oTCPPath
                |             DNBIATCPTrace. Pointer on the trace. Output parameter.

        :param int i_index:
        :rtype: TCPTrace
        """
        return TCPTrace(self.tcp_trace_manager.GetPath(i_index))

    def remove_all_path(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveAllPath()
                | 
                |     Remove all traces from the current resource. All traces associated with the
                |     current resource will be removed from the 3D and deleted.

        :rtype: None
        """
        return self.tcp_trace_manager.RemoveAllPath()

    def remove_path_by_index(self, i_index: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemovePathByIndex(long iIndex)
                | 
                |     Remove a specific path based on its position in the list. The trace will be
                |     removed from the 3D viewer and deleted.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             Long. Position index starting at 1. Must be positiv. Input
                |             parameter.

        :param int i_index:
        :rtype: None
        """
        return self.tcp_trace_manager.RemovePathByIndex(i_index)

    def remove_path_by_object(self, tcp_path: TCPTrace) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemovePathByObject(TCPTrace TCPPath)
                | 
                |     Remove a specific trace based on the object. The trace will be removed from
                |     the 3D viewer and deleted.
                | 
                |     Parameters:
                | 
                |         TCPPath
                |             DNBIATCPTrace. Path to be removed.

        :param TCPTrace tcp_path:
        :rtype: None
        """
        return self.tcp_trace_manager.RemovePathByObject(tcp_path.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_path_by_object'
        # # vba_code = """
        # # Public Function remove_path_by_object(tcp_trace_manager)
        # #     Dim TCPPath (2)
        # #     tcp_trace_manager.RemovePathByObject TCPPath
        # #     remove_path_by_object = TCPPath
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def reset_attached_owner(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ResetAttachedOwner()
                | 
                |     Resets the attached owner of the trace to the world. When a new trace will
                |     be created, it will defined with respect to the world.
                |     Remark: this will not change the exported values.

        :rtype: None
        """
        return self.tcp_trace_manager.ResetAttachedOwner()

    def set_attached_owner(self, i_owner: AnyObject) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetAttachedOwner(AnyObject iOwner)
                | 
                |     Sets the default attached owner of the trace. By default, the owner of the
                |     trace is the robot. When a new trace is created, the attached owner is used to
                |     set it upon the trace.
                |     Remark: set the attached owner will not change the exported
                |     values.
                | 
                |     Parameters:
                | 
                |         iOwner
                |             CATIABase. Attached owner of the trace. Input parameter.

        :param AnyObject i_owner:
        :rtype: None
        """
        return self.tcp_trace_manager.SetAttachedOwner(i_owner.com_object)

    def __repr__(self):
        return f'TCPTraceManager(name="{self.name}")'
