#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class TCPTrace(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     TCPTrace
                | 
                | Interface representing a TCP trace.
                | 
                | Role: This interface is used to interact with an inverse kinematics device on
                | which a TCP(Tool Center Point) has been defined.
                | 
                | A TCP trace is the graphical output of a task simulation. This output is the
                | trajectory path generated by the TCP, defined by lines and points. Each point
                | represents the location of the TCP at a given time.
                | 
                | The following code snippet can be used to obtain a handle from a
                | product:
                | 
                |    Dim MyRobot As Product
                |    'retrieval of the product
                |    ...
                | 
                |    'retrieval of the trace manager
                |    Dim objDevice As TCPTraceManager
                |    set objDevice = MyRobot.GetTechnologicalObject("TCPTraceManager")
                |    
                |    'activate the trace
                |    objDevice.TCPTraceMode=True
                | 
                |    'Get the last path
                |    Dim NbPath As Long
                |    NbPath = objDevice.GetNbPath
                |    If NbPath>0 Then
                |       ' retrieval of the last trace
                |       Dim RobotTCPTrace As TCPTrace
                |       Set RobotTCPTrace = objDevice.GetPath(NbPath)
                | 
                |       'Export the trace points
                |       RobotTCPTrace.Export("C:/TEMP/DEBUG.xls")
                |    End If
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.tcp_trace = com_object

    @property
    def total_points(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property TotalPoints() As long (Read Only)
                | 
                |     Returns the number of points in the trace.
                | 
                |     Parameters:
                | 
                |         oNbPoints
                |             Long. Contains the number of points.

        :rtype: int
        """

        return self.tcp_trace.TotalPoints

    @property
    def trace_name(self) -> str:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property TraceName() As CATBSTR
                | 
                |     Manage the name of the trace. Property can be retrieved and
                |     valuated
                | 
                |     Parameters:
                | 
                |         oName
                |             CATBSTR. String containing the retrieved name.

        :rtype: str
        """

        return self.tcp_trace.TraceName

    @trace_name.setter
    def trace_name(self, value: str):
        """
        :param str value:
        """

        self.tcp_trace.TraceName = value

    @property
    def visibility(self) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property Visibility() As boolean
                | 
                |     Manage the visibility of the trace. Property can be retrieved and
                |     valuated
                | 
                |         1: shown
                |         0: hidden
                | 
                |     Parameters:
                | 
                |         oVisibility
                |             Boolean. Contains the return value.

        :rtype: bool
        """

        return self.tcp_trace.Visibility

    @visibility.setter
    def visibility(self, value: bool):
        """
        :param bool value:
        """

        self.tcp_trace.Visibility = value

    def export(self, i_name: str) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Export(CATBSTR iName) As long
                | 
                |     Export the TCP trace data in a file. The file format is indicated by the
                |     iFileName extension. Only Excel(Windows NT only) and text files are supported.
                |     If there is already a file at the given location, the user is prompted to
                |     override the file.
                | 
                |     Example :
                |      iFileName = C:/TEMP/MyFile.xls  -> Excel file
                |      iFileName = /usr/tmp/MyFile.txt -> Text file
                | 
                |     Parameters:
                | 
                |         iName
                |             CATBSTR. Input parameter. File path+name+extension.
                |             
                |         oError
                |             Long. Output parameter. Indicates if any error happened.

        :param str i_name:
        :rtype: int
        """
        return self.tcp_trace.Export(i_name)

    def get_attached_owner(self) -> AnyObject:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetAttachedOwner() As AnyObject
                | 
                |     Retrieves the default attached owner of the trace. By default, the owner of
                |     the trace is the robot assembly node. If the robot is moved, the trace will
                |     follow. However, in some scenarios, the trace might be drawn related to another
                |     product (or even with respect to the world) like for example when dealing with
                |     a workpiece positioner.
                | 
                |     Parameters:
                | 
                |         oOwner
                |             CATIABase. Attached owner of the trace. Output parameter. Returns
                |             nothing if the trace is defined related to the world

        :rtype: AnyObject
        """
        return AnyObject(self.tcp_trace.GetAttachedOwner())

    def get_colour(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetColor(DNBTCPTraceReps iRep,
                | long oR,
                | long oG,
                | long oB,
                | long oA)
                | 
                |     Get the TCP trace component (DNBTCPTraceReps) color.
                | 
                |     Parameters:
                | 
                |         iRep
                |             DNBTCPTraceReps. Define the graphical object the method will be
                |             applied on. Input parameter. 
                |         oR
                |             Long. Red color component from 0 to 255. Input parameter.
                |             
                |         oG
                |             Long. Green color component from 0 to 255. Input parameter.
                |             
                |         oB
                |             Long. Blue color component from 0 to 255. Input parameter.
                |             
                |         oA
                |             Long. Alpha color component from 0 to 255. Input parameter.


        :return: enum dnbtcp_trace_reps
        :rtype: int
        """
        return self.tcp_trace.GetColor()

    def get_legends_visibility(self, i_type: int) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetLegendsVisibility(DNBTCPTraceLegends iType) As
                | boolean
                | 
                |     Get the TCP trace component (DNBTCPTraceReps) legend visibility status.
                |     Indicates whether or not at (pre)highlight, some text should be
                |     shown.
                | 
                |     Parameters:
                | 
                |         iType
                |             DNBTCPTraceLegends. Define the kind of legend on which the method
                |             will be applied on. Input parameter. 
                |         obVisible
                |             Boolean. Indicates if it is visible(True) or hidden(False). Output
                |             parameter.

        :param int i_type: enum dnbtcp_trace_legends
        :rtype: bool
        """
        return self.tcp_trace.GetLegendsVisibility(i_type)

    def get_thickness(self, i_rep: int) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetThickness(DNBTCPTraceReps iRep) As long
                | 
                |     Get the TCP trace component (DNBTCPTraceReps) thickness(for line,
                |     axis).
                | 
                |     Parameters:
                | 
                |         iRep
                |             DNBTCPTraceReps. Define the graphical object the method will be
                |             applied on. Input parameter. 
                |         oThickness
                |             Indicates the index width of the line in the range [1,55]. This
                |             index is pointing on the true width in pixel, recorded in the standard (if
                |             there is one in the document) or in the setting. Input parameter.

        :param int i_rep: enum dnbtcp_trace_reps
        :rtype: int
        """
        return self.tcp_trace.GetThickness(i_rep)

    def get_type(self, i_rep: int) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetType(DNBTCPTraceReps iRep) As long
                | 
                |     Get the TCP trace component (DNBTCPTraceReps) type. For points, legal
                |     values are :
                | 
                |         1 : CROSS
                |         2 : PLUS
                |         3 : CONCENTRIC
                | 
                |     For line and axis, legal values are :
                | 
                |         1 : solid
                |         2 : dotted
                |         3 : dashed
                |         4 : dot-dashed
                |         5 : phantom
                | 
                |     Parameters:
                | 
                |         iRep
                |             DNBTCPTraceReps. Define the graphical object the method will be
                |             applied on. Input parameter. 
                |         oType
                |             Long. Depends on the DNBTCPTraceReps. Output parameter. Output
                |             parameter.

        :param int i_rep: enum dnbtcp_trace_reps
        :rtype: int
        """
        return self.tcp_trace.GetType(i_rep)

    def get_visibility(self, i_rep: int) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetVisibility(DNBTCPTraceReps iRep) As boolean
                | 
                |     Get the TCP trace component (DNBTCPTraceReps) visibility
                |     status.
                | 
                |     Parameters:
                | 
                |         iRep
                |             DNBTCPTraceReps. Define the graphical object the method will be
                |             applied on. Input parameter. 
                |         obVisible
                |             Boolean. True for visible and False for hidden. Output parameter.

        :param int i_rep: enum dnbtcp_trace_reps
        :rtype: bool
        """
        return self.tcp_trace.GetVisibility(i_rep)

    def refresh_display(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RefreshDisplay()
                | 
                |     Refresh display. Need to call this method whenever the graphic properties
                |     are changed. By default, when changing the graphic properties, the refresh is
                |     not applied for performance reasons. Caller of the API must call RefreshDisplay
                |     to view the changes in the main viewer.

        :rtype: None
        """
        return self.tcp_trace.RefreshDisplay()

    def reset_attached_owner(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ResetAttachedOwner()
                | 
                |     Resets the attached owner of the trace to the world. When a new trace will
                |     be created, it will defined with respect to the world.
                |     Remark: this will not change the exported values.

        :rtype: None
        """
        return self.tcp_trace.ResetAttachedOwner()

    def reset_graphics(self, b_setting: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ResetGraphics(boolean bSetting)
                | 
                |     Reset the current appearance regarding the current general settings (not
                |     the one applied on the current object). Call < to see the changes
                |     applied.
                | 
                |     Parameters:
                | 
                |         bSetting
                |             Boolean. Indicates if it is visible(True) or hidden(False). Input
                |             parameter.

        :param bool b_setting:
        :rtype: None
        """
        return self.tcp_trace.ResetGraphics(b_setting)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'reset_graphics'
        # # vba_code = """
        # # Public Function reset_graphics(tcp_trace)
        # #     Dim bSetting (2)
        # #     tcp_trace.ResetGraphics bSetting
        # #     reset_graphics = bSetting
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_attached_owner(self, i_owner: AnyObject) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetAttachedOwner(AnyObject iOwner)
                | 
                |     Sets the default attached owner of the trace. By default, the owner of the
                |     trace is the robot. When a new trace is created, the attached owner is used to
                |     set it upon the trace.
                |     Remark: set the attached owner will not change the exported
                |     values.
                | 
                |     Parameters:
                | 
                |         iOwner
                |             CATIABase. Attached owner of the trace. Input parameter.

        :param AnyObject i_owner:
        :rtype: None
        """
        return self.tcp_trace.SetAttachedOwner(i_owner.com_object)

    def set_color(self, i_rep: int, i_r: int, i_g: int, i_b: int, i_a: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetColor(DNBTCPTraceReps iRep,
                | long iR,
                | long iG,
                | long iB,
                | long iA)
                | 
                |     Set the TCP trace component (DNBTCPTraceReps) color. Call < to see the
                |     changes applied.
                | 
                |     Parameters:
                | 
                |         iRep
                |             DNBTCPTraceReps. Define the graphical object the method will be
                |             applied on. Input parameter. 
                |         iR
                |             Long. Red color component from 0 to 255. Input parameter.
                |             
                |         iG
                |             Long. Green color component from 0 to 255. Input parameter.
                |             
                |         iB
                |             Long. Blue color component from 0 to 255. Input parameter.
                |             
                |         iA
                |             Long. Alpha color component from 0 to 255. Input parameter.

        :param int i_rep: enum dnbtcp_trace_reps
        :param int i_r:
        :param int i_g:
        :param int i_b:
        :param int i_a:
        :rtype: None
        """
        return self.tcp_trace.SetColor(i_rep, i_r, i_g, i_b, i_a)

    def set_legends_visibility(self, i_type: int, ib_visible: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetLegendsVisibility(DNBTCPTraceLegends iType,
                | boolean ibVisible)
                | 
                |     Get the TCP trace component (DNBTCPTraceReps) legend visibility status.
                |     Indicates whether or not at (pre)highlight, some text should be shown. Call <
                |     to see the changes applied.
                | 
                |     Parameters:
                | 
                |         iType
                |             DNBTCPTraceLegends. Define the kind of legend on which the method
                |             will be applied on. Input parameter. 
                |         ibVisible
                |             Boolean. Indicates if it is visible(True) or hidden(False). Input
                |             parameter.

        :param int i_type: enum dnbtcp_trace_legends
        :param bool ib_visible:
        :rtype: None
        """
        return self.tcp_trace.SetLegendsVisibility(i_type, ib_visible)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_legends_visibility'
        # # vba_code = """
        # # Public Function set_legends_visibility(tcp_trace)
        # #     Dim iType (2)
        # #     tcp_trace.SetLegendsVisibility iType
        # #     set_legends_visibility = iType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_thickness(self, i_rep: int, i_thickness: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetThickness(DNBTCPTraceReps iRep,
                | long iThickness)
                | 
                |     Set the TCP trace component (DNBTCPTraceReps) thickness(for line, axis).
                |     Call < to see the changes applied.
                | 
                |     Parameters:
                | 
                |         iRep
                |             DNBTCPTraceReps. Define the graphical object the method will be
                |             applied on. Input parameter. 
                |         iThickness
                |             Indicates the index width of the line in the range [1,55]. This
                |             index is pointing on the true width in pixel, recorded in the standard (if
                |             there is one in the document) or in the setting. Input parameter.

        :param int i_rep: enum dnbtcp_trace_reps
        :param int i_thickness:
        :rtype: None
        """
        return self.tcp_trace.SetThickness(i_rep, i_thickness)

    def set_type(self, i_rep: int, i_type: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetType(DNBTCPTraceReps iRep,
                | long iType)
                | 
                |     Set the TCP trace component (DNBTCPTraceReps) type. For points, legal
                |     values are :
                | 
                |         1 : CROSS
                |         2 : PLUS
                |         3 : CONCENTRIC
                | 
                |     For line and axis, legal values are :
                | 
                |         1 : solid
                |         2 : dotted
                |         3 : dashed
                |         4 : dot-dashed
                |         5 : phantom
                | 
                |     Call < to see the changes applied.
                | 
                |     Parameters:
                | 
                |         iRep
                |             DNBTCPTraceReps. Define the graphical object the method will be
                |             applied on. Input parameter. 
                |         iType
                |             Long.Depends on the DNBTCPTraceReps. Input parameter.
                |             
                | 
                |     Returns:
                |         HRESULT Returns S_OK if it succeeds, otherwise E_FAIL.

        :param int i_rep: enum dnbtcp_trace_reps
        :param int i_type:
        :rtype: None
        """
        return self.tcp_trace.SetType(i_rep, i_type)

    def set_visibility(self, i_rep: int, ib_visible: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetVisibility(DNBTCPTraceReps iRep,
                | boolean ibVisible)
                | 
                |     Set the TCP trace component (DNBTCPTraceReps) visible (True) or
                |     hidden(False). Call < to see the changes applied.
                | 
                |     Parameters:
                | 
                |         iRep
                |             DNBTCPTraceReps. Define the graphical object the method will be
                |             applied on. Input parameter. 
                |         ibActiv
                |             Boolean. True for visible and False for hidden. Input parameter.

        :param int i_rep: enum dnbtcp_trace_reps
        :param bool ib_visible:
        :rtype: None
        """
        return self.tcp_trace.SetVisibility(i_rep, ib_visible)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_visibility'
        # # vba_code = """
        # # Public Function set_visibility(tcp_trace)
        # #     Dim iRep (2)
        # #     tcp_trace.SetVisibility iRep
        # #     set_visibility = iRep
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'TCPTrace(name="{self.name}")'
