#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from typing import TYPE_CHECKING

from pycatia.dnb_robot_interfaces.generic_obj_frame_profile import GenericObjFrameProfile
from pycatia.dnb_robot_interfaces.generic_tool_profile import GenericToolProfile
from pycatia.system_interfaces.any_object import AnyObject

if TYPE_CHECKING:
    from pycatia.dnb_robot_interfaces.generic_accuracy_profile import GenericAccuracyProfile
    from pycatia.dnb_robot_interfaces.generic_motion_profile import GenericMotionProfile


class RobGenericController(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     RobGenericController
                | 
                | INTERFACE : DNBIARobGenericController
                | DESCRIPTION This allows add/remove and get/set of controller
                | profiles
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.rob_generic_controller = com_object

    def add_accuracy_profile(self, profile: 'GenericAccuracyProfile') -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddAccuracyProfile(GenericAccuracyProfile profile)
                | 
                |     Add a new Accuracy Profile into controller.
                | 
                |     Parameters:
                | 
                |         profile
                |             interface pointer to Accuracy profile 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param GenericAccuracyProfile profile:
        :rtype: None
        """

        return self.rob_generic_controller.AddAccuracyProfile(profile.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_accuracy_profile'
        # # vba_code = """
        # # Public Function add_accuracy_profile(rob_generic_controller)
        # #     Dim profile (2)
        # #     rob_generic_controller.AddAccuracyProfile profile
        # #     add_accuracy_profile = profile
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_motion_profile(self, profile: 'GenericMotionProfile') -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddMotionProfile(GenericMotionProfile profile)
                | 
                |     Add a new Motion Profile into controller.
                | 
                |     Parameters:
                | 
                |         profile
                |             interface pointer to Motion profile 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param GenericMotionProfile profile:
        :rtype: None
        """
        return self.rob_generic_controller.AddMotionProfile(profile.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_motion_profile'
        # # vba_code = """
        # # Public Function add_motion_profile(rob_generic_controller)
        # #     Dim profile (2)
        # #     rob_generic_controller.AddMotionProfile profile
        # #     add_motion_profile = profile
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_obj_frame_profile(self, profile: GenericObjFrameProfile) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddObjFrameProfile(GenericObjFrameProfile profile)
                | 
                |     Add a new ObjFrame Profile into controller.
                | 
                |     Parameters:
                | 
                |         profile
                |             interface pointer to ObjFrame profile 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param GenericObjFrameProfile profile:
        :rtype: None
        """
        return self.rob_generic_controller.AddObjFrameProfile(profile.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_obj_frame_profile'
        # # vba_code = """
        # # Public Function add_obj_frame_profile(rob_generic_controller)
        # #     Dim profile (2)
        # #     rob_generic_controller.AddObjFrameProfile profile
        # #     add_obj_frame_profile = profile
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_tool_profile(self, i_profile: GenericToolProfile) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddToolProfile(GenericToolProfile iProfile)
                | 
                |     Add a new Tool Profile into controller.
                | 
                |     Parameters:
                | 
                |         profile
                |             interface pointer to tool profile 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param GenericToolProfile i_profile:
        :rtype: None
        """
        return self.rob_generic_controller.AddToolProfile(i_profile.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_tool_profile'
        # # vba_code = """
        # # Public Function add_tool_profile(rob_generic_controller)
        # #     Dim iProfile (2)
        # #     rob_generic_controller.AddToolProfile iProfile
        # #     add_tool_profile = iProfile
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_accuracy_profile(self, name: str, profile: 'GenericAccuracyProfile') -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAccuracyProfile(CATBSTR name,
                | GenericAccuracyProfile profile)
                | 
                |     Get Accuracy profile given name.
                | 
                |     Parameters:
                | 
                |         name
                |             This parameter contains name of the Accuracy profile.
                |             
                |         profile
                |             This outer parameter contains interface pointer to Accuracy
                |             profile. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :param GenericAccuracyProfile profile:
        :rtype: None
        """
        return self.rob_generic_controller.GetAccuracyProfile(name, profile.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_accuracy_profile'
        # # vba_code = """
        # # Public Function get_accuracy_profile(rob_generic_controller)
        # #     Dim name (2)
        # #     rob_generic_controller.GetAccuracyProfile name
        # #     get_accuracy_profile = name
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_accuracy_profile_count(self, count: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAccuracyProfileCount(long count)
                | 
                |     Get number of Accuracy profiles in controller.
                | 
                |     Parameters:
                | 
                |         count
                |             This outer parameter contains number of Accuracy profiles.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param int count:
        :rtype: None
        """
        return self.rob_generic_controller.GetAccuracyProfileCount(count)

    def get_accuracy_profiles(self, profiles: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAccuracyProfiles(CATSafeArrayVariant profiles)
                | 
                |     Get Accuracy profiles list in controller.
                | 
                |     Parameters:
                | 
                |         profiles
                |             This outer parameter contains Accuracy profile list.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |             .

        :param tuple profiles:
        :rtype: None
        """
        return self.rob_generic_controller.GetAccuracyProfiles(profiles)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_accuracy_profiles'
        # # vba_code = """
        # # Public Function get_accuracy_profiles(rob_generic_controller)
        # #     Dim profiles (2)
        # #     rob_generic_controller.GetAccuracyProfiles profiles
        # #     get_accuracy_profiles = profiles
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_current_accuracy_profile(self, profile: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetCurrentAccuracyProfile(CATBSTR profile)
                | 
                |     Get current Accuracy profile name used in controller.
                | 
                |     Parameters:
                | 
                |         profile
                |             This outer parameter contains Accuracy profile name.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str profile:
        :rtype: None
        """
        return self.rob_generic_controller.GetCurrentAccuracyProfile(profile)

    def get_current_motion_profile(self, profile: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetCurrentMotionProfile(CATBSTR profile)
                | 
                |     Get current Motion profile name used in controller.
                | 
                |     Parameters:
                | 
                |         profile
                |             This outer parameter contains Motion profile name.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str profile:
        :rtype: None
        """
        return self.rob_generic_controller.GetCurrentMotionProfile(profile)

    def get_current_obj_frame_profile(self, profile: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetCurrentObjFrameProfile(CATBSTR profile)
                | 
                |     Get current ObjFrame profile name used in controller.
                | 
                |     Parameters:
                | 
                |         profile
                |             This outer parameter contains ObjFrame profile name.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str profile:
        :rtype: None
        """
        return self.rob_generic_controller.GetCurrentObjFrameProfile(profile)

    def get_current_tool_profile(self, profile: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetCurrentToolProfile(CATBSTR profile)
                | 
                |     Get current tool profile name used in controller.
                | 
                |     Parameters:
                | 
                |         profile
                |             This outer parameter contains tool profile name. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str profile:
        :rtype: None
        """
        return self.rob_generic_controller.GetCurrentToolProfile(profile)

    def get_motion_profile(self, name: str, profile: 'GenericMotionProfile') -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetMotionProfile(CATBSTR name,
                | GenericMotionProfile profile)
                | 
                |     Get Motion profile given name.
                | 
                |     Parameters:
                | 
                |         name
                |             This parameter contains name of the Motion profile.
                |             
                |         profile
                |             This outer parameter contains interface pointer to Motion profile.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :param GenericMotionProfile profile:
        :rtype: None
        """
        return self.rob_generic_controller.GetMotionProfile(name, profile.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_motion_profile'
        # # vba_code = """
        # # Public Function get_motion_profile(rob_generic_controller)
        # #     Dim name (2)
        # #     rob_generic_controller.GetMotionProfile name
        # #     get_motion_profile = name
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_motion_profile_count(self, count: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetMotionProfileCount(long count)
                | 
                |     Get number of Motion profiles in controller.
                | 
                |     Parameters:
                | 
                |         count
                |             This outer parameter contains number of Motion profiles.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param int count:
        :rtype: None
        """
        return self.rob_generic_controller.GetMotionProfileCount(count)

    def get_motion_profiles(self, profiles: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetMotionProfiles(CATSafeArrayVariant profiles)
                | 
                |     Get Motion profiles list in controller.
                | 
                |     Parameters:
                | 
                |         profiles
                |             This outer parameter contains Motion profile list.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param tuple profiles:
        :rtype: None
        """
        return self.rob_generic_controller.GetMotionProfiles(profiles)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_motion_profiles'
        # # vba_code = """
        # # Public Function get_motion_profiles(rob_generic_controller)
        # #     Dim profiles (2)
        # #     rob_generic_controller.GetMotionProfiles profiles
        # #     get_motion_profiles = profiles
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_name(self, o_name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetName(CATBSTR oName)
                | 
                |     Retreives name of the generic controller.
                | 
                |     Parameters:
                | 
                |         name
                |             name of the controller to be set. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str o_name:
        :rtype: None
        """
        return self.rob_generic_controller.GetName(o_name)

    def get_obj_frame_profile(self, name: str, profile: GenericObjFrameProfile) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetObjFrameProfile(CATBSTR name,
                | GenericObjFrameProfile profile)
                | 
                |     Get ObjFrame profile given name.
                | 
                |     Parameters:
                | 
                |         name
                |             This parameter contains name of the ObjFrame profile.
                |             
                |         profile
                |             This outer parameter contains interface pointer to ObjFrame
                |             profile. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :param GenericObjFrameProfile profile:
        :rtype: None
        """
        return self.rob_generic_controller.GetObjFrameProfile(name, profile.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_obj_frame_profile'
        # # vba_code = """
        # # Public Function get_obj_frame_profile(rob_generic_controller)
        # #     Dim name (2)
        # #     rob_generic_controller.GetObjFrameProfile name
        # #     get_obj_frame_profile = name
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_obj_frame_profile_count(self, count: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetObjFrameProfileCount(long count)
                | 
                |     Get number of ObjFrame profiles in controller.
                | 
                |     Parameters:
                | 
                |         count
                |             This outer parameter contains number of ObjFrame profiles.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param int count:
        :rtype: None
        """
        return self.rob_generic_controller.GetObjFrameProfileCount(count)

    def get_obj_frame_profiles(self, profiles: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetObjFrameProfiles(CATSafeArrayVariant profiles)
                | 
                |     Get ObjFrame profiles list in controller.
                | 
                |     Parameters:
                | 
                |         profiles
                |             This outer parameter contains ObjFrame profile list.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param tuple profiles:
        :rtype: None
        """
        return self.rob_generic_controller.GetObjFrameProfiles(profiles)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_obj_frame_profiles'
        # # vba_code = """
        # # Public Function get_obj_frame_profiles(rob_generic_controller)
        # #     Dim profiles (2)
        # #     rob_generic_controller.GetObjFrameProfiles profiles
        # #     get_obj_frame_profiles = profiles
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_tool_profile(self, name: str, profile: GenericToolProfile) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetToolProfile(CATBSTR name,
                | GenericToolProfile profile)
                | 
                |     Get tool profile given name.
                | 
                |     Parameters:
                | 
                |         name
                |             This parameter contains name of the tool profile. 
                |         profile
                |             This outer parameter contains interface pointer to tool profile.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :param GenericToolProfile profile:
        :rtype: None
        """
        return self.rob_generic_controller.GetToolProfile(name, profile.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_tool_profile'
        # # vba_code = """
        # # Public Function get_tool_profile(rob_generic_controller)
        # #     Dim name (2)
        # #     rob_generic_controller.GetToolProfile name
        # #     get_tool_profile = name
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_tool_profile_count(self, count: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetToolProfileCount(long count)
                | 
                |     Get number of tool profiles in controller.
                | 
                |     Parameters:
                | 
                |         count
                |             This outer parameter contains number of tool profiles.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param int count:
        :rtype: None
        """
        return self.rob_generic_controller.GetToolProfileCount(count)

    def get_tool_profiles(self, profiles: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetToolProfiles(CATSafeArrayVariant profiles)
                | 
                |     Get tool profiles list in controller.
                | 
                |     Parameters:
                | 
                |         profiles
                |             This outer parameter contains tool profile list. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param tuple profiles:
        :rtype: None
        """
        return self.rob_generic_controller.GetToolProfiles(profiles)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_tool_profiles'
        # # vba_code = """
        # # Public Function get_tool_profiles(rob_generic_controller)
        # #     Dim profiles (2)
        # #     rob_generic_controller.GetToolProfiles profiles
        # #     get_tool_profiles = profiles
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def has_accuracy_profile(self, name: str, flag: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub HasAccuracyProfile(CATBSTR name,
                | boolean flag)
                | 
                |     Check whether given tool profile exists.
                | 
                |     Parameters:
                | 
                |         name
                |             This parameter contains name of the Accuracy profile.
                |             
                |         flag
                |             This outer parameter contains whether Accuracy profile exists.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :param bool flag:
        :rtype: None
        """
        return self.rob_generic_controller.HasAccuracyProfile(name, flag)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'has_accuracy_profile'
        # # vba_code = """
        # # Public Function has_accuracy_profile(rob_generic_controller)
        # #     Dim name (2)
        # #     rob_generic_controller.HasAccuracyProfile name
        # #     has_accuracy_profile = name
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def has_motion_profile(self, name: str, flag: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub HasMotionProfile(CATBSTR name,
                | boolean flag)
                | 
                |     Check whether given Motion profile exists.
                | 
                |     Parameters:
                | 
                |         name
                |             This parameter contains name of the Motion profile.
                |             
                |         flag
                |             This outer parameter contains whether Motion profile exists.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :param bool flag:
        :rtype: None
        """
        return self.rob_generic_controller.HasMotionProfile(name, flag)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'has_motion_profile'
        # # vba_code = """
        # # Public Function has_motion_profile(rob_generic_controller)
        # #     Dim name (2)
        # #     rob_generic_controller.HasMotionProfile name
        # #     has_motion_profile = name
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def has_obj_frame_profile(self, name: str, flag: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub HasObjFrameProfile(CATBSTR name,
                | boolean flag)
                | 
                |     Check whether given ObjFrame profile exists.
                | 
                |     Parameters:
                | 
                |         name
                |             This parameter contains name of the ObjFrame profile.
                |             
                |         flag
                |             This outer parameter contains whether ObjFrame profile exists.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :param bool flag:
        :rtype: None
        """
        return self.rob_generic_controller.HasObjFrameProfile(name, flag)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'has_obj_frame_profile'
        # # vba_code = """
        # # Public Function has_obj_frame_profile(rob_generic_controller)
        # #     Dim name (2)
        # #     rob_generic_controller.HasObjFrameProfile name
        # #     has_obj_frame_profile = name
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def has_tool_profile(self, name: str, flag: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub HasToolProfile(CATBSTR name,
                | boolean flag)
                | 
                |     Check whether given tool profile exists.
                | 
                |     Parameters:
                | 
                |         name
                |             This parameter contains name of the tool profile. 
                |         flag
                |             This outer parameter contains whether tool profile exists.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :param bool flag:
        :rtype: None
        """
        return self.rob_generic_controller.HasToolProfile(name, flag)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'has_tool_profile'
        # # vba_code = """
        # # Public Function has_tool_profile(rob_generic_controller)
        # #     Dim name (2)
        # #     rob_generic_controller.HasToolProfile name
        # #     has_tool_profile = name
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def remove_accuracy_profile(self, name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveAccuracyProfile(CATBSTR name)
                | 
                |     Remove Accuracy profile given name in controller.
                | 
                |     Parameters:
                | 
                |         name
                |             This parameter contains Accuracy profile name. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :rtype: None
        """
        return self.rob_generic_controller.RemoveAccuracyProfile(name)

    def remove_motion_profile(self, name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveMotionProfile(CATBSTR name)
                | 
                |     Remove Motion profile given name in controller.
                | 
                |     Parameters:
                | 
                |         name
                |             This parameter contains Motion profile name. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :rtype: None
        """
        return self.rob_generic_controller.RemoveMotionProfile(name)

    def remove_obj_frame_profile(self, name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveObjFrameProfile(CATBSTR name)
                | 
                |     Remove ObjFrame profile given name in controller.
                | 
                |     Parameters:
                | 
                |         name
                |             This parameter contains ObjFrame profile name. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :rtype: None
        """
        return self.rob_generic_controller.RemoveObjFrameProfile(name)

    def remove_tool_profile(self, name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveToolProfile(CATBSTR name)
                | 
                |     Remove tool profile given name in controller.
                | 
                |     Parameters:
                | 
                |         name
                |             This parameter contains tool profile name. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :rtype: None
        """
        return self.rob_generic_controller.RemoveToolProfile(name)

    def set_current_accuracy_profile(self, profile: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetCurrentAccuracyProfile(CATBSTR profile)
                | 
                |     Make Accuracy profile with given name as current tool profile being used by
                |     controller.
                | 
                |     Parameters:
                | 
                |         profile
                |             This parameter contains Accuracy profile name. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str profile:
        :rtype: None
        """
        return self.rob_generic_controller.SetCurrentAccuracyProfile(profile)

    def set_current_motion_profile(self, profile: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetCurrentMotionProfile(CATBSTR profile)
                | 
                |     Make Motion profile with given name as current tool profile being used by
                |     controller.
                | 
                |     Parameters:
                | 
                |         profile
                |             This parameter contains Motion profile name. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str profile:
        :rtype: None
        """
        return self.rob_generic_controller.SetCurrentMotionProfile(profile)

    def set_current_obj_frame_profile(self, profile: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetCurrentObjFrameProfile(CATBSTR profile)
                | 
                |     Make ObjFrame profile with given name as current ObjFrame profile being
                |     used by controller.
                | 
                |     Parameters:
                | 
                |         profile
                |             This parameter contains ObjFrame profile name. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str profile:
        :rtype: None
        """
        return self.rob_generic_controller.SetCurrentObjFrameProfile(profile)

    def set_current_tool_profile(self, profile: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetCurrentToolProfile(CATBSTR profile)
                | 
                |     Make tool profile with given name as current tool profile being used by
                |     controller.
                | 
                |     Parameters:
                | 
                |         profile
                |             This parameter contains tool profile name. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str profile:
        :rtype: None
        """
        return self.rob_generic_controller.SetCurrentToolProfile(profile)

    def set_name(self, name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetName(CATBSTR name)
                | 
                |     Set name of the generic controller.
                | 
                |     Parameters:
                | 
                |         name
                |             name of the controller to be set. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise

        :param str name:
        :rtype: None
        """
        return self.rob_generic_controller.SetName(name)

    def __repr__(self):
        return f'RobGenericController(name="{self.name}")'
